/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.stringeditor.editor;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.stringeditor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.stringeditor.editor.Messages;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class StringEditorViewerEditableTooltipSupport
extends ColumnViewerToolTipSupport {
    private String tooltipText;
    private final ColumnViewer viewer;
    private Event currentTooltipEvent;
    private final StringEditorPart editor;

    protected StringEditorViewerEditableTooltipSupport(ColumnViewer columnViewer, int n, boolean bl, StringEditorPart stringEditorPart) {
        super(columnViewer, n, bl);
        this.setHideDelay(0);
        this.setHideOnMouseDown(false);
        this.setPopupDelay(100);
        this.setShift(new Point(-3, 0));
        this.tooltipText = null;
        this.viewer = columnViewer;
        this.editor = stringEditorPart;
    }

    public static void enableFor(ColumnViewer columnViewer, int n, StringEditorPart stringEditorPart) {
        new StringEditorViewerEditableTooltipSupport(columnViewer, n, false, stringEditorPart);
    }

    protected Composite createViewerToolTipContentArea(Event event, ViewerCell viewerCell, Composite composite) {
        Composite composite2 = null;
        if (viewerCell.getColumnIndex() != 0) {
            final String string = this.getText(event);
            composite2 = new Composite(composite, 4);
            GridLayout gridLayout = new GridLayout();
            composite2.setLayout((Layout)gridLayout);
            final Text text = new Text(composite2, 66);
            GridData gridData = new GridData(1808);
            gridData.minimumWidth = 200;
            gridData.minimumHeight = 50;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            text.setText(string.trim().length() > 0 ? string : Messages.StringEditorViewerEditableTooltipSupport_0);
            text.setLayoutData((Object)gridData);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    StringEditorViewerEditableTooltipSupport.this.tooltipText = ((Text)modifyEvent.widget).getText();
                }
            });
            text.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent focusEvent) {
                }

                public void focusGained(FocusEvent focusEvent) {
                    if (string.trim().length() == 0) {
                        text.setText("");
                        StringEditorViewerEditableTooltipSupport.this.tooltipText = null;
                    }
                }
            });
        } else {
            composite2 = super.createViewerToolTipContentArea(event, viewerCell, composite);
        }
        this.currentTooltipEvent = event;
        return composite2;
    }

    protected void afterHideToolTip(Event event) {
        ViewerCell viewerCell = this.viewer.getCell(new Point(this.currentTooltipEvent.x, this.currentTooltipEvent.y));
        if (viewerCell.getColumnIndex() != 0) {
            RowInfo rowInfo = (RowInfo)viewerCell.getViewerRow().getElement();
            TableColumn tableColumn = ((Table)this.viewer.getControl()).getColumn(viewerCell.getColumnIndex());
            if (this.tooltipText != null && !this.tooltipText.trim().equals(rowInfo.getCells().get(tableColumn.getText()).getComment())) {
                rowInfo.getCells().get(tableColumn.getText()).setComment(this.tooltipText.trim());
                if (this.editor != null) {
                    try {
                        this.editor.getEditorInput().setCellTooltip(tableColumn.getText(), rowInfo.getKey(), this.tooltipText);
                        this.editor.fireDirtyPropertyChanged();
                    }
                    catch (SequoyahException sequoyahException) {
                        BasePlugin.logError((String)(String.valueOf(Messages.StringEditorViewerEditableTooltipSupport_2) + tableColumn.getText() + ", " + rowInfo.getKey() + Messages.StringEditorViewerEditableTooltipSupport_4 + this.tooltipText), (Throwable)sequoyahException);
                    }
                }
            }
            this.tooltipText = null;
            this.currentTooltipEvent = null;
        }
        super.afterHideToolTip(event);
    }
}

