/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.extensions.implementation.generic;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sequoyah.localization.tools.LocalizationToolsPlugin;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ITranslator;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.TranslatorConstants;
import org.eclipse.sequoyah.localization.tools.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.managers.PreferencesManager;
import org.eclipse.sequoyah.localization.tools.managers.TranslatorManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguagesUtil
implements TranslatorConstants {
    private static Map<String, String> availableLanguages = new LinkedHashMap<String, String>();
    private static Image warningImage = new Image((Device)Display.getDefault(), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK").getImageData().scaledTo(16, 16));
    private static Image okImage = new Image((Device)Display.getDefault(), LocalizationToolsPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sequoyah.localization.tools", (String)"icons/obj16_ok.png").getImageData());

    static {
        availableLanguages.put("AFRIKAANS", "af");
        availableLanguages.put("ALBANIAN", "sq");
        availableLanguages.put("AMHARIC", "am");
        availableLanguages.put("ARABIC", "ar");
        availableLanguages.put("ARMENIAN", "hy");
        availableLanguages.put("AZERBAIJANI", "az");
        availableLanguages.put("BASQUE", "eu");
        availableLanguages.put("BELARUSIAN", "be");
        availableLanguages.put("BENGALI", "bn");
        availableLanguages.put("BIHARI", "bh");
        availableLanguages.put("BULGARIAN", "bg");
        availableLanguages.put("BURMESE", "my");
        availableLanguages.put("CATALAN", "ca");
        availableLanguages.put("CHEROKEE", "chr");
        availableLanguages.put("CHINESE", "zh");
        availableLanguages.put("CHINESE_SIMPLIFIED", "zh-CN");
        availableLanguages.put("CHINESE_TRADITIONAL", "zh-TW");
        availableLanguages.put("CROATIAN", "hr");
        availableLanguages.put("CZECH", "cs");
        availableLanguages.put("DANISH", "da");
        availableLanguages.put("DHIVEHI", "dv");
        availableLanguages.put("DUTCH", "nl");
        availableLanguages.put("ENGLISH", "en");
        availableLanguages.put("ESPERANTO", "eo");
        availableLanguages.put("ESTONIAN", "et");
        availableLanguages.put("FILIPINO", "tl");
        availableLanguages.put("FINNISH", "fi");
        availableLanguages.put("FRENCH", "fr");
        availableLanguages.put("GALACIAN", "gl");
        availableLanguages.put("GEORGIAN", "ka");
        availableLanguages.put("GERMAN", "de");
        availableLanguages.put("GREEK", "el");
        availableLanguages.put("GUARANI", "gn");
        availableLanguages.put("GUJARATI", "gu");
        availableLanguages.put("HEBREW", "iw");
        availableLanguages.put("HINDI", "hi");
        availableLanguages.put("HUNGARIAN", "hu");
        availableLanguages.put("ICELANDIC", "is");
        availableLanguages.put("INDONESIAN", "id");
        availableLanguages.put("INUKTITUT", "iu");
        availableLanguages.put("IRISH", "ga");
        availableLanguages.put("ITALIAN", "it");
        availableLanguages.put("JAPANESE", "ja");
        availableLanguages.put("KANNADA", "kn");
        availableLanguages.put("KAZAKH", "kk");
        availableLanguages.put("KHMER", "km");
        availableLanguages.put("KOREAN", "ko");
        availableLanguages.put("KURDISH", "ku");
        availableLanguages.put("KYRGYZ", "ky");
        availableLanguages.put("LAOTHIAN", "lo");
        availableLanguages.put("LATVIAN", "lv");
        availableLanguages.put("LITHUANIAN", "lt");
        availableLanguages.put("MACEDONIAN", "mk");
        availableLanguages.put("MALAY", "ms");
        availableLanguages.put("MALAYALAM", "ml");
        availableLanguages.put("MALTESE", "mt");
        availableLanguages.put("MARATHI", "mr");
        availableLanguages.put("MONGOLIAN", "mn");
        availableLanguages.put("NEPALI", "ne");
        availableLanguages.put("NORWEGIAN", "no");
        availableLanguages.put("ORIYA", "or");
        availableLanguages.put("PASHTO", "ps");
        availableLanguages.put("PERSIAN", "fa");
        availableLanguages.put("POLISH", "pl");
        availableLanguages.put("PORTUGUESE", "pt");
        availableLanguages.put("PUNJABI", "pa");
        availableLanguages.put("ROMANIAN", "ro");
        availableLanguages.put("RUSSIAN", "ru");
        availableLanguages.put("SANSKRIT", "sa");
        availableLanguages.put("SERBIAN", "sr");
        availableLanguages.put("SINDHI", "sd");
        availableLanguages.put("SINHALESE", "si");
        availableLanguages.put("SLOVAK", "sk");
        availableLanguages.put("SLOVENIAN", "sl");
        availableLanguages.put("SPANISH", "es");
        availableLanguages.put("SWAHILI", "sw");
        availableLanguages.put("SWEDISH", "sv");
        availableLanguages.put("TAJIK", "tg");
        availableLanguages.put("TAMIL", "ta");
        availableLanguages.put("TAGALOG", "tl");
        availableLanguages.put("TELUGU", "te");
        availableLanguages.put("THAI", "th");
        availableLanguages.put("TIBETAN", "bo");
        availableLanguages.put("TURKISH", "tr");
        availableLanguages.put("UKRANIAN", "uk");
        availableLanguages.put("URDU", "ur");
        availableLanguages.put("UZBEK", "uz");
        availableLanguages.put("UIGHUR", "ug");
        availableLanguages.put("VIETNAMESE", "vi");
        availableLanguages.put("WELSH", "cy");
        availableLanguages.put("YIDDISH", "yi");
        availableLanguages.put("VIETNAMESE", "vi");
        availableLanguages.put("WELSH", "cy");
        availableLanguages.put("YIDDISH", "yi");
    }

    public static Set<String> getAvailableLanguages() {
        return availableLanguages.keySet();
    }

    public static String getLanguageID(String string) {
        return availableLanguages.get(string);
    }

    public static String getLanguageName(String string) {
        String string2 = null;
        for (Map.Entry<String, String> entry : availableLanguages.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            string2 = entry.getKey();
            break;
        }
        return string2;
    }

    public static Combo createTranslatorsCombo(Composite composite) {
        Combo combo = null;
        List<ITranslator> list = TranslatorManager.getInstance().getTranslators();
        ITranslator iTranslator = PreferencesManager.getInstance().getDefaultTranslator();
        String string = iTranslator != null ? iTranslator.getName() : "";
        combo = new Combo(composite, 12);
        String[] stringArray = new String[list.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            stringArray[n2] = list.get(n2).getName();
            if (stringArray[n2].equals(string)) {
                n = n2;
            }
            ++n2;
        }
        combo.setItems(stringArray);
        combo.select(n);
        return combo;
    }

    public static Combo createLanguagesCombo(Composite composite, String string, String string2) {
        Combo combo = null;
        String[] stringArray = LanguagesUtil.getAvailableLanguages().toArray(new String[LanguagesUtil.getAvailableLanguages().size()]);
        combo = new Combo(composite, 12);
        if (stringArray.length > 0) {
            combo.setItems(stringArray);
            String string3 = string;
            if (string3 == null) {
                string3 = string2;
            }
            if (string3 != null) {
                String string4 = LanguagesUtil.getLanguageName(string3);
                int n = 0;
                int n2 = 0;
                while (n2 < combo.getItems().length) {
                    String string5 = combo.getItem(n2);
                    if (string5.equals(string4)) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                combo.select(n);
            } else {
                combo.select(0);
            }
        }
        return combo;
    }

    public static Label createImageStatus(Composite composite, String string) {
        Label label = new Label(composite, 0);
        LanguagesUtil.changeImageStatus(label, string);
        return label;
    }

    public static void changeImageStatus(Label label, String string) {
        if (string != null) {
            label.setImage(okImage);
            label.setToolTipText(Messages.TranslationDialog_ImageOKTooltip);
        } else {
            label.setImage(warningImage);
            label.setToolTipText(Messages.TranslationDialog_ImageWARNTooltip);
        }
    }
}

