/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.extensions.implementation.generic;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.LanguagesUtil;
import org.eclipse.sequoyah.localization.tools.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.PreferencesManager;
import org.eclipse.sequoyah.localization.tools.managers.TranslatorManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TranslateColumnInputDialog
extends InputDialog {
    private IProject project = null;
    private final String initialValue;
    private String translator;
    private Combo translatorsCombo = null;
    private Label translatorBrandingImage = null;
    private Combo fromCombo = null;
    private String fromLanguage;
    private Text columnName = null;
    private String selectedColumn = null;
    private String toLanguage;
    private Combo toCombo = null;
    private Button automaticallyAddLangID;

    public TranslateColumnInputDialog(Shell shell, IProject iProject, String string, String string2, String string3, String string4, IInputValidator iInputValidator) {
        super(shell, string2, string3, string4, iInputValidator);
        this.project = iProject;
        this.initialValue = string4;
        this.selectedColumn = string;
    }

    public String getFromLanguage() {
        return LanguagesUtil.getLanguageID(this.fromLanguage);
    }

    public String getToLanguage() {
        return LanguagesUtil.getLanguageID(this.toLanguage);
    }

    public String getTranslator() {
        return this.translator;
    }

    protected Control createDialogArea(Composite composite) {
        ILocalizationSchema iLocalizationSchema = LocalizationManager.getInstance().getLocalizationSchema(this.project);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.columnName = this.getText();
        ComboListener comboListener = new ComboListener();
        Group group = new Group(composite2, 64);
        group.setText(Messages.TranslationDialog_LanguageAreaLabel);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.Translator_Text);
        this.translatorsCombo = LanguagesUtil.createTranslatorsCombo((Composite)group);
        this.translatorsCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.translatorsCombo.addSelectionListener((SelectionListener)comboListener);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(Messages.TranslationDialog_FromLanguage);
        String string = iLocalizationSchema.getISO639LangFromID(this.selectedColumn);
        String string2 = PreferencesManager.getInstance().getProjectPreferencesManager(this.project).getDefaultLanguage();
        this.fromCombo = LanguagesUtil.createLanguagesCombo((Composite)group, string, string2);
        this.fromCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fromCombo.addSelectionListener((SelectionListener)comboListener);
        LanguagesUtil.createImageStatus((Composite)group, string != null ? string : string2);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(Messages.TranslationDialog_ToLanguage);
        this.toCombo = LanguagesUtil.createLanguagesCombo((Composite)group, null, null);
        this.toCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.toCombo.addSelectionListener((SelectionListener)comboListener);
        LanguagesUtil.createImageStatus((Composite)group, null);
        new Label((Composite)group, 0);
        this.automaticallyAddLangID = new Button((Composite)group, 32);
        this.automaticallyAddLangID.setText("Automatically add language ID to column name");
        this.automaticallyAddLangID.setSelection(true);
        Composite composite3 = new Composite(composite2, 131072);
        composite3.setLayout((Layout)new GridLayout(1, false));
        composite3.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.translatorBrandingImage = new Label(composite3, 0);
        this.translatorBrandingImage.setLayoutData((Object)new GridData(4, 128, true, true));
        this.setInitialValues();
        return composite2;
    }

    private void setInitialValues() {
        this.fromLanguage = this.fromCombo.getText();
        this.toLanguage = this.toCombo.getText();
        this.translator = this.translatorsCombo.getText();
        TranslatorManager.getInstance().setTranslatorBranding(this.translator, this.translatorBrandingImage);
    }

    private String getColumnNameWithLangID(String string) {
        String string2 = null;
        string2 = String.valueOf(this.initialValue) + "-" + string;
        return string2;
    }

    class ComboListener
    implements SelectionListener {
        ComboListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource() == TranslateColumnInputDialog.this.fromCombo) {
                TranslateColumnInputDialog.this.fromLanguage = TranslateColumnInputDialog.this.fromCombo.getText();
            } else if (selectionEvent.getSource() == TranslateColumnInputDialog.this.toCombo) {
                TranslateColumnInputDialog.this.toLanguage = TranslateColumnInputDialog.this.toCombo.getText();
                if (TranslateColumnInputDialog.this.automaticallyAddLangID.getSelection()) {
                    TranslateColumnInputDialog.this.columnName.setText(TranslateColumnInputDialog.this.getColumnNameWithLangID(LanguagesUtil.getLanguageID(TranslateColumnInputDialog.this.toLanguage)));
                }
            } else if (selectionEvent.getSource() == TranslateColumnInputDialog.this.translatorsCombo) {
                TranslateColumnInputDialog.this.translator = TranslateColumnInputDialog.this.translatorsCombo.getText();
                TranslatorManager.getInstance().setTranslatorBranding(TranslateColumnInputDialog.this.translator, TranslateColumnInputDialog.this.translatorBrandingImage);
            }
        }
    }
}

