/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.common.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static void copyDir(File file, File file2) throws IOException {
        if (file != null && file.isDirectory() && file.canRead() && file2 != null && file2.isDirectory() && file2.canWrite()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray[n2];
                if (file3.isFile()) {
                    FileUtil.copyFile(file3, new File(file2, file3.getName()));
                } else {
                    File file4 = new File(file2.getAbsolutePath(), file3.getName());
                    file4.mkdir();
                    FileUtil.copyDir(file3, file4);
                }
                ++n2;
            }
        } else {
            String string = "";
            if (file == null) {
                string = "Null pointer for source directory.";
            } else if (!file.isDirectory()) {
                string = String.valueOf(file.getName()) + " is not a directory.";
            } else if (!file.canRead()) {
                string = "Cannot read from " + file.getName() + ".";
            } else if (file2 == null) {
                string = "Null pointer for destination directory.";
            } else if (!file2.isDirectory()) {
                string = String.valueOf(file2.getName()) + " is not a directory.";
            } else if (!file2.canWrite()) {
                string = "Cannot write to" + file2.getName() + ".";
            }
            throw new IOException("Error copying directory: " + string);
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtil.copyFile(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    private static void copyFile(String string, String string2) throws IOException {
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = new FileInputStream(string).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(string2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean deleteDirRecursively(File file) throws IOException {
        String string = "";
        boolean bl = true;
        if (!file.exists()) {
            String string2 = "The directory does not exist.";
            bl = false;
            throw new IOException(string2);
        }
        if (!file.isDirectory()) {
            String string3 = String.valueOf(file.getName()) + " is not a diretory.";
            throw new IOException(string3);
        }
        string = file.getName();
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            bl = fileArray[n].isFile() ? bl && fileArray[n].delete() : bl && this.deleteDirRecursively(fileArray[n]);
            ++n;
        }
        if (!bl) return false;
        if (!file.delete()) return false;
        boolean bl2 = true;
        bl = bl2;
        if (!bl) return bl;
        string.equals("");
        return bl;
    }

    public void deleteFile(File file) throws IOException {
        if (!(file != null && file.exists() && file.isFile() && file.canWrite())) {
            String string = "";
            if (file == null) {
                string = "Null pointer for file to delete.";
            } else if (!file.exists()) {
                string = "The file " + file.getName() + " does not exist.";
            } else if (!file.isFile()) {
                string = String.valueOf(file.getName()) + " is not a file.";
            } else if (!file.canWrite()) {
                string = "Cannot write to " + file.getName();
            }
            throw new IOException("Cannot delete file: " + string);
        }
        file.delete();
    }

    public void deleteFilesOnList(File[] fileArray) throws IOException {
        int n = 0;
        while (n < fileArray.length) {
            this.deleteFile(fileArray[n]);
            ++n;
        }
    }

    public static String getExtension(String string) {
        if (string != null) {
            int n = string.lastIndexOf(".") + 1;
            return n == 0 ? "" : string.substring(n);
        }
        return null;
    }

    public static List<File> getFilesComposingPath(File file) {
        ArrayList<File> arrayList;
        if (file == null) {
            arrayList = new ArrayList();
        } else {
            arrayList = FileUtil.getFilesComposingPath(file.getParentFile());
            arrayList.add(file);
        }
        return arrayList;
    }

    public static String getRelativeFilename(File file, File file2) throws IOException {
        File file3;
        StringBuffer stringBuffer = new StringBuffer();
        List<File> list = FileUtil.getFilesComposingPath(FileUtil.getCanonicalFile(file));
        List<File> list2 = FileUtil.getFilesComposingPath(FileUtil.getCanonicalFile(file2));
        if (list.size() == 0) {
            // empty if block
        }
        if (list2.size() == 0) {
            // empty if block
        }
        int n = -1;
        int n2 = 0;
        while (n2 < list.size() && n2 < list2.size()) {
            File file4;
            file3 = list.get(n2);
            if (!file3.equals(file4 = list2.get(n2))) break;
            n = n2++;
        }
        n2 = n + 1;
        while (n2 < list.size()) {
            stringBuffer.append("..");
            stringBuffer.append(File.separatorChar);
            ++n2;
        }
        n2 = n + 1;
        while (n2 < list2.size()) {
            file3 = list2.get(n2);
            stringBuffer.append(file3.getName());
            if (n2 != list2.size() - 1) {
                stringBuffer.append(File.separatorChar);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public List<String> listFilesRecursively(String string) throws IOException {
        File file = new File(string);
        List<String> list = this.listFilesRecursively(file);
        return list;
    }

    public List<String> listFilesRecursively(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file.exists() && file.isDirectory() && file.canRead()) {
            File[] fileArray;
            File[] fileArray2 = fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                if (file2.isFile()) {
                    arrayList.add(file2.getAbsolutePath());
                } else {
                    List<String> list = this.listFilesRecursively(file2);
                    arrayList.addAll(list);
                }
                ++n2;
            }
        } else {
            String string = "";
            if (!file.exists()) {
                string = "The base dir does not exist.";
            } else if (!file.isDirectory()) {
                string = String.valueOf(file.getName()) + "is not a directory.";
            } else if (!file.canRead()) {
                string = "Cannot fread from " + file.getName() + ".";
            }
            throw new IOException("Error listing files: " + string);
        }
        return arrayList;
    }

    public static File getCanonicalFile(String string) {
        return FileUtil.getCanonicalFile(new File(string));
    }

    public static File getCanonicalFile(File file, String string) {
        return FileUtil.getCanonicalFile(new File(file, string));
    }

    /*
     * Unable to fully structure code
     */
    public static File getCanonicalFile(File var0) {
        block5: {
            var1_1 = null;
            try {
                var1_1 = var0.getCanonicalFile();
                break block5;
            }
            catch (IOException v0) {
                var2_2 = var0.getAbsolutePath();
                var3_3 = new StringTokenizer(var2_2, File.separator);
                var4_4 = new StringBuffer();
                ** while (var3_3.hasMoreTokens())
            }
lbl-1000:
            // 1 sources

            {
                var5_5 = (String)var3_3.nextElement();
                if (var5_5.equals("..")) {
                    var6_6 = var4_4.lastIndexOf(File.separator);
                    if (var6_6 <= 2) continue;
                    var4_4.delete(var6_6, var4_4.length());
                    continue;
                }
                if (var5_5.equals(".")) continue;
                if (var4_4.length() > 0) {
                    var4_4.append(File.separator);
                }
                var4_4.append(var5_5);
                if (!var5_5.endsWith(":")) continue;
                var4_4.append(File.separator);
                continue;
            }
lbl27:
            // 1 sources

            var1_1 = new File(var4_4.toString());
        }
        return var1_1;
    }
}

