/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.qemuarm;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;
import org.eclipse.sequoyah.device.framework.model.IConnection;
import org.eclipse.sequoyah.device.framework.model.IDeviceLauncher;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.qemuarm.QEmuARMPlugin;
import org.eclipse.sequoyah.device.service.start.launcher.DefaultConnection;

public class QEmuARMLauncher
implements IDeviceLauncher {
    public static final String SLASH = "/";
    public IConnection connection = new DefaultConnection();
    private int pid = 0;

    public QEmuARMLauncher(IInstance iInstance) {
        this.connection.setHost(iInstance.getProperties().getProperty("host"));
        this.connection.setDisplay(iInstance.getProperties().getProperty("display"));
        this.connection.setPort(Integer.parseInt(iInstance.getProperties().getProperty("port")));
    }

    public int getPID() {
        return this.pid;
    }

    public void setPID(int n) {
        this.pid = n;
    }

    public String getFileId() {
        return PluginUtils.getPluginInstallationPath((Plugin)QEmuARMPlugin.getDefault()).getAbsolutePath().concat(SLASH).concat("qemu").concat(SLASH).concat("qemuarm.id");
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public String getLocation() {
        String string = null;
        string = Platform.getOS().equals("win32") ? "qemu-arm-vnc.bat" : "qemu-arm-vnc.sh";
        return PluginUtils.getPluginInstallationPath((Plugin)QEmuARMPlugin.getDefault()).getAbsolutePath().concat(SLASH).concat("qemu").concat(SLASH).concat(string);
    }

    public String getToolArguments() {
        return "-kernel integratorcp.zImage -pidfile qemuarm.id -initrd arm_root.img -vnc " + this.connection.getStringHost();
    }

    public String getWorkingDirectory() {
        return PluginUtils.getPluginInstallationPath((Plugin)QEmuARMPlugin.getDefault()).getAbsolutePath().concat(SLASH).concat("qemu").concat(SLASH);
    }
}

