/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.graphics.swt;

import java.io.DataInput;
import org.eclipse.sequoyah.vnc.utilities.logger.Logger;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.sequoyah.vnc.vncviewer.network.IVNCPainter;
import org.eclipse.sequoyah.vnc.vncviewer.network.PixelFormat;
import org.eclipse.sequoyah.vnc.vncviewer.network.RectHeader;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class VNCSWTPainter
implements IVNCPainter,
ISWTPainter {
    static final int RED_MASK = 255;
    static final int GREEN_MASK = 65280;
    static final int BLUE_MASK = 0xFF0000;
    public static final int RAW_ENCODING = 0;
    public static final int COPY_RECT_ENCODING = 1;
    public static final int RRE_ENCODING = 2;
    public static final int HEXTILE_ENCODING = 5;
    public static final int ZRLE_ENCODING = 16;
    private PixelFormat pixelFormat;
    private int fbWidth;
    private int fbHeight;
    private ImageData imgData;

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public void setSize(int n, int n2) {
        this.fbWidth = n;
        this.fbHeight = n2;
        this.imgData = new ImageData(n, n2, this.pixelFormat.getDepth(), new PaletteData(255, 65280, 0xFF0000));
    }

    public void processRectangle(int n, byte[] byArray, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: {
                this.processRaw(byArray, n2, n3, n4, n5);
                break;
            }
            default: {
                Logger.log(VNCSWTPainter.class).error("This encoding is not supported.");
            }
        }
    }

    private void processRaw(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n3 * n4;
        int[] nArray = new int[this.fbWidth * n4];
        int n6 = this.fbWidth - n - n3;
        if (n + n3 <= this.fbWidth && n2 <= this.fbHeight) {
            this.imgData.getPixels(0, n2, this.fbWidth * n4, nArray, 0);
        }
        int n7 = 0;
        while (n7 < n5) {
            int n8;
            int n9 = n7 / n3;
            int n10 = this.pixelFormat.getBitsPerPixel() / 8;
            int n11 = n7 * n10;
            int n12 = 0;
            if (this.pixelFormat.getBigEndianFlag() != 0) {
                n8 = 0;
                while (n8 < n10) {
                    n12 = n12 << 8 | byArray[n11 + n8] & 0xFF;
                    ++n8;
                }
            } else {
                n8 = n10 - 1;
                while (n8 >= 0) {
                    n12 = n12 << 8 | byArray[n11 + n8] & 0xFF;
                    --n8;
                }
            }
            int n13 = n12 >> this.pixelFormat.getRedShift();
            n13 &= this.pixelFormat.getRedMax();
            n13 = n13 * 255 / this.pixelFormat.getRedMax();
            int n14 = n12 >> this.pixelFormat.getGreenShift();
            n14 &= this.pixelFormat.getGreenMax();
            n14 = n14 * 255 / this.pixelFormat.getGreenMax();
            int n15 = n12 >> this.pixelFormat.getBlueShift();
            n15 &= this.pixelFormat.getBlueMax();
            n15 = n15 * 255 / this.pixelFormat.getBlueMax();
            nArray[n9 * n6 + n7 + (n9 + 1) * n] = n12 = n15 << 16 | n14 << 8 | n13;
            ++n7;
        }
        this.imgData.setPixels(0, n2, this.fbWidth * n4, nArray, 0);
    }

    public void render() {
    }

    public ImageData getImageData() {
        return this.imgData;
    }

    public int getHeight() {
        return this.fbHeight;
    }

    public int getWidth() {
        return this.fbWidth;
    }

    public int[] getSupportedEncodings() {
        return null;
    }

    public void processRectangle(RectHeader rectHeader, DataInput dataInput) throws Exception {
    }

    public void updateRectangle(int n, int n2, int n3, int n4) {
    }
}

