/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.standalone;

import java.util.Properties;
import org.eclipse.sequoyah.vnc.utilities.logger.Logger;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.imgdata.SWTRemoteDisplayImgData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class StandaloneVNCViewer {
    private static Canvas canvas;
    private static int WINDOW_WIDTH;
    private static int WINDOW_HEIGHT;
    private static String host;
    private static int port;

    static {
        WINDOW_WIDTH = 700;
        WINDOW_HEIGHT = 500;
        host = "127.0.0.1";
        port = 5900;
    }

    public static void addKeyEventListener(Composite composite) {
        final SWTRemoteDisplay sWTRemoteDisplay = new SWTRemoteDisplay(composite, new Properties(), null);
        final Display display = composite.getDisplay();
        try {
            sWTRemoteDisplay.start(null);
        }
        catch (Exception exception) {
            Logger.log(StandaloneVNCViewer.class).error("The viewer can not be started.");
        }
        canvas = sWTRemoteDisplay.getCanvas();
        canvas.setFocus();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                final Event event2 = event;
                display.syncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Canvas canvas = sWTRemoteDisplay.getCanvas();
                        synchronized (canvas) {
                            try {
                                sWTRemoteDisplay.keyEvent(event2);
                                sWTRemoteDisplay.updateScreen();
                            }
                            catch (Exception exception) {
                                Logger.log(StandaloneVNCViewer.class).error("VNC View error on key event.");
                            }
                            canvas.redraw();
                        }
                    }
                });
            }
        };
        canvas.addListener(1, listener);
    }

    public static void updateScreenLoop(Composite composite) {
        SWTRemoteDisplayImgData sWTRemoteDisplayImgData = new SWTRemoteDisplayImgData(composite, new Properties(), null);
        try {
            sWTRemoteDisplayImgData.start(null);
        }
        catch (Exception exception) {
            Logger.log(StandaloneVNCViewer.class).error("The viewer can not be started.");
        }
        while (!composite.isDisposed()) {
            try {
                sWTRemoteDisplayImgData.updateScreen();
                sWTRemoteDisplayImgData.wait(500L);
            }
            catch (Exception exception) {
                Logger.log(StandaloneVNCViewer.class).error("Error on Loop test.");
            }
        }
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        if (stringArray.length != 2) {
            Logger.log(StandaloneVNCViewer.class).error("[host] [port] expected.");
            return;
        }
        host = stringArray[0];
        port = Integer.valueOf(stringArray[1]);
        shell.setBounds(0, 0, WINDOW_WIDTH, WINDOW_HEIGHT);
        shell.open();
        StandaloneVNCViewer.updateScreenLoop((Composite)shell);
        display.dispose();
    }
}

