/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android.datamodel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.StringArray;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNode;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidLocalizationFile
extends LocalizationFile {
    private Document savedXMLDocument = null;
    private Map<String, StringNode> singleEntryToRemove = new HashMap<String, StringNode>();
    private Map<String, StringNode> arrayItemsToRemove = new HashMap<String, StringNode>();
    private Map<String, StringArray> arrayEntryToRemove = new HashMap<String, StringArray>();

    public AndroidLocalizationFile(IFile iFile, LocaleInfo localeInfo, List<StringNode> list, List<StringArray> list2) {
        super(iFile, localeInfo, list, list2);
    }

    public Document getSavedXMLDocument() {
        return this.savedXMLDocument;
    }

    public void setSavedXMLDocument(Document document) {
        this.savedXMLDocument = document;
    }

    public void removeStringNode(StringNode stringNode) {
        if (this.getStringNodes().contains(stringNode)) {
            this.getStringNodes().remove(stringNode);
            this.getStringNodesMap().remove(stringNode.getKey());
            this.setDirty(true);
            if (stringNode.isArray()) {
                stringNode.getStringArray().removeValue(stringNode);
                if (stringNode.getStringArray().getValues().size() == 0) {
                    this.getStringArrays().remove(stringNode.getStringArray());
                    this.arrayEntryToRemove.put(stringNode.getStringArray().getKey(), stringNode.getStringArray());
                } else {
                    this.arrayItemsToRemove.put(stringNode.getKey(), stringNode);
                }
            } else {
                this.singleEntryToRemove.put(stringNode.getKey(), stringNode);
            }
        }
    }

    public Map<String, StringNode> getSingleEntryToRemove() {
        return this.singleEntryToRemove;
    }

    public Map<String, StringNode> getArrayItemsToRemove() {
        return this.arrayItemsToRemove;
    }

    public Map<String, StringArray> getArrayEntryToRemove() {
        return this.arrayEntryToRemove;
    }
}

