/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.datamodel;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArray {
    private LocalizationFile localizationFile = null;
    private String key = null;
    private Map<Integer, StringNode> values = null;

    public StringArray(String string) {
        this.key = string;
        this.values = new HashMap<Integer, StringNode>();
    }

    public LocalizationFile getLocalizationFile() {
        return this.localizationFile;
    }

    public void setLocalizationFile(LocalizationFile localizationFile) {
        this.localizationFile = localizationFile;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public List<StringNode> getValues() {
        List<StringNode> list = new ArrayList<StringNode>();
        int n = this.getLastIndex();
        if (n >= 0) {
            StringNode[] stringNodeArray = new StringNode[n + 1];
            int n2 = 0;
            while (n2 <= n) {
                stringNodeArray[n2] = new StringNode("", "");
                ++n2;
            }
            for (Map.Entry<Integer, StringNode> entry : this.values.entrySet()) {
                stringNodeArray[entry.getKey().intValue()] = entry.getValue();
            }
            list = Arrays.asList(stringNodeArray);
        }
        return list;
    }

    public StringNode addValue(String string) {
        return this.addValue(string, null);
    }

    public StringNode addValue(String string, Integer n) {
        Object object;
        StringNode stringNode = null;
        if (n == null) {
            int n2 = -1;
            if (this.values.size() > 0) {
                object = this.values.get(this.values.size() - 1);
                n2 = Integer.parseInt(((StringNode)object).getKey().split("_")[1]);
            }
            n = n2 + 1;
        }
        DecimalFormat decimalFormat = new DecimalFormat("000");
        object = String.valueOf(this.key) + "_" + decimalFormat.format(n.intValue());
        stringNode = new StringNode((String)object, string);
        stringNode.setArray(true);
        stringNode.setStringArray(this);
        this.values.put(new Integer(n), stringNode);
        return stringNode;
    }

    private int getLastIndex() {
        int n = -1;
        for (Map.Entry<Integer, StringNode> entry : this.values.entrySet()) {
            if (entry.getKey() <= n) continue;
            n = entry.getKey();
        }
        return n;
    }

    public void removeValue(StringNode stringNode) {
        int n = StringArray.findItemPosition(stringNode.getKey());
        this.values.remove(new Integer(n));
    }

    public boolean isPartOfTheArray(String string) {
        boolean bl = false;
        String string2 = StringArray.getArrayKeyFromItemKey(string);
        if (string2 != null) {
            bl = this.key.equals(string2);
        }
        return bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        return this.getKey().equals(((StringArray)object).getKey());
    }

    public static boolean isArrayItem(String string) {
        boolean bl = true;
        try {
            int n = string.lastIndexOf("_");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if (string2 == null || string2.equals("")) {
                bl = false;
            }
            if (string3 == null || string3.equals("") || string3.length() != 3) {
                bl = false;
            }
            Integer.parseInt(string3);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static int findItemPosition(String string) {
        int n = -1;
        try {
            int n2 = string.lastIndexOf("_");
            n = Integer.parseInt(string.substring(n2 + 1, string.length()));
        }
        catch (Exception exception) {}
        return n;
    }

    public static String getArrayKeyFromItemKey(String string) {
        String string2 = null;
        try {
            int n = string.lastIndexOf("_");
            string2 = string.substring(0, n);
        }
        catch (Exception exception) {}
        return string2;
    }
}

