/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.managers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.tools.datamodel.GrammarCheckerResult;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationProject;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNode;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.managers.ProjectPreferencesManager;
import org.eclipse.sequoyah.localization.tools.persistence.ProjectPersistenceManager;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLocalizationManager {
    private LocalizationProject localizationProject;
    private ProjectPersistenceManager projectPersistenceManager;
    private ProjectPreferencesManager projectPreferencesManager;
    private ILocalizationSchema projectLocalizationSchema;
    private IProject project;

    public ProjectLocalizationManager(IProject iProject, ILocalizationSchema iLocalizationSchema) {
        this.projectPersistenceManager = new ProjectPersistenceManager(this.localizationProject);
        this.projectPreferencesManager = new ProjectPreferencesManager(iProject);
        this.projectLocalizationSchema = iLocalizationSchema;
        try {
            ArrayList<LocalizationFile> arrayList = new ArrayList<LocalizationFile>();
            arrayList.addAll(this.projectLocalizationSchema.loadAllFiles(iProject).values());
            this.localizationProject = new LocalizationProject(iProject, arrayList);
            this.project = iProject;
            this.syncDefaultColumn();
        }
        catch (IOException iOException) {
            BasePlugin.logError((String)("Could not load the localization manager: " + iOException.getMessage()));
        }
    }

    public void reload() {
        ArrayList<LocalizationFile> arrayList = new ArrayList<LocalizationFile>();
        List<Object> list = new ArrayList();
        HashMap<IFile, LocalizationFile> hashMap = new HashMap<IFile, LocalizationFile>();
        list = this.getLocalizationProject().getLocalizationFiles();
        try {
            arrayList.addAll(this.projectLocalizationSchema.loadAllFiles(this.project).values());
            for (LocalizationFile localizationFile : arrayList) {
                hashMap.put(localizationFile.getFile(), localizationFile);
            }
            for (LocalizationFile localizationFile : list) {
                if (hashMap.get(localizationFile.getFile()) != null) continue;
                arrayList.add(localizationFile);
            }
            this.localizationProject.getLocalizationFiles().clear();
            for (LocalizationFile localizationFile : arrayList) {
                this.localizationProject.addLocalizationFile(localizationFile);
            }
            this.syncDefaultColumn();
        }
        catch (IOException iOException) {}
    }

    private void syncNodes(LocalizationFile localizationFile, LocalizationFile localizationFile2) {
        for (StringNode stringNode : localizationFile2.getStringNodes()) {
            localizationFile.getStringNodeByKey(stringNode.getKey());
        }
    }

    private void syncDefaultColumn() {
        LocalizationFile localizationFile = this.localizationProject.getLocalizationFile(this.getProjectLocalizationSchema().getLocaleInfoFromID(this.getProjectLocalizationSchema().getDefaultID()));
        if (localizationFile != null) {
            for (LocalizationFile localizationFile2 : this.localizationProject.getLocalizationFiles()) {
                if (localizationFile2 == localizationFile) continue;
                this.syncNodes(localizationFile, localizationFile2);
            }
        }
    }

    public List<LocaleInfo> getAvailableLocales() {
        ArrayList<LocaleInfo> arrayList = new ArrayList<LocaleInfo>();
        List<LocalizationFile> list = this.localizationProject.getLocalizationFiles();
        for (LocalizationFile localizationFile : list) {
            arrayList.add(localizationFile.getLocaleInfo());
        }
        return arrayList;
    }

    public boolean createOrUpdateFile(LocaleInfo localeInfo, List<StringNode> list) {
        LocalizationFile localizationFile = this.getProjectLocalizationSchema().createLocalizationFile(null, localeInfo, list, null);
        try {
            this.projectLocalizationSchema.createFile(localizationFile);
        }
        catch (SequoyahException sequoyahException) {
            BasePlugin.logInfo((String)"Error while creating file");
        }
        return true;
    }

    public boolean saveProject() {
        this.syncDefaultColumn();
        List<LocalizationFile> list = this.localizationProject.getLocalizationFiles();
        for (LocalizationFile object22 : list) {
            if (!object22.isToBeDeleted()) {
                if (object22.isDirty()) {
                    try {
                        this.projectLocalizationSchema.updateFile(object22);
                    }
                    catch (SequoyahException sequoyahException) {
                        BasePlugin.logInfo((String)"Error while updating file");
                    }
                }
                if (!object22.isDirtyMetaExtraData()) continue;
                this.projectPersistenceManager.saveData();
                continue;
            }
            try {
                Object coreException;
                object22.getFile().delete(true, null);
                if (object22.getFile().getLocation() == null || !((File)(coreException = new File(object22.getFile().getLocation().removeLastSegments(1).toOSString()))).exists() || !((File)coreException).isDirectory() || ((File)coreException).listFiles().length != 0) continue;
                ((File)coreException).delete();
            }
            catch (CoreException coreException) {
                BasePlugin.logError((String)("Could not delete file: " + coreException.getMessage()));
            }
        }
        ArrayList<LocalizationFile> arrayList = new ArrayList<LocalizationFile>(list);
        for (Object localizationFile : arrayList) {
            if (!((LocalizationFile)localizationFile).isToBeDeleted()) continue;
            this.localizationProject.removeLocalizationFile((LocalizationFile)localizationFile);
        }
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ProjectLocalizationManager.this.localizationProject.getProject().refreshLocal(2, iProgressMonitor);
                    }
                    catch (CoreException coreException) {}
                }
            }, null);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        this.localizationProject.setDirty(false);
        return true;
    }

    public void translateAndCreateFile(LocalizationFile localizationFile, LocaleInfo localeInfo) {
    }

    public List<GrammarCheckerResult> checkGrammar(LocalizationFile localizationFile) {
        return null;
    }

    public Map<LocalizationFile, List<GrammarCheckerResult>> checkAllGrammar() {
        return null;
    }

    public LocalizationProject getLocalizationProject() {
        return this.localizationProject;
    }

    public void clearMetaData(Class clazz) {
    }

    public void clearExtraInfo(Class clazz) {
    }

    public void markFileForDeletion(LocalizationFile localizationFile) {
        localizationFile.setToBeDeleted(true);
    }

    public void deleteFileMetaExtraData(IFile iFile) {
    }

    public ILocalizationSchema getProjectLocalizationSchema() {
        return this.projectLocalizationSchema;
    }

    public ProjectPersistenceManager getProjectPersistenceManager() {
        return this.projectPersistenceManager;
    }

    public ProjectPreferencesManager getProjectPreferencesManager() {
        return this.projectPreferencesManager;
    }

    public LocaleInfo getLocaleInfoForFile(IFile iFile) {
        LocaleInfo localeInfo = null;
        List<LocalizationFile> list = this.localizationProject.getLocalizationFiles();
        for (LocalizationFile localizationFile : list) {
            if (!localizationFile.getFile().equals((Object)iFile)) continue;
            localeInfo = localizationFile.getLocaleInfo();
        }
        return localeInfo;
    }
}

