/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib.internal.engine;

import java.io.DataInput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.vnc.protocol.lib.IRawDataHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.MessageFieldsStore;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidInputStreamDataException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.MessageHandleException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.ProtocolEngineUtils;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.ProtocolMsgDefinition;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.FixedSizeDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.IMsgDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.IteratableBlockDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.RawDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.VariableSizeDataBean;

class MessageReader {
    MessageReader() {
    }

    static ProtocolMessage readReceivedMessage(DataInput dataInput, long l, ProtocolMsgDefinition protocolMsgDefinition, ProtocolEngine protocolEngine) throws ProtocolRawHandlingException, InvalidDefinitionException, InvalidInputStreamDataException, InvalidMessageException, MessageHandleException, IOException {
        ProtocolMessage protocolMessage = null;
        if (ProtocolEngineUtils.isIncomingMessage(protocolMsgDefinition.getId(), protocolEngine.getIncomingMessages(), protocolEngine.getOutgoingMessages())) {
            protocolMessage = new ProtocolMessage(l);
            List<IMsgDataBean> list = protocolMsgDefinition.getMessageData();
            for (IMsgDataBean iMsgDataBean : list) {
                MessageReader.readFilterMessageDef(dataInput, iMsgDataBean, protocolMessage, null, -1, protocolEngine);
            }
        } else {
            BasePlugin.logWarning((String)"The code does not identify an incomming message. It will not be ignored.");
        }
        return protocolMessage;
    }

    private static void readFilterMessageDef(DataInput dataInput, IMsgDataBean iMsgDataBean, ProtocolMessage protocolMessage, String string, int n, ProtocolEngine protocolEngine) throws ProtocolRawHandlingException, InvalidDefinitionException, InvalidInputStreamDataException, IOException {
        if (iMsgDataBean instanceof FixedSizeDataBean) {
            MessageReader.readFixedSizeData(dataInput, (FixedSizeDataBean)iMsgDataBean, protocolMessage, string, n, protocolEngine);
            FixedSizeDataBean fixedSizeDataBean = (FixedSizeDataBean)iMsgDataBean;
            protocolMessage.setFieldSize(fixedSizeDataBean.getFieldName(), string, n, fixedSizeDataBean.getFieldSizeInBytes());
        } else if (iMsgDataBean instanceof VariableSizeDataBean) {
            MessageReader.readVariableSizeData(dataInput, (VariableSizeDataBean)iMsgDataBean, protocolMessage, string, n, protocolEngine);
            VariableSizeDataBean variableSizeDataBean = (VariableSizeDataBean)iMsgDataBean;
            protocolMessage.setFieldSize(variableSizeDataBean.getSizeFieldName(), string, n, variableSizeDataBean.getSizeFieldSizeInBytes());
        } else if (iMsgDataBean instanceof RawDataBean) {
            MessageReader.readRawData(dataInput, (RawDataBean)iMsgDataBean, protocolMessage, string, n, protocolEngine);
        } else {
            MessageReader.readIteratableBlock(dataInput, (IteratableBlockDataBean)iMsgDataBean, protocolMessage, protocolEngine);
        }
    }

    private static void readFixedSizeData(DataInput dataInput, FixedSizeDataBean fixedSizeDataBean, ProtocolMessage protocolMessage, String string, int n, ProtocolEngine protocolEngine) throws InvalidDefinitionException, InvalidInputStreamDataException, IOException {
        String string2 = fixedSizeDataBean.getFieldName();
        boolean bl = fixedSizeDataBean.isFieldSigned();
        int n2 = fixedSizeDataBean.getFieldSizeInBytes();
        if (string2 != null) {
            Number number = MessageReader.getNumberDataFromInputStream(dataInput, n2, bl, protocolEngine);
            if (number != null) {
                protocolMessage.setFieldValue(string2, string, n, number);
            }
        } else {
            BasePlugin.logError((String)"The field name was not provided by the message definition.");
            throw new InvalidDefinitionException("Incomplete fixed data element");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void readVariableSizeData(DataInput dataInput, VariableSizeDataBean variableSizeDataBean, ProtocolMessage protocolMessage, String string, int n, ProtocolEngine protocolEngine) throws InvalidDefinitionException, InvalidInputStreamDataException, IOException {
        String string2 = variableSizeDataBean.getSizeFieldName();
        boolean bl = variableSizeDataBean.isSizeFieldSigned();
        int n2 = variableSizeDataBean.getSizeFieldSizeInBytes();
        String string3 = variableSizeDataBean.getValueFieldName();
        String string4 = variableSizeDataBean.getCharsetName();
        if (string3 != null) {
            Number number = MessageReader.getNumberDataFromInputStream(dataInput, n2, bl, protocolEngine);
            byte[] byArray = new byte[number.intValue()];
            try {
                dataInput.readFully(byArray);
            }
            catch (IOException iOException) {
                BasePlugin.logWarning((String)"An IOException was detected while reading the variable size field. Requesting restart.");
                protocolEngine.requestRestart();
                throw iOException;
            }
            try {
                String string5 = new String(byArray, string4);
                protocolMessage.setFieldValue(string3, string, n, string5);
                if (string2 == null || string2.equals("")) return;
                protocolMessage.setFieldValue(string2, string, n, new Integer(n2).toString());
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                BasePlugin.logError((String)"An invalid charset name was provided for the field");
                throw new InvalidDefinitionException("Invalid charset name provided at message definition", unsupportedEncodingException);
            }
        }
        BasePlugin.logError((String)"The field name was not provided by the message definition.");
        throw new InvalidDefinitionException("Incomplete fixed data element");
    }

    private static void readRawData(DataInput dataInput, RawDataBean rawDataBean, ProtocolMessage protocolMessage, String string, int n, ProtocolEngine protocolEngine) throws ProtocolRawHandlingException, IOException {
        IRawDataHandler iRawDataHandler = rawDataBean.getHandler();
        MessageFieldsStore messageFieldsStore = new MessageFieldsStore(protocolMessage, string, n);
        Map<String, Object> map = null;
        try {
            map = iRawDataHandler.readRawDataFromStream(protocolEngine.getHandle(), dataInput, messageFieldsStore, protocolEngine.isBigEndianProtocol());
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                protocolMessage.setFieldValue(string2, string, n, object);
            }
        }
        catch (IOException iOException) {
            BasePlugin.logWarning((String)"An IOException was thrown by the raw field handler. A restart is being requested.");
            protocolEngine.requestRestart();
            throw iOException;
        }
    }

    private static void readIteratableBlock(DataInput dataInput, IteratableBlockDataBean iteratableBlockDataBean, ProtocolMessage protocolMessage, ProtocolEngine protocolEngine) throws ProtocolRawHandlingException, InvalidDefinitionException, InvalidInputStreamDataException, IOException {
        String string = iteratableBlockDataBean.getIterateOnField();
        String string2 = iteratableBlockDataBean.getId();
        Object object = protocolMessage.getFieldValue(string);
        if (object instanceof Integer) {
            int n = (Integer)object;
            Collection<IMsgDataBean> collection = iteratableBlockDataBean.getDataBeans();
            int n2 = 0;
            while (n2 < n) {
                for (IMsgDataBean iMsgDataBean : collection) {
                    MessageReader.readFilterMessageDef(dataInput, iMsgDataBean, protocolMessage, string2, n2, protocolEngine);
                }
                ++n2;
            }
        } else {
            BasePlugin.logError((String)"It was not possible to determine how many iterations are expected.");
            throw new InvalidInputStreamDataException("Iterate on field value is not numeric");
        }
    }

    private static Number getNumberDataFromInputStream(DataInput dataInput, int n, boolean bl, ProtocolEngine protocolEngine) throws InvalidInputStreamDataException, IOException {
        Number number = null;
        try {
            switch (n) {
                case 1: {
                    number = bl ? (Number)dataInput.readByte() : (Number)dataInput.readUnsignedByte();
                    break;
                }
                case 2: {
                    number = bl ? (Number)dataInput.readShort() : (Number)dataInput.readUnsignedShort();
                    break;
                }
                case 3: {
                    if (bl) {
                        long l = dataInput.readByte();
                        l <<= 8;
                        number = l += (long)dataInput.readShort();
                    } else {
                        long l = dataInput.readUnsignedByte();
                        l <<= 8;
                        number = l += (long)dataInput.readUnsignedShort();
                    }
                    break;
                }
                case 4: {
                    number = dataInput.readInt();
                    break;
                }
                case 8: {
                    number = dataInput.readLong();
                    break;
                }
                default: {
                    BasePlugin.logError((String)"It is not possible to read the number, because it doesn't have a supported field size.");
                    throw new InvalidInputStreamDataException("Unrecognized field size");
                }
            }
        }
        catch (IOException iOException) {
            BasePlugin.logWarning((String)"An IOException was detected while reading from input stream. Requesting a restart.");
            protocolEngine.requestRestart();
            throw iOException;
        }
        return number;
    }
}

