/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android;

import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.android.AndroidLocaleAttribute;
import org.eclipse.sequoyah.localization.android.i18n.Messages;
import org.eclipse.sequoyah.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.TranslationInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleAttribute;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.StringArray;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNode;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNodeComment;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.NewRowInputDialog;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.TranslateColumnInputDialog;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.TranslateColumnsInputDialog;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.ProjectLocalizationManager;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidLocalizationSchema
extends ILocalizationSchema {
    private final String RESOURCES_FOLDER = "res";
    private final String DEFAULT_LOCALE_TOOLTIP = Messages.AndroidLocalizationSchema_Default_Andr_Localization_File_Tooltip;
    public static final String LOCALIZATION_FILES_FOLDER = "values";
    public static final String LOCALIZATION_FILE_NAME = "strings.xml";
    private final String FILE_EXTENSION = "xml";
    private final String LF_REGULAR_EXPRESSION = "res/values.*/strings.xml";
    private final String XML_RESOURCES_TAG = "resources";
    private final String XML_STRING_TAG = "string";
    private final String XML_STRING_ARRAY_TAG = "string-array";
    private final String XML_STRING_ARRAY_ITEM_TAG = "item";
    private final String XML_STRING_ATTR_NAME = "name";
    private final String NEW_COLUMN_TITLE = Messages.AndroidNewColumnProvider_NewColumnTitle;
    private final String NEW_TRANSLATE_COLUMN_TITLE = Messages.AndroidTranslatedColumnProvider_NewColumnTitle;
    private final String TRANSLATE_CELLS_TITLE = Messages.AndroidTranslateCells_DialogTitle;
    private final String NEW_ROW_TITLE = Messages.AndroidNewRow_DialogTitle;
    private final String NEW_COLUMN_DESCRIPTION = Messages.AndroidNewColumnProvider_NewColumnDescription;
    private final String NEW_COLUMN_TEXT = "values";
    private final String NEW_COLUMN_INVALID_ID = Messages.AndroidNewColumnProvider_InvalidNewColumID;
    private String MANDATORY_ID = "values";
    private final String QUALIFIER_SEP = "-";

    public IStatus isValueValid(String string, String string2, String string3) {
        Status status = new Status(0, "org.eclipse.sequoyah.localization.android", "");
        if (string.toLowerCase().equals(this.MANDATORY_ID.toLowerCase())) {
            if (string3 == null) {
                status = new Status(4, "org.eclipse.sequoyah.localization.android", Messages.EmptyKey_Discouraged);
            }
            if (string3 == null || string3.length() == 0) {
                status = new Status(2, "org.eclipse.sequoyah.localization.android", Messages.EmptyKey_Discouraged);
            }
        }
        return status;
    }

    public ColumnInfo promptCollumnName(final IProject iProject) {
        ColumnInfo columnInfo = null;
        InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.NEW_COLUMN_TITLE, this.NEW_COLUMN_DESCRIPTION, LOCALIZATION_FILES_FOLDER, new IInputValidator(){

            public String isValid(String string) {
                return AndroidLocalizationSchema.this.isValid2(string, iProject);
            }
        });
        if (inputDialog.open() == 0) {
            columnInfo = new ColumnInfo(inputDialog.getValue(), inputDialog.getValue(), null, true);
        }
        return columnInfo;
    }

    public RowInfo[] promptRowName(IProject iProject) {
        RowInfo[] rowInfoArray = null;
        NewRowInputDialog newRowInputDialog = new NewRowInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iProject, this.NEW_ROW_TITLE);
        if (newRowInputDialog.open() == 0) {
            rowInfoArray = new RowInfo[newRowInputDialog.getNumEntries()];
            String string = newRowInputDialog.getKey();
            boolean bl = newRowInputDialog.isArray();
            int n = 0;
            while (n < newRowInputDialog.getNumEntries()) {
                rowInfoArray[n] = new RowInfo(string, bl, null);
                ++n;
            }
        }
        return rowInfoArray;
    }

    public TranslationInfo promptTranslatedCollumnName(final IProject iProject, String string) {
        TranslationInfo translationInfo = null;
        TranslateColumnInputDialog translateColumnInputDialog = new TranslateColumnInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iProject, string, this.NEW_TRANSLATE_COLUMN_TITLE, this.NEW_COLUMN_DESCRIPTION, LOCALIZATION_FILES_FOLDER, new IInputValidator(){

            public String isValid(String string) {
                return AndroidLocalizationSchema.this.isValid2(string, iProject);
            }
        });
        if (translateColumnInputDialog.open() == 0) {
            translationInfo = new TranslationInfo(translateColumnInputDialog.getValue(), translateColumnInputDialog.getValue(), null, true, translateColumnInputDialog.getFromLanguage(), translateColumnInputDialog.getToLanguage(), null, translateColumnInputDialog.getTranslator());
        }
        return translationInfo;
    }

    public TranslationInfo[] promptTranslatedCollumnsName(IProject iProject, String string, String[] stringArray, String[] stringArray2, TableColumn[] tableColumnArray) {
        TranslationInfo[] translationInfoArray = null;
        TranslateColumnsInputDialog translateColumnsInputDialog = new TranslateColumnsInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iProject, string, stringArray2, tableColumnArray, this.TRANSLATE_CELLS_TITLE);
        if (translateColumnsInputDialog.open() == 0) {
            List list = translateColumnsInputDialog.getDestinationColumns();
            translationInfoArray = new TranslationInfo[stringArray2.length * list.size()];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String string2 = stringArray2[n2];
                String string3 = stringArray[n2];
                int n3 = 0;
                while (n3 < list.size()) {
                    TranslateColumnsInputDialog.DestinationColumn destinationColumn = (TranslateColumnsInputDialog.DestinationColumn)list.get(n3);
                    translationInfoArray[n] = new TranslationInfo(destinationColumn.getText(), destinationColumn.getText(), null, true, translateColumnsInputDialog.getFromLanguage(), destinationColumn.getLang(), string2, translateColumnsInputDialog.getTranslator());
                    translationInfoArray[n].setFromKey(string3);
                    translationInfoArray[n].setToColumn(destinationColumn.getText());
                    ++n;
                    ++n3;
                }
                ++n2;
            }
        }
        return translationInfoArray;
    }

    private String isValid2(String string, IProject iProject) {
        String string2 = null;
        if (string.startsWith(LOCALIZATION_FILES_FOLDER)) {
            AndroidLocalizationSchema androidLocalizationSchema = new AndroidLocalizationSchema();
            String string3 = string.replace(LOCALIZATION_FILES_FOLDER, "");
            LocaleInfo localeInfo = androidLocalizationSchema.getLocaleInfoFromID(string3);
            ProjectLocalizationManager projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(iProject, false);
            if (localeInfo.getLocaleAttributes().size() > 0 || string.equalsIgnoreCase(LOCALIZATION_FILES_FOLDER)) {
                LocalizationFile localizationFile = projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
                if (localizationFile != null && !localizationFile.isToBeDeleted()) {
                    string2 = Messages.AndroidNewColumnProvider_Dialog_FileAlreadyExists;
                }
            } else {
                string2 = this.NEW_COLUMN_INVALID_ID;
            }
        } else {
            string2 = this.NEW_COLUMN_INVALID_ID;
        }
        return string2;
    }

    public String getEditorName() {
        return Messages.AndroidStringEditorInput_EditorTooltip;
    }

    public void createFile(LocalizationFile localizationFile) throws SequoyahException {
        try {
            Object object;
            Object object22;
            Object object3;
            Object object42;
            DocumentBuilder documentBuilder;
            DocumentBuilderFactory documentBuilderFactory;
            String string = localizationFile.getFile().getFullPath().toOSString();
            if (!localizationFile.getFile().exists()) {
                localizationFile.getFile().getLocation();
                documentBuilderFactory = null;
                documentBuilderFactory = localizationFile.getLocalizationProject() != null ? new Path(localizationFile.getLocalizationProject().getProject().getLocation() + string) : localizationFile.getFile().getLocation();
                documentBuilderFactory.removeLastSegments(1).toFile().mkdirs();
                documentBuilderFactory.toFile().createNewFile();
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                if (localizationFile.getLocalizationProject() != null) {
                    documentBuilder = localizationFile.getLocalizationProject().getProject().getFile((IPath)new Path(string));
                    localizationFile.setFile((IFile)documentBuilder);
                }
            }
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("resources");
            for (Object object42 : localizationFile.getStringNodes()) {
                if (object42.isArray()) continue;
                object3 = document.createElement("string");
                object3.setAttribute("name", object42.getKey());
                object3.appendChild(document.createTextNode(object42.getValue()));
                object22 = object42.getStringNodeComment();
                if (object22 != null && object22.getComment() != null && object22.getComment().length() > 0) {
                    object = document.createComment(object22.getComment());
                    object3.appendChild((Node)object);
                }
                element.appendChild((Node)object3);
            }
            for (Object object42 : localizationFile.getStringArrays()) {
                object3 = document.createElement("string-array");
                object3.setAttribute("name", object42.getKey());
                for (Object object22 : object42.getValues()) {
                    Element element2 = document.createElement("item");
                    element2.appendChild(document.createTextNode(object22.getValue()));
                    object3.appendChild(element2);
                    StringNodeComment stringNodeComment = object22.getStringNodeComment();
                    if (stringNodeComment == null || stringNodeComment.getComment() == null || stringNodeComment.getComment().length() <= 0) continue;
                    Comment comment = document.createComment(stringNodeComment.getComment());
                    element2.appendChild(comment);
                }
                element.appendChild((Node)object3);
            }
            document.appendChild(element);
            object42 = TransformerFactory.newInstance();
            ((TransformerFactory)object42).setAttribute("indent-number", 4);
            Transformer transformer = ((TransformerFactory)object42).newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            object3 = null;
            object3 = new FileOutputStream(localizationFile.getFile().getLocation().toFile());
            object22 = new StreamResult(new OutputStreamWriter((OutputStream)object3, "UTF-8"));
            object = new DOMSource(document);
            transformer.transform((Source)object, (Result)object22);
        }
        catch (Exception exception) {
            throw new SequoyahException();
        }
    }

    public String getLocaleToolTip(IPath iPath) {
        LocaleInfo localeInfo = this.getLocaleInfoFromPath(iPath);
        List list = localeInfo.getLocaleAttributes();
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (string.length() > 0) {
                string = String.valueOf(string) + "\n ";
            }
            LocaleAttribute localeAttribute = (LocaleAttribute)iterator.next();
            string = String.valueOf(string) + ((AndroidLocaleAttribute)localeAttribute).getDisplayName() + ": " + ((AndroidLocaleAttribute)localeAttribute).getDisplayValue();
        }
        if (string.length() == 0) {
            string = this.DEFAULT_LOCALE_TOOLTIP;
        }
        return string;
    }

    public List<LocaleAttribute> getLocaleAttributes() {
        ArrayList<LocaleAttribute> arrayList = new ArrayList<LocaleAttribute>();
        arrayList.add(new AndroidLocaleAttribute(new Integer(123), 0));
        arrayList.add(new AndroidLocaleAttribute(new Integer(0), 1));
        arrayList.add(new AndroidLocaleAttribute(null, 2));
        arrayList.add(new AndroidLocaleAttribute(null, 3));
        arrayList.add(new AndroidLocaleAttribute(null, 4));
        arrayList.add(new AndroidLocaleAttribute(new Integer(12), 5));
        arrayList.add(new AndroidLocaleAttribute(null, 6));
        arrayList.add(new AndroidLocaleAttribute(null, 7));
        arrayList.add(new AndroidLocaleAttribute(null, 8));
        arrayList.add(new AndroidLocaleAttribute(null, 9));
        arrayList.add(new AndroidLocaleAttribute(new Dimension(1, 1), 10));
        return arrayList;
    }

    public List<String> getLocalizationFileExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("xml");
        return arrayList;
    }

    public Map<LocaleInfo, IFile> getLocalizationFiles(IProject iProject) {
        LinkedHashMap<LocaleInfo, IFile> linkedHashMap;
        block12: {
            linkedHashMap = new LinkedHashMap<LocaleInfo, IFile>();
            boolean bl = false;
            try {
                IFolder iFolder;
                IFolder iFolder2;
                IResource iResource = iProject.findMember("res");
                if (iResource != null && iResource instanceof IFolder && (iFolder2 = ((IFolder)iResource).members()) != null) {
                    IFolder iFolder3 = iFolder2;
                    int n = ((IFolder)iFolder3).length;
                    int n2 = 0;
                    while (n2 < n) {
                        iFolder = iFolder3[n2];
                        if (iFolder.getName().startsWith(LOCALIZATION_FILES_FOLDER)) {
                            IResource[] iResourceArray;
                            IResource[] iResourceArray2 = iResourceArray = iFolder.members();
                            int n3 = iResourceArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource iResource2 = iResourceArray2[n4];
                                if (iResource2 instanceof IFile && this.isLocalizationFile((IFile)iResource2)) {
                                    linkedHashMap.put(this.getLocaleInfoFromPath(iResource2.getProjectRelativePath()), (IFile)iResource2);
                                    if (iFolder.getName().equals(LOCALIZATION_FILES_FOLDER)) {
                                        bl = true;
                                    }
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                if (bl || !(iResource instanceof IFolder)) break block12;
                iFolder2 = (IFolder)iResource;
                iFolder = iFolder2.getFolder(LOCALIZATION_FILES_FOLDER);
                try {
                    if (!iFolder.exists()) {
                        PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    iFolder.create(true, true, iProgressMonitor);
                                }
                                catch (CoreException coreException) {}
                            }
                        });
                    }
                    if (iFolder.exists()) {
                        IFile iFile = iFolder.getFile(LOCALIZATION_FILE_NAME);
                        linkedHashMap.put(this.getLocaleInfoFromPath(iFile.getProjectRelativePath()), iFile);
                    }
                }
                catch (Exception exception) {}
            }
            catch (CoreException coreException) {}
        }
        return linkedHashMap;
    }

    public boolean isLocalizationFile(IFile iFile) {
        boolean bl = false;
        if (iFile != null && iFile.getProjectRelativePath().toString().matches("res/values.*/strings.xml")) {
            bl = true;
        }
        return bl;
    }

    public Map<LocaleInfo, LocalizationFile> loadAllFiles(IProject iProject) throws IOException {
        LinkedHashMap<LocaleInfo, LocalizationFile> linkedHashMap = new LinkedHashMap<LocaleInfo, LocalizationFile>();
        Map<LocaleInfo, IFile> map = this.getLocalizationFiles(iProject);
        for (Map.Entry<LocaleInfo, IFile> entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey(), this.loadFile(entry.getValue()));
        }
        return linkedHashMap;
    }

    public LocalizationFile loadFile(IFile iFile) throws IOException {
        DocumentBuilderFactory documentBuilderFactory;
        LocalizationFile localizationFile = null;
        LocaleInfo localeInfo = this.getLocaleInfoFromPath(iFile.getFullPath());
        ArrayList<NodeList> arrayList = new ArrayList<NodeList>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        if (!iFile.exists()) {
            documentBuilderFactory = new LocalizationFile(iFile, localeInfo, arrayList, null);
            try {
                this.createFile((LocalizationFile)documentBuilderFactory);
            }
            catch (SequoyahException sequoyahException) {}
        }
        try {
            Node node;
            String string;
            Object object;
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(iFile.getLocation().toString()));
            NodeList nodeList = document.getElementsByTagName("string");
            String string2 = null;
            String string3 = null;
            int n = 0;
            while (n < nodeList.getLength()) {
                NodeList nodeList2;
                object = (Element)nodeList.item(n);
                string2 = object.getAttributeNode("name").getNodeValue();
                string = null;
                if (object.hasChildNodes()) {
                    nodeList2 = object.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        node = nodeList2.item(n2);
                        if (node.getNodeType() == 8) {
                            string = node.getNodeValue();
                        }
                        ++n2;
                    }
                }
                string3 = object.getTextContent();
                nodeList2 = new StringNode(string2, string3);
                if (string != null) {
                    StringNodeComment stringNodeComment = new StringNodeComment();
                    stringNodeComment.setComment(string);
                    nodeList2.setStringNodeComment(stringNodeComment);
                }
                arrayList.add(nodeList2);
                ++n;
            }
            NodeList nodeList3 = document.getElementsByTagName("string-array");
            object = null;
            string = null;
            int n3 = 0;
            while (n3 < nodeList3.getLength()) {
                Element element = (Element)nodeList3.item(n3);
                object = element.getAttributeNode("name").getNodeValue();
                node = new StringArray((String)object);
                if (element.hasChildNodes()) {
                    NodeList nodeList4 = element.getElementsByTagName("item");
                    int n4 = 0;
                    while (n4 < nodeList4.getLength()) {
                        NodeList nodeList5;
                        Node node2 = nodeList4.item(n4);
                        string = node2.getTextContent();
                        StringNode stringNode = node.addValue(string);
                        String string4 = null;
                        if (node2.hasChildNodes()) {
                            nodeList5 = node2.getChildNodes();
                            int n5 = 0;
                            while (n5 < nodeList5.getLength()) {
                                Node node3 = nodeList5.item(n5);
                                if (node3.getNodeType() == 8) {
                                    string4 = node3.getNodeValue();
                                }
                                ++n5;
                            }
                        }
                        if (string4 != null) {
                            nodeList5 = new StringNodeComment();
                            nodeList5.setComment(string4);
                            stringNode.setStringNodeComment((StringNodeComment)nodeList5);
                        }
                        ++n4;
                    }
                }
                arrayList2.add(node);
                ++n3;
            }
            localizationFile = new LocalizationFile(iFile, localeInfo, arrayList, arrayList2);
        }
        catch (Exception exception) {
            throw new IOException(String.valueOf(Messages.AndroidLocalizationSchema_Exception_CouldNotLoadFile) + iFile.getName() + ". " + exception.getMessage());
        }
        return localizationFile;
    }

    public void updateFile(LocalizationFile localizationFile) throws SequoyahException {
        this.createFile(localizationFile);
        localizationFile.setDirty(false);
    }

    private LocaleInfo getLocaleInfoFromPath(IPath iPath) {
        IPath iPath2 = iPath;
        iPath2 = iPath.removeLastSegments(1);
        String string = iPath2.lastSegment();
        String string2 = string.replace(LOCALIZATION_FILES_FOLDER, "");
        return this.getLocaleInfoFromID(string2);
    }

    public String getPathFromLocaleInfo(LocaleInfo localeInfo) {
        String string = localeInfo.getLocaleAttributes().size() > 0 ? "res" + File.separator + LOCALIZATION_FILES_FOLDER + "-" + this.getLocaleID(localeInfo) + File.separator + LOCALIZATION_FILE_NAME : "res" + File.separator + LOCALIZATION_FILES_FOLDER + File.separator + LOCALIZATION_FILE_NAME;
        return string;
    }

    public String getLocaleID(LocaleInfo localeInfo) {
        String string = "";
        List list = localeInfo.getLocaleAttributes();
        for (LocaleAttribute localeAttribute : list) {
            if (!((AndroidLocaleAttribute)localeAttribute).isSet()) continue;
            if (string.length() != 0) {
                string = String.valueOf(string) + "-";
            }
            string = String.valueOf(string) + localeAttribute.getFolderValue();
        }
        return string;
    }

    public LocaleInfo getLocaleInfoFromID(String string) {
        LocaleInfo localeInfo = new LocaleInfo();
        String[] stringArray = string.split("-");
        int n = -1;
        ArrayList<AndroidLocaleAttribute> arrayList = new ArrayList<AndroidLocaleAttribute>();
        int n2 = 1;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].equals("")) {
                if (this.isCountryCodeSegment(stringArray[n2]) && n < 0) {
                    n = 0;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 0));
                } else if (this.isNetworkCodeSegment(stringArray[n2]) && n < 1) {
                    n = 1;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 1));
                } else if (this.isLanguageSegment(stringArray[n2]) && n < 2) {
                    n = 2;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 2));
                } else if (this.isRegionSegment(stringArray[n2]) && n < 3) {
                    n = 3;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 3));
                } else if (this.isOrientationSegment(stringArray[n2]) && n < 4) {
                    n = 4;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 4));
                } else if (this.isPixelDensitySegment(stringArray[n2]) && n < 5) {
                    n = 5;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 5));
                } else if (this.isTouchTypeSegment(stringArray[n2]) && n < 6) {
                    n = 6;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 6));
                } else if (this.isKeyboardStateSegment(stringArray[n2]) && n < 7) {
                    n = 7;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 7));
                } else if (this.isTextInputSegment(stringArray[n2]) && n < 8) {
                    n = 8;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 8));
                } else if (this.isNavigationSegment(stringArray[n2]) && n < 9) {
                    n = 9;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 9));
                } else if (this.isDimensionSegment(stringArray[n2]) && n < 10) {
                    n = 10;
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], 10));
                } else {
                    arrayList = new ArrayList();
                    break;
                }
            }
            ++n2;
        }
        localeInfo.setLocaleAttributes(arrayList);
        return localeInfo;
    }

    public String getISO639LangFromID(String string) {
        String string2 = null;
        LocaleInfo localeInfo = this.getLocaleInfoFromID(string);
        for (LocaleAttribute localeAttribute : localeInfo.getLocaleAttributes()) {
            if (!localeAttribute.getDisplayName().equals("Language")) continue;
            string2 = localeAttribute.getFolderValue();
        }
        return string2;
    }

    public String getDefaultID() {
        return LOCALIZATION_FILES_FOLDER;
    }

    private boolean isNetworkCodeSegment(String string) {
        return string.startsWith("mnc");
    }

    private boolean isLanguageSegment(String string) {
        return string.length() == 2;
    }

    private boolean isRegionSegment(String string) {
        return string.startsWith("r") && string.length() == 3;
    }

    private boolean isOrientationSegment(String string) {
        return string.equalsIgnoreCase("port") || string.equalsIgnoreCase("land") || string.equalsIgnoreCase("square");
    }

    private boolean isPixelDensitySegment(String string) {
        return string.endsWith("dpi");
    }

    private boolean isTouchTypeSegment(String string) {
        return string.equalsIgnoreCase("notouch") || string.equalsIgnoreCase("stylus") || string.equalsIgnoreCase("finger");
    }

    private boolean isKeyboardStateSegment(String string) {
        return string.equalsIgnoreCase("keysexposed") || string.equalsIgnoreCase("keyshidden");
    }

    private boolean isTextInputSegment(String string) {
        return string.equalsIgnoreCase("nokeys") || string.equalsIgnoreCase("qwerty") || string.equalsIgnoreCase("12key");
    }

    private boolean isNavigationSegment(String string) {
        return string.equalsIgnoreCase("dpad") || string.equalsIgnoreCase("trackball") || string.equalsIgnoreCase("wheel") || string.equalsIgnoreCase("nonav");
    }

    private boolean isDimensionSegment(String string) {
        String[] stringArray;
        boolean bl = false;
        if (string.contains("x") && (stringArray = string.split("x")).length == 2) {
            bl = true;
        }
        return bl;
    }

    private boolean isCountryCodeSegment(String string) {
        return string.startsWith("mcc");
    }
}

