/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.graphics.swt;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.sequoyah.vnc.protocol.PluginProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;
import org.eclipse.sequoyah.vnc.utilities.logger.Logger;
import org.eclipse.sequoyah.vnc.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTVNCEventTranslator;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.img.Painter;
import org.eclipse.sequoyah.vnc.vncviewer.network.IVNCPainter;
import org.eclipse.sequoyah.vnc.vncviewer.network.VNCProtocolData;
import org.eclipse.sequoyah.vnc.vncviewer.registry.VNCProtocolRegistry;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SWTRemoteDisplay
extends Composite
implements IRemoteDisplay {
    private static final String REMOTE_DISPLAY_STOP_ERROR = "Remote Display Stop error: ";
    private static final String REMOTE_DISPLAY_MOUSE_EVENT_ERROR = "Remote Display mouse event error : ";
    private static final String REMOTE_DISPLAY_KEY_EVENT_ERROR = "Remote Display key event error : ";
    protected Canvas canvas;
    private ProtocolHandle handle;
    private VNCProtocolData protoClient;
    private Image screen = null;
    private Properties configurationProperties;
    private SWTVNCEventTranslator eventTranslator;
    private boolean active = false;
    private long firstRefreshDelayMs;
    private long refreshDelayPeriodMs;
    private int connectionRetries;
    private Timer refreshTimer;
    private Listener keyListener;
    private Listener mouseListener;
    protected PaintListener paintListener = null;
    private double zoomFactor;
    protected ISWTPainter painter;
    private IPropertiesFileHandler propertiesFileHandler;
    private IRemoteDisplay.Rotation rotation = IRemoteDisplay.Rotation.ROTATION_0DEG;

    public SWTRemoteDisplay(Composite composite, Properties properties, IPropertiesFileHandler iPropertiesFileHandler) {
        super(composite, 8);
        Logger.log(SWTRemoteDisplay.class).debug("Constructing SWT Remote Display");
        this.configurationProperties = properties;
        this.propertiesFileHandler = iPropertiesFileHandler;
        this.setLayout(composite.getLayout());
        this.canvas = new Canvas((Composite)this, 262144);
        this.eventTranslator = new SWTVNCEventTranslator(properties, iPropertiesFileHandler);
        this.initConfiguration();
    }

    protected int getCanvasStyle() {
        return 8;
    }

    private void initConfiguration() {
        this.connectionRetries = Integer.valueOf(this.configurationProperties.getProperty("CONNECTION_RETRIES"));
        this.zoomFactor = Double.valueOf(this.configurationProperties.getProperty("ZOOM_FACTOR"));
        this.firstRefreshDelayMs = Long.valueOf(this.configurationProperties.getProperty("FIRST_REFRESH_DELAY_MS"));
        this.refreshDelayPeriodMs = Long.valueOf(this.configurationProperties.getProperty("REFRESH_DELAY_PERIOD_MS"));
        Logger.log(SWTRemoteDisplay.class).info("Using screen parameters: retries=" + this.connectionRetries + "; zoomFactor=" + this.zoomFactor + "; firstRefreshDelay(ms)=" + this.firstRefreshDelayMs + "; refreshDelay(ms)=" + this.refreshDelayPeriodMs + ".");
    }

    private void addKeyListener() {
        this.keyListener = new Listener(){

            public void handleEvent(Event event) {
                Event event2 = event;
                if (SWTRemoteDisplay.this.isActive()) {
                    try {
                        SWTRemoteDisplay.this.keyEvent(event2);
                        SWTRemoteDisplay.this.updateRequest(true);
                        SWTRemoteDisplay.this.notifyListeners(event2.type, event2);
                    }
                    catch (Exception exception) {
                        Logger.log(SWTRemoteDisplay.class).error("Remote Display error on key event.");
                    }
                }
            }
        };
        this.getCanvas().getDisplay().syncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplay.this.canvas.addListener(1, SWTRemoteDisplay.this.keyListener);
                SWTRemoteDisplay.this.canvas.addListener(2, SWTRemoteDisplay.this.keyListener);
            }
        });
    }

    private void addMouseListener() {
        this.mouseListener = new Listener(){

            public void handleEvent(Event event) {
                Event event2 = event;
                if (SWTRemoteDisplay.this.isActive()) {
                    try {
                        SWTRemoteDisplay.this.mouseEvent(event2);
                        SWTRemoteDisplay.this.notifyListeners(event2.type, event2);
                    }
                    catch (Exception exception) {
                        Logger.log(SWTRemoteDisplay.class).error("Remote Display error on key event.");
                    }
                }
            }
        };
        this.getCanvas().getDisplay().syncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplay.this.canvas.addListener(5, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.addListener(4, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.addListener(3, SWTRemoteDisplay.this.mouseListener);
            }
        });
    }

    private void addRefreshTimer() {
        this.refreshTimer = new Timer();
        final Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                try {
                    SWTRemoteDisplay.this.updateRequest(false);
                }
                catch (Exception exception) {
                    Logger.log(SWTRemoteDisplay.class).warn("The first full screen request has failed. Cause: " + exception.getMessage());
                }
            }
        });
        final Runnable runnable = new Runnable(){

            public void run() {
                try {
                    SWTRemoteDisplay.this.updateRequest(true);
                }
                catch (Exception exception) {
                    SWTRemoteDisplay.this.stop();
                    Logger.log(SWTRemoteDisplay.class).error("Update screen error: " + exception.getMessage());
                }
            }
        };
        this.refreshTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                if (!display.isDisposed()) {
                    display.syncExec(runnable);
                }
            }
        }, this.firstRefreshDelayMs, this.refreshDelayPeriodMs);
    }

    public void restart() throws Exception {
        Logger.log(SWTRemoteDisplay.class).info("Restarting SWT remote display.");
        this.stop();
        PluginProtocolActionDelegate.requestRestartProtocol((ProtocolHandle)this.handle);
        this.start(this.handle);
        Logger.log(SWTRemoteDisplay.class).info("SWT remote display restarted.");
    }

    public synchronized void start(ProtocolHandle protocolHandle) throws Exception {
        Logger.log(SWTRemoteDisplay.class).info("Starting SWT remote display.");
        this.handle = protocolHandle;
        this.protoClient = VNCProtocolRegistry.getInstance().get(protocolHandle);
        if (this.protoClient != null) {
            try {
                this.protoClient.setPaintEnabled(true);
                this.protoClient.setVncPainter((IVNCPainter)((Object)this.painter));
                ((Painter)this.painter).setPixelFormat(this.protoClient.getPixelFormat());
                ((IVNCPainter)((Object)this.painter)).setSize(this.protoClient.getFbWidth(), this.protoClient.getFbHeight());
                this.canvas.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (SWTRemoteDisplay.this.canvas.isDisposed()) {
                            return;
                        }
                        switch (SWTRemoteDisplay.this.getRotation()) {
                            case ROTATION_0DEG: 
                            case ROTATION_180DEG: {
                                SWTRemoteDisplay.this.canvas.setSize(SWTRemoteDisplay.this.protoClient.getFbWidth(), SWTRemoteDisplay.this.protoClient.getFbHeight());
                                break;
                            }
                            case ROTATION_90DEG_CLOCKWISE: 
                            case ROTATION_90DEG_COUNTERCLOCKWISE: {
                                SWTRemoteDisplay.this.canvas.setSize(SWTRemoteDisplay.this.protoClient.getFbHeight(), SWTRemoteDisplay.this.protoClient.getFbWidth());
                            }
                        }
                    }
                });
                this.addRefreshTimer();
                this.addKeyListener();
                this.addMouseListener();
                Event event = new Event();
                event.x = 0;
                event.y = 0;
                this.mouseEvent(event);
            }
            catch (Exception exception) {
                Logger.log(SWTRemoteDisplay.class).error("Remote Display start error: " + exception.getMessage());
            }
            this.setRunning(true);
            Logger.log(SWTRemoteDisplay.class).info("SWT remote display started.");
        }
    }

    public IRemoteDisplay.Rotation getRotation() {
        return this.rotation;
    }

    public synchronized void stop() {
        Logger.log(SWTRemoteDisplay.class).info("Stopping SWT remote display.");
        this.setRunning(false);
        this.refreshTimer.cancel();
        this.canvas.getDisplay().syncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplay.this.canvas.removeListener(2, SWTRemoteDisplay.this.keyListener);
                SWTRemoteDisplay.this.canvas.removeListener(1, SWTRemoteDisplay.this.keyListener);
                SWTRemoteDisplay.this.canvas.removeListener(5, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.removeListener(4, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.removeListener(3, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.removePaintListener(SWTRemoteDisplay.this.paintListener);
            }
        });
        if (this.canvas != null) {
            Point point = this.canvas.getSize();
            GC gC = new GC((Drawable)this.canvas);
            gC.fillRectangle(0, 0, point.x, point.y);
            gC.dispose();
        }
        this.canvas.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (SWTRemoteDisplay.this.canvas != null && !SWTRemoteDisplay.this.canvas.isDisposed()) {
                    SWTRemoteDisplay.this.canvas.setSize(0, 0);
                }
            }
        });
        Logger.log(SWTRemoteDisplay.class).info("SWT remote display stopped.");
    }

    public void updateRequest(boolean bl) throws Exception {
        try {
            ProtocolMessage protocolMessage = new ProtocolMessage(3L);
            protocolMessage.setFieldValue("x-position", (Object)0);
            protocolMessage.setFieldValue("y-position", (Object)0);
            protocolMessage.setFieldValue("width", (Object)this.painter.getWidth());
            protocolMessage.setFieldValue("height", (Object)this.painter.getHeight());
            protocolMessage.setFieldValue("incremental", (Object)(bl ? 1 : 0));
            PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.handle, (ProtocolMessage)protocolMessage);
        }
        catch (Exception exception) {
            Logger.log(SWTRemoteDisplay.class).error("Remote Display update screen error : " + exception.getMessage());
            this.stop();
        }
        if (this.screen != null) {
            this.screen.dispose();
        }
    }

    public void updateScreen() throws Exception {
        this.updateRequest(true);
    }

    public void keyEvent(Event event) throws Exception {
        try {
            ProtocolMessage protocolMessage = this.eventTranslator.getKeyEventMessage(event);
            PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.handle, (ProtocolMessage)protocolMessage);
        }
        catch (Exception exception) {
            Logger.log(SWTRemoteDisplay.class).error(REMOTE_DISPLAY_KEY_EVENT_ERROR + exception.getMessage());
            this.stop();
        }
    }

    public void mouseEvent(Event event) throws Exception {
        try {
            ProtocolMessage protocolMessage = this.eventTranslator.getMouseEventMessage(event);
            Integer n = (Integer)protocolMessage.getFieldValue("x-position");
            Integer n2 = (Integer)protocolMessage.getFieldValue("y-position");
            int n3 = (int)((double)n.intValue() / this.zoomFactor);
            int n4 = (int)((double)n2.intValue() / this.zoomFactor);
            switch (this.getRotation()) {
                case ROTATION_0DEG: {
                    n3 = (int)((double)n.intValue() / this.zoomFactor);
                    n4 = (int)((double)n2.intValue() / this.zoomFactor);
                    break;
                }
                case ROTATION_180DEG: {
                    n3 = this.painter.getImageData().width - (int)((double)n.intValue() / this.zoomFactor);
                    n4 = this.painter.getImageData().height - (int)((double)n2.intValue() / this.zoomFactor);
                    break;
                }
                case ROTATION_90DEG_CLOCKWISE: {
                    n3 = (int)((double)n2.intValue() / this.zoomFactor);
                    n4 = this.painter.getImageData().height - (int)((double)n.intValue() / this.zoomFactor);
                    break;
                }
                case ROTATION_90DEG_COUNTERCLOCKWISE: {
                    n3 = this.painter.getImageData().width - (int)((double)n2.intValue() / this.zoomFactor);
                    n4 = (int)((double)n.intValue() / this.zoomFactor);
                }
            }
            protocolMessage.setFieldValue("x-position", (Object)n3);
            protocolMessage.setFieldValue("y-position", (Object)n4);
            PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.handle, (ProtocolMessage)protocolMessage);
        }
        catch (Exception exception) {
            Logger.log(SWTRemoteDisplay.class).error(REMOTE_DISPLAY_MOUSE_EVENT_ERROR + exception.getMessage());
            this.stop();
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public Image getScreen() {
        return this.screen;
    }

    public void setScreen(Image image) {
        this.screen = image;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    private synchronized void setRunning(boolean bl) {
        this.active = bl;
    }

    public void dispose() {
        Logger.log(SWTRemoteDisplay.class).debug("Disposing SWT Remote Display");
        try {
            if (this.protoClient != null) {
                this.protoClient.setPaintEnabled(false);
            }
        }
        catch (Exception exception) {
            Logger.log(SWTRemoteDisplay.class).error(REMOTE_DISPLAY_STOP_ERROR + exception.getMessage());
        }
        if (this.screen != null) {
            this.screen.dispose();
        }
        if (this.canvas != null) {
            this.canvas.dispose();
        }
        super.dispose();
    }

    public int getScreenWidth() {
        return this.painter.getWidth();
    }

    public int getScreenHeight() {
        return this.painter.getHeight();
    }

    public Timer getRefreshTimer() {
        return this.refreshTimer;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double d) {
        this.zoomFactor = d;
        VNCProtocolData vNCProtocolData = this.getProtocolData();
        if (vNCProtocolData != null) {
            Point point = new Point(0, 0);
            point.x = (int)((double)this.getProtocolData().getFbWidth() * d);
            point.y = (int)((double)this.getProtocolData().getFbHeight() * d);
            if (Math.abs(this.getRotation().value()) == IRemoteDisplay.Rotation.ROTATION_90DEG_CLOCKWISE.value()) {
                int n = point.x;
                point.x = point.y;
                point.y = n;
            }
            this.getCanvas().setSize(point);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.canvas != null) {
            this.canvas.setBackground(color);
        }
    }

    public VNCProtocolData getProtocolData() {
        return this.protoClient;
    }

    public void setPropertiesFileHandler(IPropertiesFileHandler iPropertiesFileHandler) {
        this.propertiesFileHandler = iPropertiesFileHandler;
    }

    public int getConnectionRetries() {
        return this.connectionRetries;
    }

    public void setRotation(final IRemoteDisplay.Rotation rotation) {
        this.rotation = rotation;
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Point point = SWTRemoteDisplay.this.canvas.getSize();
                int n = 0;
                int n2 = 0;
                switch (rotation) {
                    case ROTATION_0DEG: 
                    case ROTATION_180DEG: {
                        if (SWTRemoteDisplay.this.painter.getImageData() != null) {
                            n = SWTRemoteDisplay.this.painter.getImageData().width;
                            n2 = SWTRemoteDisplay.this.painter.getImageData().height;
                            break;
                        }
                        n = point.x;
                        n2 = point.y;
                        break;
                    }
                    case ROTATION_90DEG_CLOCKWISE: 
                    case ROTATION_90DEG_COUNTERCLOCKWISE: {
                        if (SWTRemoteDisplay.this.painter.getImageData() != null) {
                            n = SWTRemoteDisplay.this.painter.getImageData().height;
                            n2 = SWTRemoteDisplay.this.painter.getImageData().width;
                            break;
                        }
                        n = point.y;
                        n2 = point.x;
                    }
                }
                SWTRemoteDisplay.this.canvas.setSize((int)((double)n * SWTRemoteDisplay.this.zoomFactor), (int)((double)n2 * SWTRemoteDisplay.this.zoomFactor));
            }
        });
    }
}

