/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.vncviews.views;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sequoyah.vnc.vncviewer.vncviews.views.VNCViewerView;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OpenConnectionDialog
extends Dialog {
    private static final String DIALOG_TITLE = "New VNC connection";
    private static final String DEFAULT_PORT = "5900";
    private Text hostText;
    private Text portText;
    private Combo protocolVersion;
    private Text passwordText;
    private Button bypassProxyButton;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            OpenConnectionDialog.this.validate();
        }
    };

    public OpenConnectionDialog(Shell shell) {
        super(shell);
    }

    protected Point getInitialSize() {
        return new Point(240, 290);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = this.createDefaultComposite(composite, 1, 17);
        Composite composite3 = this.createDefaultComposite(composite2, 2, 0);
        int n = 20;
        Label label = new Label(composite3, 131072);
        this.hostText = new Text(composite3, composite.getStyle() | 0x800);
        Label label2 = new Label(composite3, 131072);
        this.portText = new Text(composite3, composite.getStyle() | 0x800);
        Label label3 = new Label(composite3, 131072);
        this.passwordText = new Text(composite3, composite.getStyle() | 0x800 | 0x400000);
        GC gC = new GC((Drawable)this.hostText.getDisplay());
        int n2 = gC.getFontMetrics().getAverageCharWidth() * n;
        int n3 = gC.getFontMetrics().getHeight();
        GridData gridData = new GridData();
        gridData.heightHint = n3;
        gridData.widthHint = n2;
        label.setText("Host:");
        this.hostText.setLayoutData((Object)gridData);
        this.hostText.setSize(this.hostText.computeSize(n2, n3));
        label2.setText("Port:");
        this.portText.setSize(this.portText.computeSize(n2, n3));
        this.portText.setLayoutData((Object)gridData);
        this.portText.setText(DEFAULT_PORT);
        label3.setText("Password:");
        this.passwordText.setSize(this.passwordText.computeSize(n2, n3));
        this.passwordText.setLayoutData((Object)gridData);
        this.createCombo(composite2);
        Composite composite4 = new Composite(composite2, 0);
        GridData gridData2 = new GridData(4, 4, true, false);
        composite4.setLayoutData((Object)gridData2);
        GridLayout gridLayout = new GridLayout();
        composite4.setLayout((Layout)gridLayout);
        this.bypassProxyButton = new Button(composite4, 32);
        Point point = this.bypassProxyButton.getLocation();
        this.bypassProxyButton.setLocation(point.x, point.y + 100);
        this.bypassProxyButton.setText("Bypass proxy settings");
        this.hostText.addModifyListener(this.listener);
        this.portText.addModifyListener(this.listener);
        return composite2;
    }

    protected void okPressed() {
        String string = this.hostText.getText();
        int n = Integer.valueOf(this.portText.getText());
        String string2 = this.protocolVersion.getItem(this.protocolVersion.getSelectionIndex());
        String string3 = this.passwordText.getText();
        ConnectJob connectJob = new ConnectJob(string, n, string3, string2, this.bypassProxyButton.getSelection());
        connectJob.schedule();
        super.okPressed();
    }

    public boolean isStopExistingClient() {
        Display display = Display.getDefault();
        RunnableMessageDialog runnableMessageDialog = new RunnableMessageDialog(display);
        display.syncExec((Runnable)runnableMessageDialog);
        return runnableMessageDialog.returnCode == 0;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true).setEnabled(false);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false).setEnabled(true);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private Composite createDefaultComposite(Composite composite, int n, int n2) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        if (n > 0) {
            gridLayout.numColumns = n;
        }
        gridLayout.marginLeft = n2 + 5;
        gridLayout.marginTop = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    private void createCombo(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, false);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("VNC Protocol used as base:");
        Combo combo = new Combo(composite2, 8);
        gridData = new GridData(4, 0x1000000, true, false);
        combo.setLayoutData((Object)gridData);
        combo.add("VNC 3.3");
        combo.add("VNC 3.7");
        combo.add("VNC 3.8");
        combo.select(2);
        this.protocolVersion = combo;
    }

    private void validate() {
        if (this.hostText != null && this.portText != null) {
            this.getButton(0).setEnabled(this.hostText.getText().length() > 0 && this.portText.getText().length() > 0);
        }
    }

    public class ConnectJob
    extends Job {
        final String host;
        final int port;
        final String password;
        final String version;
        final boolean isBypassProxy;

        public ConnectJob(String string, int n, String string2, String string3, boolean bl) {
            super("Open VNC connection with " + string + ":" + n);
            this.host = string;
            this.port = n;
            this.password = string2;
            this.version = string3;
            this.isBypassProxy = bl;
        }

        public IStatus run(IProgressMonitor iProgressMonitor) {
            iProgressMonitor.beginTask("Checking Viewer state...", 2);
            if (VNCViewerView.getSWTRemoteDisplay().isActive()) {
                if (OpenConnectionDialog.this.isStopExistingClient()) {
                    VNCViewerView.stop();
                    try {
                        VNCViewerView.stopProtocol();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            }
            if (!this.isStepNeeded(iProgressMonitor, "Starting VNC client...")) {
                return Status.CANCEL_STATUS;
            }
            VNCViewerView.start(this.host, this.port, this.version, this.password, this.isBypassProxy);
            iProgressMonitor.done();
            return Status.OK_STATUS;
        }

        private boolean isStepNeeded(IProgressMonitor iProgressMonitor, String string) {
            if (!iProgressMonitor.isCanceled()) {
                iProgressMonitor.worked(1);
                iProgressMonitor.setTaskName(string);
                return true;
            }
            return false;
        }
    }

    private class RunnableMessageDialog
    implements Runnable {
        private Display display;
        int returnCode;

        public RunnableMessageDialog(Display display) {
            this.display = display;
        }

        public void run() {
            MessageDialog messageDialog = new MessageDialog(this.display.getActiveShell(), "Stop VNC session", null, "Stop existing VNC session for " + VNCViewerView.getCurrentHost() + ":" + VNCViewerView.getCurrentPort() + "?", 3, new String[]{"Stop", "Cancel"}, 0);
            messageDialog.open();
            this.returnCode = messageDialog.getReturnCode();
        }
    }
}

