/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.qemu.wizard.custom;

import java.util.Properties;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.IInstanceProperties;
import org.eclipse.sequoyah.device.qemu.QEmuPlugin;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class QEmuBinarySettingsWizardPage
extends WizardPage
implements IInstanceProperties {
    private Text installedDirText;
    private Button browseInstalledDirButton;
    private Text emulatorBinaryText;
    private Button browseEmulatorBinaryButton;
    private Text kernelImageText;
    private Button browseKernelImageButton;
    private Text initrdText;
    private Button browseInitrdButton;
    private Text emulatedMachineText;
    private Text additionalOptionsText;
    private Button startVNCButton;
    private StyledText usage;

    protected QEmuBinarySettingsWizardPage(String string) {
        super(string);
    }

    public QEmuBinarySettingsWizardPage() {
        super("$qemu_binary_settings$");
        this.setTitle(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.title"));
        this.setMessage(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.message"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.installedDir"));
        label.setFont(composite2.getFont());
        this.installedDirText = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        this.installedDirText.setLayoutData((Object)gridData);
        this.installedDirText.setFont(composite2.getFont());
        this.installedDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseInstalledDirButton = new Button(composite2, 8);
        this.browseInstalledDirButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.browse"));
        this.browseInstalledDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string;
                DirectoryDialog directoryDialog = new DirectoryDialog(QEmuBinarySettingsWizardPage.this.getShell(), 4096);
                if (QEmuBinarySettingsWizardPage.this.installedDirText.getText() != null) {
                    directoryDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.installedDirText.getText());
                }
                if ((string = directoryDialog.open()) != null && (string = string.trim()).length() > 0) {
                    QEmuBinarySettingsWizardPage.this.installedDirText.setText(string);
                }
            }
        });
        Group group = new Group(composite2, 0);
        group.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.emulatorStartupSettings"));
        GridLayout gridLayout = new GridLayout(3, false);
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        group.setFont(composite2.getFont());
        label = new Label((Composite)group, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.emulatorBinary"));
        label.setFont(composite2.getFont());
        this.emulatorBinaryText = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.emulatorBinaryText.setLayoutData((Object)gridData);
        this.emulatorBinaryText.setFont(composite2.getFont());
        this.emulatorBinaryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseEmulatorBinaryButton = new Button((Composite)group, 8);
        this.browseEmulatorBinaryButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.browse"));
        this.browseEmulatorBinaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(QEmuBinarySettingsWizardPage.this.getShell(), 4096);
                if (QEmuBinarySettingsWizardPage.this.emulatorBinaryText.getText().trim() != "") {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.emulatorBinaryText.getText());
                } else if (QEmuBinarySettingsWizardPage.this.installedDirText.getText().trim() != "") {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.installedDirText.getText());
                }
                String string = fileDialog.open();
                if (string != null && (string = string.trim()).length() > 0) {
                    QEmuBinarySettingsWizardPage.this.emulatorBinaryText.setText(QEmuBinarySettingsWizardPage.this.getRelativePath(string));
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.kernelImage"));
        label.setFont(composite2.getFont());
        this.kernelImageText = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.kernelImageText.setLayoutData((Object)gridData);
        this.kernelImageText.setFont(composite2.getFont());
        this.kernelImageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseKernelImageButton = new Button((Composite)group, 8);
        this.browseKernelImageButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.browse"));
        this.browseKernelImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(QEmuBinarySettingsWizardPage.this.getShell(), 4096);
                if (QEmuBinarySettingsWizardPage.this.kernelImageText.getText() != null) {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.emulatorBinaryText.getText());
                } else if (QEmuBinarySettingsWizardPage.this.installedDirText.getText() != null) {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.installedDirText.getText());
                }
                String string = fileDialog.open();
                if (string != null && (string = string.trim()).length() > 0) {
                    QEmuBinarySettingsWizardPage.this.kernelImageText.setText(QEmuBinarySettingsWizardPage.this.getRelativePath(string));
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.initrd"));
        label.setFont(composite2.getFont());
        this.initrdText = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.initrdText.setLayoutData((Object)gridData);
        this.initrdText.setFont(composite2.getFont());
        this.initrdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseInitrdButton = new Button((Composite)group, 8);
        this.browseInitrdButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.browse"));
        this.browseInitrdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(QEmuBinarySettingsWizardPage.this.getShell(), 4096);
                if (QEmuBinarySettingsWizardPage.this.initrdText.getText() != null) {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.initrdText.getText());
                } else if (QEmuBinarySettingsWizardPage.this.installedDirText.getText() != null) {
                    fileDialog.setFilterPath(QEmuBinarySettingsWizardPage.this.installedDirText.getText());
                }
                String string = fileDialog.open();
                if (string != null && (string = string.trim()).length() > 0) {
                    QEmuBinarySettingsWizardPage.this.initrdText.setText(QEmuBinarySettingsWizardPage.this.getRelativePath(string));
                }
            }
        });
        group.pack();
        this.startVNCButton = new Button(composite2, 32);
        this.startVNCButton.setSelection(true);
        this.startVNCButton.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.enableVNC"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.startVNCButton.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.emulatedMachine"));
        label.setFont(composite2.getFont());
        this.emulatedMachineText = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.emulatedMachineText.setLayoutData((Object)gridData);
        this.emulatedMachineText.setFont(composite2.getFont());
        this.emulatedMachineText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        label = new Label(composite2, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.additionalOptions"));
        label.setFont(composite2.getFont());
        this.additionalOptionsText = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.additionalOptionsText.setLayoutData((Object)gridData);
        this.additionalOptionsText.setFont(composite2.getFont());
        this.additionalOptionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                QEmuBinarySettingsWizardPage.this.updateUsage();
                QEmuBinarySettingsWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        label = new Label(composite2, 0);
        label.setText(QEmuPlugin.getResourceString("QEmuBinarySettingsWizardPage.usage"));
        label.setFont(composite2.getFont());
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.usage = new StyledText(composite2, 2122);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 3;
        gridData.minimumHeight = 100;
        this.usage.setLayoutData((Object)gridData);
        this.setControl((Control)composite2);
    }

    public boolean isPageComplete() {
        if (this.installedDirText == null || this.installedDirText.isDisposed()) {
            return false;
        }
        return this.installedDirText != null && this.installedDirText.getText().trim() != "" && this.emulatorBinaryText != null && this.emulatorBinaryText.getText().trim() != "";
    }

    public void dispose() {
        if (this.getControl() != null) {
            this.setControl(null);
        }
        super.dispose();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("InstalledDirectory", this.installedDirText.getText());
        properties.put("QEmuBinaryName", this.emulatorBinaryText.getText());
        if (this.kernelImageText.getText().trim() != "") {
            properties.put("KernelImage", this.kernelImageText.getText());
        }
        if (this.initrdText.getText().trim() != "") {
            properties.put("InitialRAMDisk", this.initrdText.getText());
        }
        if (this.emulatedMachineText.getText().trim() != "") {
            properties.put("EmulatedMachine", this.emulatedMachineText.getText());
        }
        if (this.startVNCButton.getSelection()) {
            properties.put("EnableVNC", Boolean.TRUE.toString());
        } else {
            properties.put("EnableVNC", Boolean.FALSE.toString());
        }
        if (this.additionalOptionsText.getText().trim() != "") {
            properties.put("AdditionalOptions", this.additionalOptionsText.getText());
        }
        return properties;
    }

    private String getRelativePath(String string) {
        if (string.startsWith(this.installedDirText.getText())) {
            return string.substring(this.installedDirText.getText().length() + 1);
        }
        return string;
    }

    private void updateUsage() {
        IWizardPage iWizardPage;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.emulatorBinaryText.getText().trim() != "") {
            stringBuffer.append(this.emulatorBinaryText.getText().trim());
        }
        if (this.kernelImageText.getText().trim() != "") {
            stringBuffer.append(" -kernel ");
            stringBuffer.append(this.kernelImageText.getText().trim());
        }
        if (this.initrdText.getText().trim() != "") {
            stringBuffer.append(" -initrd ");
            stringBuffer.append(this.initrdText.getText().trim());
        }
        if (this.emulatedMachineText.getText().trim() != "") {
            stringBuffer.append(" -M ");
            stringBuffer.append(this.emulatedMachineText.getText().trim());
        }
        if (this.additionalOptionsText.getText().trim() != "") {
            stringBuffer.append(" ");
            stringBuffer.append(this.additionalOptionsText.getText().trim());
            stringBuffer.append(" ");
        }
        if (this.startVNCButton.getSelection() && (iWizardPage = this.getPreviousPage()) instanceof IInstanceProperties) {
            Properties properties = ((IInstanceProperties)iWizardPage).getProperties();
            String string = properties.getProperty("host");
            String string2 = properties.getProperty("display");
            String string3 = null;
            string3 = string != null && string2 != null ? String.valueOf(string) + string2 : "<host>:<display>";
            stringBuffer.append(" -vnc " + string3);
        }
        this.usage.setText(stringBuffer.toString());
    }
}

