/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.AbstractExceptionStatus;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahExceptionStatus;
import org.eclipse.sequoyah.localization.stringeditor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.TranslationInfo;
import org.eclipse.sequoyah.localization.stringeditor.editor.input.IStringEditorInput;
import org.eclipse.sequoyah.localization.tools.LocalizationToolsPlugin;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNode;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNodeComment;
import org.eclipse.sequoyah.localization.tools.datamodel.TranslationResult;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ITranslator;
import org.eclipse.sequoyah.localization.tools.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.ProjectLocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.TranslatorManager;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditorInput
extends IStringEditorInput {
    private ProjectLocalizationManager projectLocalizationManager = null;
    private final LocalizationManager.IFileChangeListener fileChangeListener = new LocalizationManager.IFileChangeListener(){

        public IProject getProject() {
            return StringEditorInput.this.projectLocalizationManager.getLocalizationProject().getProject();
        }

        public void fileChanged(IFile iFile) {
            StringEditorInput.this.notifyInputChange(StringEditorInput.this.getColumnID(iFile));
        }
    };
    private final String LOCALIZATION_ICON = "icons/loc_icon.png";

    public String getTitle() {
        return this.projectLocalizationManager.getLocalizationProject().getProject().getName();
    }

    public RowInfo addRow(RowInfo rowInfo) {
        Object object;
        Object object2;
        RowInfo rowInfo2 = rowInfo;
        String string = rowInfo.getKey();
        boolean bl = rowInfo.isArray();
        Map map = rowInfo.getCells();
        Set set = map.keySet();
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        if (set.size() == 0 && (object2 = iLocalizationSchema.getLocaleInfoFromID(iLocalizationSchema.getDefaultID())) != null) {
            Object object3 = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile((LocaleInfo)object2);
            object = ((LocalizationFile)object3).getStringNodeByKey(rowInfo.getKey(), bl);
            rowInfo2.setKey(((StringNode)object).getKey());
        }
        for (Object object3 : set) {
            object = iLocalizationSchema.getLocaleInfoFromID((String)object3);
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile((LocaleInfo)object);
            String string2 = ((CellInfo)map.get(object3)).getValue();
            String string3 = ((CellInfo)map.get(object3)).getComment();
            StringNode stringNode = new StringNode(string, string2);
            stringNode.setArray(bl);
            StringNodeComment stringNodeComment = new StringNodeComment();
            stringNodeComment.setComment(string3);
            stringNode.setStringNodeComment(stringNodeComment);
            stringNode = localizationFile.addStringNode(stringNode);
            rowInfo2.setKey(stringNode.getKey());
        }
        return rowInfo2;
    }

    public ProjectLocalizationManager getProjectLocalizationManager() {
        return this.projectLocalizationManager;
    }

    public void removeRow(String string) {
        List<LocalizationFile> list = this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles();
        for (LocalizationFile localizationFile : list) {
            localizationFile.removeStringNode(localizationFile.getStringNodeByKey(string));
        }
    }

    public void init(IProject iProject) throws SequoyahException {
        try {
            this.projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(iProject, true);
            LocalizationManager.getInstance().addFileChangeListener(this.fileChangeListener);
            if (this.projectLocalizationManager == null) {
                Status status = new Status(4, LocalizationToolsPlugin.PLUGIN_ID, Messages.StringEditorInput_ErrorInitializingEditor);
                throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, LocalizationToolsPlugin.PLUGIN_ID, Messages.StringEditorInput_FileMalformed);
            throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
        }
    }

    private String getColumnID(IFile iFile) {
        return iFile.getFullPath().removeLastSegments(1).lastSegment();
    }

    public List<ColumnInfo> getColumns() {
        List<LocalizationFile> list = this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles();
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        String string = this.projectLocalizationManager.getProjectLocalizationSchema().getDefaultID();
        for (LocalizationFile localizationFile : list) {
            String string2 = this.getColumnID(localizationFile.getFile());
            String string3 = iLocalizationSchema.getLocaleToolTip(localizationFile.getFile().getFullPath());
            List<StringNode> list2 = localizationFile.getStringNodes();
            HashMap<String, CellInfo> hashMap = new HashMap<String, CellInfo>();
            for (StringNode stringNode : list2) {
                String string4 = stringNode.getStringNodeComment() != null ? stringNode.getStringNodeComment().getComment() : "";
                CellInfo cellInfo = new CellInfo(stringNode.getValue(), string4);
                hashMap.put(stringNode.getKey(), cellInfo);
            }
            arrayList.add(new ColumnInfo(string2, string3, hashMap, !string2.equals(string)));
        }
        return arrayList;
    }

    public boolean translateColumn(String string, TranslationInfo translationInfo, IProgressMonitor iProgressMonitor) {
        boolean bl = true;
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo localeInfo = iLocalizationSchema.getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        if (localizationFile != null) {
            LocaleInfo localeInfo2 = iLocalizationSchema.getLocaleInfoFromID(translationInfo.getId());
            String string2 = iLocalizationSchema.getPathFromLocaleInfo(localeInfo2);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2));
            LocalizationFile localizationFile2 = this.projectLocalizationManager.getProjectLocalizationSchema().createLocalizationFile(iFile, localeInfo2, new ArrayList<StringNode>(), null);
            localizationFile2.setLocalizationProject(this.projectLocalizationManager.getLocalizationProject());
            bl = this.translateColumn(localizationFile, localizationFile2, translationInfo, iProgressMonitor);
            if (bl) {
                this.projectLocalizationManager.getLocalizationProject().addLocalizationFile(localizationFile2);
                localizationFile2.setDirty(true);
            }
        } else {
            iProgressMonitor.setCanceled(true);
            BasePlugin.logError((String)(String.valueOf(Messages.StringEditorInput_0) + string + Messages.StringEditorInput_1));
        }
        return bl;
    }

    public boolean translateCells(String string, TranslationInfo[] translationInfoArray, IProgressMonitor iProgressMonitor) {
        try {
            Object object;
            iProgressMonitor.beginTask(Messages.TranslationProgress_Connecting, translationInfoArray.length);
            ITranslator iTranslator = TranslatorManager.getInstance().getTranslatorByName(translationInfoArray[0].getTranslator());
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            TranslationInfo[] translationInfoArray2 = translationInfoArray;
            int n = translationInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = translationInfoArray2[n2];
                arrayList.add(object.getFromWord());
                arrayList2.add(object.getFromLang());
                arrayList3.add(object.getToLang());
                iProgressMonitor.worked(1);
                ++n2;
            }
            iProgressMonitor.beginTask(Messages.TranslationProgress_FetchingInformation, 100);
            object = iTranslator.translateAll(arrayList, arrayList2, arrayList3, iProgressMonitor);
            n2 = 0;
            iProgressMonitor.done();
            iProgressMonitor.beginTask(Messages.ParsingAnswer, translationInfoArray.length * 3);
            TranslationInfo[] translationInfoArray3 = translationInfoArray;
            int n3 = translationInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TranslationInfo translationInfo = translationInfoArray3[n4];
                iProgressMonitor.worked(1);
                String string2 = ((TranslationResult)object.get(n2++)).getTranslatedWord();
                iProgressMonitor.worked(1);
                translationInfo.setToWord(string2);
                iProgressMonitor.worked(1);
                ++n4;
            }
            iProgressMonitor.done();
        }
        catch (Exception exception) {
            BasePlugin.logError((String)exception.getMessage());
            iProgressMonitor.setCanceled(true);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean translateColumn(LocalizationFile localizationFile, LocalizationFile localizationFile2, TranslationInfo translationInfo, IProgressMonitor iProgressMonitor) {
        List<TranslationResult> list;
        List<StringNode> list2 = localizationFile.getStringNodes();
        iProgressMonitor.beginTask(Messages.TranslationProgress_Connecting, list2.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StringNode object : list2) {
            arrayList.add(object.getValue());
            iProgressMonitor.worked(1);
        }
        iProgressMonitor.done();
        try {
            ITranslator exception = TranslatorManager.getInstance().getTranslatorByName(translationInfo.getTranslator());
            iProgressMonitor.beginTask(Messages.TranslationProgress_FetchingInformation, 100);
            list = exception.translateAll(arrayList, translationInfo.getFromLang(), translationInfo.getToLang(), iProgressMonitor);
        }
        catch (Exception n) {
            BasePlugin.logError((String)n.getMessage());
            iProgressMonitor.setCanceled(true);
            return false;
        }
        iProgressMonitor.done();
        boolean bl = false;
        iProgressMonitor.beginTask(Messages.ParsingAnswer, list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            void var8_12;
            iProgressMonitor.worked(1);
            TranslationResult translationResult = (TranslationResult)iterator.next();
            String string = translationResult.getTranslatedWord();
            StringNode stringNode = new StringNode(list2.get((int)var8_12).getKey(), string);
            stringNode.setArray(list2.get((int)var8_12).isArray());
            ++var8_12;
            localizationFile2.addStringNode(stringNode);
            translationInfo.addCell(stringNode.getKey(), new CellInfo(stringNode.getValue(), ""));
        }
        iProgressMonitor.done();
        return true;
    }

    public void addColumn(String string) {
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo localeInfo = iLocalizationSchema.getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        if (localizationFile == null) {
            String string2 = iLocalizationSchema.getPathFromLocaleInfo(localeInfo);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2));
            LocalizationFile localizationFile2 = this.projectLocalizationManager.getProjectLocalizationSchema().createLocalizationFile(iFile, localeInfo, new ArrayList<StringNode>(), null);
            localizationFile2.setLocalizationProject(this.projectLocalizationManager.getLocalizationProject());
            localizationFile2.setDirty(true);
            this.projectLocalizationManager.getLocalizationProject().addLocalizationFile(localizationFile2);
        } else {
            localizationFile.setToBeDeleted(false);
        }
    }

    public void removeColumn(String string) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        this.projectLocalizationManager.markFileForDeletion(localizationFile);
        this.projectLocalizationManager.getLocalizationProject().setDirty(true);
    }

    public void setValue(String string, String string2, String string3) throws SequoyahException {
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, LocalizationToolsPlugin.PLUGIN_ID, Messages.StringEditorInput_ErrorManagerNotInitialized);
            throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
        }
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        localizationFile.getStringNodeByKey(string2).setValue(string3);
    }

    public CellInfo getValue(String string, String string2) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        StringNode stringNode = localizationFile.getStringNodeByKey(string2);
        return new CellInfo(stringNode.getValue(), stringNode.getStringNodeComment() != null ? stringNode.getStringNodeComment().getComment() : null);
    }

    public Map<String, CellInfo> getValues(String string) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        HashMap<String, CellInfo> hashMap = new HashMap<String, CellInfo>();
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        List<StringNode> list = localizationFile.getStringNodes();
        for (StringNode stringNode : list) {
            String string2 = "";
            if (stringNode.getStringNodeComment() != null) {
                string2 = stringNode.getStringNodeComment().getComment();
            }
            hashMap.put(stringNode.getKey(), new CellInfo(stringNode.getValue(), string2));
        }
        return hashMap;
    }

    public List<CellInfo> getAvailableKeysForColumn(String string) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        ArrayList<CellInfo> arrayList = new ArrayList<CellInfo>();
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        List<StringNode> list = localizationFile.getStringNodes();
        for (StringNode stringNode : list) {
            arrayList.add(new CellInfo(stringNode.getKey(), stringNode.getStringNodeComment().getComment()));
        }
        return arrayList;
    }

    public boolean canSave() {
        return true;
    }

    public boolean save() {
        boolean bl = this.projectLocalizationManager.saveProject();
        return bl;
    }

    public boolean isDirty() {
        boolean bl = false;
        if (this.projectLocalizationManager != null) {
            bl = this.projectLocalizationManager.getLocalizationProject().isDirty();
        }
        return bl;
    }

    public boolean exists() {
        return this.projectLocalizationManager.getAvailableLocales().size() > 0;
    }

    public ImageDescriptor getImageDescriptor() {
        return LocalizationToolsPlugin.imageDescriptorFromPlugin((String)LocalizationToolsPlugin.PLUGIN_ID, (String)"icons/loc_icon.png");
    }

    public String getName() {
        String string = "";
        if (this.projectLocalizationManager != null) {
            string = this.projectLocalizationManager.getProjectLocalizationSchema().getEditorName();
        }
        return string;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public boolean canRevertByColumn() {
        return true;
    }

    public boolean revert() {
        LocalizationManager.getInstance().unloadProjectLocalizationManager(this.projectLocalizationManager.getLocalizationProject().getProject());
        try {
            LocalizationManager.getInstance().getProjectLocalizationManager(this.projectLocalizationManager.getLocalizationProject().getProject(), false);
        }
        catch (IOException iOException) {}
        return true;
    }

    public boolean revert(String string) throws IOException {
        boolean bl = false;
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        if (localeInfo != null) {
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
            LocalizationFile localizationFile2 = iLocalizationSchema.loadFile(localizationFile.getFile());
            this.projectLocalizationManager.getLocalizationProject().removeLocalizationFile(localizationFile);
            this.projectLocalizationManager.getLocalizationProject().addLocalizationFile(localizationFile2);
            bl = true;
        }
        return bl;
    }

    public String getToolTipText() {
        return this.projectLocalizationManager.getProjectLocalizationSchema().getEditorName();
    }

    public void dispose() {
        if (this.projectLocalizationManager != null) {
            LocalizationManager.getInstance().removeFileChangeListener(this.fileChangeListener);
            LocalizationManager.getInstance().unloadProjectLocalizationManager(this.projectLocalizationManager.getLocalizationProject().getProject());
            this.projectLocalizationManager = null;
        }
    }

    public static void stopListening() {
    }

    public void removeCell(String string, String string2) {
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo localeInfo = iLocalizationSchema.getLocaleInfoFromID(string2);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        if (iLocalizationSchema.getDefaultID() != null && iLocalizationSchema.getDefaultID().equals(string2)) {
            try {
                this.setValue(string2, string, "");
            }
            catch (SequoyahException sequoyahException) {}
        } else {
            localizationFile.removeStringNode(localizationFile.getStringNodeByKey(string));
        }
    }

    public void setCellTooltip(String string, String string2, String string3) throws SequoyahException {
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, LocalizationToolsPlugin.PLUGIN_ID, Messages.StringEditorInput_ErrorManagerNotInitialized);
            throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
        }
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        StringNodeComment stringNodeComment = localizationFile.getStringNodeByKey(string2).getStringNodeComment();
        if (stringNodeComment == null) {
            stringNodeComment = new StringNodeComment();
        }
        localizationFile.getStringNodeByKey(string2).setStringNodeComment(stringNodeComment);
        stringNodeComment.setComment(string3);
    }

    public IStatus validate() {
        Status status = new Status(0, LocalizationToolsPlugin.PLUGIN_ID, "");
        String string = this.projectLocalizationManager.getProjectLocalizationSchema().getDefaultID();
        if (string != null) {
            LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
            if (localizationFile == null) {
                status = new Status(2, LocalizationToolsPlugin.PLUGIN_ID, Messages.Warning_NoDefaultFile);
            } else if (localizationFile.isToBeDeleted()) {
                status = new Status(2, LocalizationToolsPlugin.PLUGIN_ID, Messages.Warning_NoDefaultFile);
            }
        }
        return status;
    }

    public boolean canHandle(IFile iFile) {
        boolean bl = false;
        ILocalizationSchema iLocalizationSchema = LocalizationManager.getInstance().getLocalizationSchema(iFile.getProject());
        if (iLocalizationSchema != null) {
            bl = iLocalizationSchema.isLocalizationFile(iFile);
        }
        return bl;
    }
}

