/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.extensions.implementation.generic;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sequoyah.localization.tools.LocalizationToolsPlugin;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ITranslator;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.TranslatorConstants;
import org.eclipse.sequoyah.localization.tools.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.managers.PreferencesManager;
import org.eclipse.sequoyah.localization.tools.managers.TranslatorManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguagesUtil
implements TranslatorConstants {
    private static Map<String, String> availableLanguages = new LinkedHashMap<String, String>();
    private static String COMBO_SEPARATOR = Messages.LanguagesUtil_0;
    private static Image warningImage = new Image((Device)Display.getDefault(), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK").getImageData().scaledTo(16, 16));
    private static Image okImage = new Image((Device)Display.getDefault(), LocalizationToolsPlugin.imageDescriptorFromPlugin((String)LocalizationToolsPlugin.PLUGIN_ID, (String)Messages.LanguagesUtil_1).getImageData());

    static {
        availableLanguages.put(Messages.LanguagesUtil_2, AFRIKAANS);
        availableLanguages.put(Messages.LanguagesUtil_3, ALBANIAN);
        availableLanguages.put(Messages.LanguagesUtil_4, AMHARIC);
        availableLanguages.put(Messages.LanguagesUtil_5, ARABIC);
        availableLanguages.put(Messages.LanguagesUtil_6, ARMENIAN);
        availableLanguages.put(Messages.LanguagesUtil_7, AZERBAIJANI);
        availableLanguages.put(Messages.LanguagesUtil_8, BASQUE);
        availableLanguages.put(Messages.LanguagesUtil_9, BELARUSIAN);
        availableLanguages.put(Messages.LanguagesUtil_10, BENGALI);
        availableLanguages.put(Messages.LanguagesUtil_11, BIHARI);
        availableLanguages.put(Messages.LanguagesUtil_12, BULGARIAN);
        availableLanguages.put(Messages.LanguagesUtil_13, BURMESE);
        availableLanguages.put(Messages.LanguagesUtil_14, CATALAN);
        availableLanguages.put(Messages.LanguagesUtil_15, CHEROKEE);
        availableLanguages.put(Messages.LanguagesUtil_16, CHINESE);
        availableLanguages.put(Messages.LanguagesUtil_17, CHINESE_SIMPLIFIED);
        availableLanguages.put(Messages.LanguagesUtil_18, CHINESE_TRADITIONAL);
        availableLanguages.put(Messages.LanguagesUtil_19, CROATIAN);
        availableLanguages.put(Messages.LanguagesUtil_20, CZECH);
        availableLanguages.put(Messages.LanguagesUtil_21, DANISH);
        availableLanguages.put(Messages.LanguagesUtil_22, DHIVEHI);
        availableLanguages.put(Messages.LanguagesUtil_23, DUTCH);
        availableLanguages.put(Messages.LanguagesUtil_24, ENGLISH);
        availableLanguages.put(Messages.LanguagesUtil_25, ESPERANTO);
        availableLanguages.put(Messages.LanguagesUtil_26, ESTONIAN);
        availableLanguages.put(Messages.LanguagesUtil_27, FILIPINO);
        availableLanguages.put(Messages.LanguagesUtil_28, FINNISH);
        availableLanguages.put(Messages.LanguagesUtil_29, FRENCH);
        availableLanguages.put(Messages.LanguagesUtil_30, GALACIAN);
        availableLanguages.put(Messages.LanguagesUtil_31, GEORGIAN);
        availableLanguages.put(Messages.LanguagesUtil_32, GERMAN);
        availableLanguages.put(Messages.LanguagesUtil_33, GREEK);
        availableLanguages.put(Messages.LanguagesUtil_34, GUARANI);
        availableLanguages.put(Messages.LanguagesUtil_35, GUJARATI);
        availableLanguages.put(Messages.LanguagesUtil_36, HEBREW);
        availableLanguages.put(Messages.LanguagesUtil_37, HINDI);
        availableLanguages.put(Messages.LanguagesUtil_38, HUNGARIAN);
        availableLanguages.put(Messages.LanguagesUtil_39, ICELANDIC);
        availableLanguages.put(Messages.LanguagesUtil_40, INDONESIAN);
        availableLanguages.put(Messages.LanguagesUtil_41, INUKTITUT);
        availableLanguages.put(Messages.LanguagesUtil_42, IRISH);
        availableLanguages.put(Messages.LanguagesUtil_43, ITALIAN);
        availableLanguages.put(Messages.LanguagesUtil_44, JAPANESE);
        availableLanguages.put(Messages.LanguagesUtil_45, KANNADA);
        availableLanguages.put(Messages.LanguagesUtil_46, KAZAKH);
        availableLanguages.put(Messages.LanguagesUtil_47, KHMER);
        availableLanguages.put(Messages.LanguagesUtil_48, KOREAN);
        availableLanguages.put(Messages.LanguagesUtil_49, KURDISH);
        availableLanguages.put(Messages.LanguagesUtil_50, KYRGYZ);
        availableLanguages.put(Messages.LanguagesUtil_51, LAOTHIAN);
        availableLanguages.put(Messages.LanguagesUtil_52, LATVIAN);
        availableLanguages.put(Messages.LanguagesUtil_53, LITHUANIAN);
        availableLanguages.put(Messages.LanguagesUtil_54, MACEDONIAN);
        availableLanguages.put(Messages.LanguagesUtil_55, MALAY);
        availableLanguages.put(Messages.LanguagesUtil_56, MALAYALAM);
        availableLanguages.put(Messages.LanguagesUtil_57, MALTESE);
        availableLanguages.put(Messages.LanguagesUtil_58, MARATHI);
        availableLanguages.put(Messages.LanguagesUtil_59, MONGOLIAN);
        availableLanguages.put(Messages.LanguagesUtil_60, NEPALI);
        availableLanguages.put(Messages.LanguagesUtil_61, NORWEGIAN);
        availableLanguages.put(Messages.LanguagesUtil_62, ORIYA);
        availableLanguages.put(Messages.LanguagesUtil_63, PASHTO);
        availableLanguages.put(Messages.LanguagesUtil_64, PERSIAN);
        availableLanguages.put(Messages.LanguagesUtil_65, POLISH);
        availableLanguages.put(Messages.LanguagesUtil_66, PORTUGUESE);
        availableLanguages.put(Messages.LanguagesUtil_67, PUNJABI);
        availableLanguages.put(Messages.LanguagesUtil_68, ROMANIAN);
        availableLanguages.put(Messages.LanguagesUtil_69, RUSSIAN);
        availableLanguages.put(Messages.LanguagesUtil_70, SANSKRIT);
        availableLanguages.put(Messages.LanguagesUtil_71, SERBIAN);
        availableLanguages.put(Messages.LanguagesUtil_72, SINDHI);
        availableLanguages.put(Messages.LanguagesUtil_73, SINHALESE);
        availableLanguages.put(Messages.LanguagesUtil_74, SLOVAK);
        availableLanguages.put(Messages.LanguagesUtil_75, SLOVENIAN);
        availableLanguages.put(Messages.LanguagesUtil_76, SPANISH);
        availableLanguages.put(Messages.LanguagesUtil_77, SWAHILI);
        availableLanguages.put(Messages.LanguagesUtil_78, SWEDISH);
        availableLanguages.put(Messages.LanguagesUtil_79, TAJIK);
        availableLanguages.put(Messages.LanguagesUtil_80, TAMIL);
        availableLanguages.put(Messages.LanguagesUtil_81, TAGALOG);
        availableLanguages.put(Messages.LanguagesUtil_82, TELUGU);
        availableLanguages.put(Messages.LanguagesUtil_83, THAI);
        availableLanguages.put(Messages.LanguagesUtil_84, TIBETAN);
        availableLanguages.put(Messages.LanguagesUtil_85, TURKISH);
        availableLanguages.put(Messages.LanguagesUtil_86, UKRANIAN);
        availableLanguages.put(Messages.LanguagesUtil_87, URDU);
        availableLanguages.put(Messages.LanguagesUtil_88, UZBEK);
        availableLanguages.put(Messages.LanguagesUtil_89, UIGHUR);
        availableLanguages.put(Messages.LanguagesUtil_90, VIETNAMESE);
        availableLanguages.put(Messages.LanguagesUtil_91, WELSH);
        availableLanguages.put(Messages.LanguagesUtil_92, YIDDISH);
        availableLanguages.put(Messages.LanguagesUtil_93, VIETNAMESE);
        availableLanguages.put(Messages.LanguagesUtil_94, WELSH);
        availableLanguages.put(Messages.LanguagesUtil_95, YIDDISH);
    }

    public static List<String> getAvailableLanguages() {
        return new ArrayList<String>(availableLanguages.keySet());
    }

    public static List<String> getPreferredLanguages(ILocalizationSchema iLocalizationSchema) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = iLocalizationSchema.getPreferedLanguages();
        if (list != null) {
            for (String string : list) {
                arrayList.add(LanguagesUtil.getLanguageName(string));
            }
        }
        return arrayList;
    }

    public static String getComboSeparator() {
        return COMBO_SEPARATOR;
    }

    public static String getLanguageID(String string) {
        return availableLanguages.get(string);
    }

    public static String getLanguageName(String string) {
        String string2 = null;
        for (Map.Entry<String, String> entry : availableLanguages.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            string2 = entry.getKey();
            break;
        }
        return string2;
    }

    public static Combo createTranslatorsCombo(Composite composite) {
        Combo combo = null;
        List<ITranslator> list = TranslatorManager.getInstance().getTranslators();
        ITranslator iTranslator = PreferencesManager.getInstance().getDefaultTranslator();
        String string = iTranslator != null ? iTranslator.getName() : "";
        combo = new Combo(composite, 12);
        String[] stringArray = new String[list.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            stringArray[n2] = list.get(n2).getName();
            if (stringArray[n2].equals(string)) {
                n = n2;
            }
            ++n2;
        }
        combo.setItems(stringArray);
        combo.select(n);
        return combo;
    }

    public static Combo createLanguagesCombo(Composite composite, String string, String string2, ILocalizationSchema iLocalizationSchema) {
        Combo combo = null;
        List<String> list = LanguagesUtil.getAvailableLanguages();
        List<String> list2 = LanguagesUtil.getPreferredLanguages(iLocalizationSchema);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list2);
        arrayList.add(COMBO_SEPARATOR);
        arrayList.addAll(list);
        combo = new Combo(composite, 12);
        if (arrayList.size() > 0) {
            combo.setItems(arrayList.toArray(new String[arrayList.size()]));
            String string3 = string;
            if (string3 == null) {
                string3 = string2;
            }
            if (string3 != null) {
                String string4 = LanguagesUtil.getLanguageName(string3);
                int n = 0;
                int n2 = 0;
                while (n2 < combo.getItems().length) {
                    String string5 = combo.getItem(n2);
                    if (string5.equals(string4)) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                combo.select(n);
            } else {
                combo.select(0);
            }
        }
        return combo;
    }

    public static Label createImageStatus(Composite composite, String string) {
        Label label = new Label(composite, 0);
        LanguagesUtil.changeImageStatus(label, string);
        return label;
    }

    public static void changeImageStatus(Label label, String string) {
        if (string != null) {
            label.setImage(okImage);
            label.setToolTipText(Messages.TranslationDialog_ImageOKTooltip);
        } else {
            label.setImage(warningImage);
            label.setToolTipText(Messages.TranslationDialog_ImageWARNTooltip);
        }
    }
}

