/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.localization.tools.datamodel.TranslationResult;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ITranslator;
import org.eclipse.sequoyah.localization.tools.extensions.providers.TranslatorProvider;
import org.eclipse.sequoyah.localization.tools.managers.Messages;
import org.eclipse.sequoyah.localization.tools.managers.PreferencesManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatorManager {
    private Map<String, ITranslator> translators;
    private PreferencesManager preferencesManager;
    private TranslatorProvider translatorProvider = TranslatorProvider.getInstance();
    private static TranslatorManager instance = null;

    public static TranslatorManager getInstance() {
        if (instance == null) {
            instance = new TranslatorManager();
        }
        return instance;
    }

    public TranslatorManager() {
        this.preferencesManager = PreferencesManager.getInstance();
        this.translators = this.translatorProvider.getTranslators();
        this.preferencesManager.setDefaultTranslator(this.translators.get(Messages.TranslatorManager_0));
    }

    public TranslationResult translate(String string, String string2, String string3) {
        TranslationResult translationResult = null;
        ITranslator iTranslator = this.preferencesManager.getDefaultTranslator();
        try {
            translationResult = iTranslator.translate(string, string2, string3);
        }
        catch (Exception exception) {
            BasePlugin.logError((String)Messages.TranslatorManager_1);
        }
        return translationResult;
    }

    public List<TranslationResult> translateAll(List<String> list, String string, String string2) {
        List<TranslationResult> list2 = null;
        ITranslator iTranslator = this.preferencesManager.getDefaultTranslator();
        try {
            list2 = iTranslator.translateAll(list, string, string2, null);
        }
        catch (Exception exception) {
            BasePlugin.logError((String)Messages.TranslatorManager_2);
        }
        return list2;
    }

    public List<ITranslator> getTranslators() {
        return new ArrayList<ITranslator>(this.translators.values());
    }

    public ITranslator getTranslatorByName(String string) {
        return this.translators.get(string);
    }

    public void setTranslatorBranding(String string, Label label) {
        ITranslator iTranslator = this.getTranslatorByName(string);
        Image image = iTranslator.getBrandingImg();
        if (image != null) {
            label.setImage(image);
        }
    }
}

