/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.internal.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.vnc.protocol.exceptions.MalformedProtocolExtensionException;
import org.eclipse.sequoyah.vnc.protocol.internal.model.PluginProtocolModel;
import org.eclipse.sequoyah.vnc.protocol.internal.model.ProtocolBean;
import org.eclipse.sequoyah.vnc.protocol.internal.reader.IExtensionConstants;
import org.eclipse.sequoyah.vnc.protocol.internal.reader.Messages;
import org.eclipse.sequoyah.vnc.protocol.lib.IMessageHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolHandshake;
import org.eclipse.sequoyah.vnc.protocol.lib.IRawDataHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.NullMessageHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.ProtocolMsgDefinition;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.FixedSizeDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.IMsgDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.IteratableBlockDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.RawDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.VariableSizeDataBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolExtensionsReader
implements IExtensionConstants {
    public static ProtocolBean readProtocolImplDef(String string) throws MalformedProtocolExtensionException {
        ProtocolBean protocolBean = new ProtocolBean();
        protocolBean.setProtocolId(string);
        IConfigurationElement iConfigurationElement = ProtocolExtensionsReader.getProtocolConfElem(string);
        protocolBean.setParentProtocol(ProtocolExtensionsReader.getImmediateProtocolParent(string));
        protocolBean.setBigEndianProtocol(Boolean.parseBoolean(iConfigurationElement.getAttribute("isBigEndianProtocol")));
        try {
            Object object = iConfigurationElement.createExecutableExtension("handshake");
            if (!(object instanceof IProtocolHandshake)) {
                BasePlugin.logError((String)(String.valueOf(Messages.ProtocolExtensionsReader_0) + string + Messages.ProtocolExtensionsReader_1));
                throw new MalformedProtocolExtensionException("The protocol has not declared a valid handshake");
            }
            protocolBean.setProtocolInitSeed((IProtocolHandshake)object);
        }
        catch (CoreException coreException) {
            BasePlugin.logError((String)(String.valueOf(Messages.ProtocolExtensionsReader_2) + string + Messages.ProtocolExtensionsReader_3));
            throw new MalformedProtocolExtensionException(coreException.getMessage(), coreException);
        }
        return protocolBean;
    }

    public static Map<Long, ProtocolMsgDefinition> readMessageDefinitions(String string) throws MalformedProtocolExtensionException {
        return ProtocolExtensionsReader.getAllProtocolMessages(ProtocolExtensionsReader.getAllParentProtocols(string), true);
    }

    public static Collection<String> readServerMessages(String string) {
        return ProtocolExtensionsReader.getMessagesOrientations(ProtocolExtensionsReader.getAllParentProtocols(string), "serverMessage");
    }

    public static Collection<String> readClientMessages(String string) {
        return ProtocolExtensionsReader.getMessagesOrientations(ProtocolExtensionsReader.getAllParentProtocols(string), "clientMessage");
    }

    private static String getImmediateProtocolParent(String string) {
        String string2 = null;
        IConfigurationElement iConfigurationElement = ProtocolExtensionsReader.getProtocolConfElem(string);
        if (iConfigurationElement != null) {
            string2 = iConfigurationElement.getAttribute("parentProtocol");
        }
        return string2;
    }

    private static IConfigurationElement getProtocolConfElem(String string) {
        IExtension[] iExtensionArray;
        IConfigurationElement iConfigurationElement = null;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.sequoyah.vnc.protocol.protocolDefinition");
        IExtension[] iExtensionArray2 = iExtensionArray = iExtensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] iConfigurationElementArray;
            IExtension iExtension = iExtensionArray2[n2];
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string2;
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n4];
                if (iConfigurationElement2.getName().equals("protocol") && (string2 = iConfigurationElement2.getAttribute("protocolId")).equals(string)) {
                    iConfigurationElement = iConfigurationElement2;
                    break;
                }
                ++n4;
            }
            if (iConfigurationElement != null) break;
            ++n2;
        }
        return iConfigurationElement;
    }

    private static List<String> getAllParentProtocols(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        String string2 = string;
        do {
            if ((string2 = ProtocolExtensionsReader.getImmediateProtocolParent(string2)) == null) continue;
            arrayList.add(string2);
        } while (string2 != null);
        return arrayList;
    }

    private static Map<Long, ProtocolMsgDefinition> getAllProtocolMessages(List<String> list, boolean bl) throws MalformedProtocolExtensionException {
        HashMap<Long, ProtocolMsgDefinition> hashMap = new HashMap<Long, ProtocolMsgDefinition>();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.sequoyah.vnc.protocol.protocolMessage");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (String string : list) {
            IExtension[] iExtensionArray2 = iExtensionArray;
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] iConfigurationElementArray;
                IExtension iExtension = iExtensionArray2[n2];
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n4];
                    String string2 = iConfigurationElement.getAttribute("protocolId");
                    if (string.equals(string2)) {
                        ProtocolExtensionsReader.readMsgDefToCollection(iConfigurationElement, hashMap, bl);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return hashMap;
    }

    private static void readMsgDefToCollection(IConfigurationElement iConfigurationElement, Map<Long, ProtocolMsgDefinition> map, boolean bl) throws MalformedProtocolExtensionException {
        ProtocolMsgDefinition protocolMsgDefinition = new ProtocolMsgDefinition();
        long l = Long.decode(iConfigurationElement.getAttribute("messageCode"));
        String string = iConfigurationElement.getAttribute("messageId");
        boolean bl2 = Boolean.parseBoolean(iConfigurationElement.getAttribute("isMessageCodeSigned"));
        int n = Integer.decode(iConfigurationElement.getAttribute("messageCodeSizeInBytes"));
        try {
            Object object;
            Object object2;
            ArrayList<IMsgDataBean> arrayList;
            IMessageHandler iMessageHandler = null;
            if (iConfigurationElement.getAttribute("messageHandler") != null) {
                arrayList = iConfigurationElement.createExecutableExtension("messageHandler");
                if (!(arrayList instanceof IMessageHandler)) {
                    BasePlugin.logError((String)Messages.ProtocolExtensionsReader_4);
                    throw new MalformedProtocolExtensionException("Error at message declaration. The message handler must be an instance of IMessageHandler");
                }
                iMessageHandler = (IMessageHandler)((Object)arrayList);
            } else {
                iMessageHandler = new NullMessageHandler();
            }
            arrayList = new ArrayList<IMsgDataBean>();
            if (bl) {
                object2 = iConfigurationElement.getChildren();
                IConfigurationElement[] iConfigurationElementArray = object2;
                int n2 = ((IConfigurationElement[])object2).length;
                int n3 = 0;
                while (n3 < n2) {
                    object = iConfigurationElementArray[n3];
                    IMsgDataBean iMsgDataBean = ProtocolExtensionsReader.readMsgData((IConfigurationElement)object);
                    arrayList.add(iMsgDataBean);
                    ++n3;
                }
            }
            protocolMsgDefinition.setCode(l);
            protocolMsgDefinition.setId(string);
            protocolMsgDefinition.setMsgCodeSigned(bl2);
            protocolMsgDefinition.setMsgCodeSizeInBytes(n);
            protocolMsgDefinition.setHandler(iMessageHandler);
            protocolMsgDefinition.setMessageData(arrayList);
            object2 = PluginProtocolModel.getInstance();
            object = ((PluginProtocolModel)object2).getClientMessages(iConfigurationElement.getAttribute("protocolId"));
            Collection<String> collection = ((PluginProtocolModel)object2).getServerMessages(iConfigurationElement.getAttribute("protocolId"));
            if (object.contains(string) && !map.containsKey(l)) {
                map.put(l, protocolMsgDefinition);
            }
            if (collection.contains(string) && !map.containsKey(-l)) {
                map.put(-l, protocolMsgDefinition);
            }
        }
        catch (CoreException coreException) {
            BasePlugin.logWarning((String)(String.valueOf(Messages.ProtocolExtensionsReader_5) + string + Messages.ProtocolExtensionsReader_6));
        }
    }

    private static IMsgDataBean readMsgData(IConfigurationElement iConfigurationElement) throws MalformedProtocolExtensionException, CoreException {
        IMsgDataBean iMsgDataBean = null;
        if (iConfigurationElement.getName().equals("fixedSizeData")) {
            FixedSizeDataBean fixedSizeDataBean = new FixedSizeDataBean();
            String string = iConfigurationElement.getAttribute("fieldName");
            boolean bl = Boolean.parseBoolean(iConfigurationElement.getAttribute("isFieldSigned"));
            int n = Integer.decode(iConfigurationElement.getAttribute("fieldSizeInBytes"));
            String string2 = iConfigurationElement.getAttribute("value");
            fixedSizeDataBean.setFieldName(string);
            fixedSizeDataBean.setFieldSigned(bl);
            fixedSizeDataBean.setFieldSizeInBytes(n);
            if (string2 != null) {
                fixedSizeDataBean.setValue(Integer.decode(string2));
            }
            iMsgDataBean = fixedSizeDataBean;
        } else if (iConfigurationElement.getName().equals("variableSizeData")) {
            VariableSizeDataBean variableSizeDataBean = new VariableSizeDataBean();
            String string = iConfigurationElement.getAttribute("sizeFieldName");
            boolean bl = Boolean.parseBoolean(iConfigurationElement.getAttribute("isSizeFieldSigned"));
            int n = Integer.decode(iConfigurationElement.getAttribute("sizeFieldSizeInBytes"));
            String string3 = iConfigurationElement.getAttribute("valueFieldName");
            String string4 = iConfigurationElement.getAttribute("charsetName");
            String string5 = iConfigurationElement.getAttribute("value");
            variableSizeDataBean.setSizeFieldName(string);
            variableSizeDataBean.setSizeFieldSigned(bl);
            variableSizeDataBean.setSizeFieldSizeInBytes(n);
            variableSizeDataBean.setValueFieldName(string3);
            variableSizeDataBean.setCharsetName(string4);
            if (string5 != null) {
                variableSizeDataBean.setValue(string5);
            }
            iMsgDataBean = variableSizeDataBean;
        } else if (iConfigurationElement.getName().equals("rawDataHandler")) {
            RawDataBean rawDataBean = new RawDataBean();
            Object object = iConfigurationElement.createExecutableExtension("rawDataHandler");
            if (!(object instanceof IRawDataHandler)) {
                BasePlugin.logError((String)Messages.ProtocolExtensionsReader_7);
                throw new MalformedProtocolExtensionException("Error at message declaration. The raw data handler must be an instance of IRawDataHandler");
            }
            rawDataBean.setHandler((IRawDataHandler)object);
            iMsgDataBean = rawDataBean;
        } else if (iConfigurationElement.getName().equals("iteratableBlock")) {
            IConfigurationElement[] iConfigurationElementArray;
            IteratableBlockDataBean iteratableBlockDataBean = new IteratableBlockDataBean();
            String string = iConfigurationElement.getAttribute("iterateOn");
            String string6 = iConfigurationElement.getAttribute("iterableBlockId");
            ArrayList<IMsgDataBean> arrayList = new ArrayList<IMsgDataBean>();
            iteratableBlockDataBean.setIterateOnField(string);
            iteratableBlockDataBean.setId(string6);
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iConfigurationElement.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n2];
                IMsgDataBean iMsgDataBean2 = ProtocolExtensionsReader.readMsgData(iConfigurationElement2);
                arrayList.add(iMsgDataBean2);
                ++n2;
            }
            iteratableBlockDataBean.setDataBeans(arrayList);
            iMsgDataBean = iteratableBlockDataBean;
        } else {
            BasePlugin.logError((String)Messages.ProtocolExtensionsReader_8);
            throw new MalformedProtocolExtensionException("Unkown data element");
        }
        return iMsgDataBean;
    }

    private static Collection<String> getMessagesOrientations(List<String> list, String string) {
        IExtension[] iExtensionArray;
        HashSet<String> hashSet = new HashSet<String>();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.sequoyah.vnc.protocol.protocolMessageDirection");
        IExtension[] iExtensionArray2 = iExtensionArray = iExtensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] iConfigurationElementArray;
            IExtension iExtension = iExtensionArray2[n2];
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n4];
                if (iConfigurationElement.getName().equals(string)) {
                    String string2 = iConfigurationElement.getAttribute("protocolId");
                    String string3 = iConfigurationElement.getAttribute("messageId");
                    if (list.contains(string2)) {
                        hashSet.add(string3);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return hashSet;
    }
}

