/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.qemu.launcher;

import org.eclipse.core.runtime.IPath;
import org.eclipse.sequoyah.device.framework.model.IConnection;
import org.eclipse.sequoyah.device.framework.model.IDeviceLauncher;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.qemu.QEmuPlugin;
import org.eclipse.sequoyah.device.service.start.launcher.DefaultConnection;

public class QEmuLauncher
implements IDeviceLauncher {
    public static final String EMULATOR_PID_FILE_NAME = "qemu.pid";
    public static final String SLASH = "\\";
    public IConnection connection;
    public int pid = 0;
    private IInstance instance;

    public QEmuLauncher(IInstance iInstance) {
        this.instance = iInstance;
        this.connection = new DefaultConnection();
        this.connection.setHost(iInstance.getProperties().getProperty("host"));
        this.connection.setDisplay(iInstance.getProperties().getProperty("display"));
        this.connection.setPort(Integer.parseInt(iInstance.getProperties().getProperty("port")));
    }

    public int getPID() {
        return this.pid;
    }

    public void setPID(int n) {
        this.pid = n;
    }

    public String getFileId() {
        IPath iPath = QEmuPlugin.getDefault().getStateLocation();
        String string = String.valueOf(iPath.addTrailingSeparator().toOSString()) + EMULATOR_PID_FILE_NAME;
        return string;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public String getLocation() {
        return String.valueOf(this.getWorkingDirectory()) + this.instance.getProperties().getProperty("QEmuBinaryName");
    }

    public String getToolArguments() {
        return this.buildEmulatorOptions();
    }

    public String getWorkingDirectory() {
        String string = this.instance.getProperties().getProperty("InstalledDirectory");
        return string.concat(SLASH);
    }

    private String buildEmulatorOptions() {
        String string;
        String string2;
        String string3;
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = this.instance.getProperties().getProperty("KernelImage");
        if (string5 != null && string5 != "") {
            stringBuffer.append(" -kernel ");
            stringBuffer.append(string5);
        }
        if ((string4 = this.instance.getProperties().getProperty("InitialRAMDisk")) != null && string4 != "") {
            stringBuffer.append(" -initrd ");
            stringBuffer.append(string4);
        }
        if ((string3 = this.instance.getProperties().getProperty("EmulatedMachine")) != null && string3 != "") {
            stringBuffer.append(" -M ");
            stringBuffer.append(string3);
        }
        if ((string2 = this.instance.getProperties().getProperty("AdditionalOptions")) != null && string2 != "") {
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        if ((string = this.instance.getProperties().getProperty("EnableVNC")) != null && Boolean.TRUE.toString().equals(string)) {
            stringBuffer.append(" -vnc " + this.connection.getStringHost());
        }
        stringBuffer.append(" -pidfile " + this.getFileId());
        return stringBuffer.toString();
    }
}

