/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.graphics.swt;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;
import org.eclipse.sequoyah.vnc.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.swt.widgets.Event;

public class SWTVNCEventTranslator {
    private static final int BUTTONS = 8;
    private boolean[] buttonPressed;
    private Hashtable<Integer, Integer> swtToKeysymCodes;
    private Properties configProperties;
    private IPropertiesFileHandler propertiesFileHandler;

    public SWTVNCEventTranslator(Properties properties, IPropertiesFileHandler iPropertiesFileHandler) {
        this.configProperties = properties;
        this.propertiesFileHandler = iPropertiesFileHandler;
        this.buttonPressed = new boolean[8];
        int n = 0;
        while (n < 8) {
            this.buttonPressed[n] = false;
            ++n;
        }
        this.initKeysyms();
    }

    public void initKeysyms() {
        String string = this.configProperties.getProperty("KEYSYM_SWT_PROPERTIES_FILE");
        String string2 = this.configProperties.getProperty("KEYSYM_PROPERTIES_FILE");
        String string3 = this.configProperties.getProperty("SWTKEYS_PROPERTIES_FILE");
        Properties properties = this.propertiesFileHandler.loadPropertiesFile(string);
        Properties properties2 = this.propertiesFileHandler.loadPropertiesFile(string2);
        Properties properties3 = this.propertiesFileHandler.loadPropertiesFile(string3);
        this.swtToKeysymCodes = new Hashtable();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            Integer n = new Integer(properties3.getProperty(string4));
            Integer n2 = Integer.decode(properties2.getProperty(properties.getProperty(string4)));
            this.swtToKeysymCodes.put(n, n2);
        }
    }

    public ProtocolMessage getMouseEventMessage(Event event) {
        ProtocolMessage protocolMessage = new ProtocolMessage(5L);
        if (event.button > 0) {
            if (event.type == 3) {
                if (!this.buttonPressed[event.button - 1]) {
                    this.buttonPressed[event.button - 1] = true;
                }
            } else if (event.type == 4 && this.buttonPressed[event.button - 1]) {
                this.buttonPressed[event.button - 1] = false;
            }
        }
        byte by = 0;
        int n = 0;
        while (n < 8) {
            if (this.buttonPressed[n]) {
                by = (byte)(by | (int)Math.pow(2.0, n));
            }
            ++n;
        }
        protocolMessage.setFieldValue("buttonMask", (Object)by);
        protocolMessage.setFieldValue("x-position", (Object)event.x);
        protocolMessage.setFieldValue("y-position", (Object)event.y);
        return protocolMessage;
    }

    public ProtocolMessage getKeyEventMessage(Event event) {
        int n = this.getKeysym(event.keyCode);
        boolean bl = event.type == 1;
        ProtocolMessage protocolMessage = new ProtocolMessage(4L);
        protocolMessage.setFieldValue("downFlag", (Object)(bl ? 1 : 0));
        protocolMessage.setFieldValue("key", (Object)n);
        return protocolMessage;
    }

    public int getKeysym(int n) {
        Integer n2 = this.swtToKeysymCodes.get(new Integer(n));
        int n3 = n2 != null ? n2 : n;
        return n3;
    }
}

