/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib.internal.model;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolHandshake;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolHandshakeException;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.model.Messages;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.model.ServerProtocolEngineFactory;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerModel {
    private static ServerModel instance;
    private Map<ProtocolHandle, ServerSocketChannel> openedSocketChannels = new HashMap<ProtocolHandle, ServerSocketChannel>();
    private Map<ProtocolHandle, ServerProtocolEngineFactory> engineFactories = new HashMap<ProtocolHandle, ServerProtocolEngineFactory>();
    private Map<ProtocolHandle, Collection<ProtocolEngine>> connectedClients = new HashMap<ProtocolHandle, Collection<ProtocolEngine>>();

    private ServerModel() {
    }

    public static ServerModel getInstance() {
        if (instance == null) {
            instance = new ServerModel();
        }
        return instance;
    }

    public ProtocolHandle startListeningToPort(int n, Map<Long, ProtocolMsgDefinition> map, Collection<String> collection, Collection<String> collection2, IProtocolHandshake iProtocolHandshake, IProtocolExceptionHandler iProtocolExceptionHandler, boolean bl) {
        ProtocolHandle protocolHandle;
        block4: {
            protocolHandle = new ProtocolHandle();
            if (n <= 0 || map == null || collection == null || collection2 == null) {
                BasePlugin.logError((String)Messages.ServerModel_0);
                if (iProtocolExceptionHandler != null) {
                    iProtocolExceptionHandler.handleProtocolHandshakeException(protocolHandle, new ProtocolHandshakeException("Invalid parameters provided to method"));
                }
            }
            BasePlugin.logDebugMessage((String)Messages.ServerModel_1, (String)(String.valueOf(Messages.ServerModel_2) + n + Messages.ServerModel_3 + protocolHandle + "."));
            try {
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.socket().bind(new InetSocketAddress(n));
                BasePlugin.logDebugMessage((String)Messages.ServerModel_5, (String)Messages.ServerModel_6);
                ServerProtocolEngineFactory serverProtocolEngineFactory = new ServerProtocolEngineFactory(protocolHandle, iProtocolHandshake, map, collection, collection2, iProtocolExceptionHandler, bl);
                this.openedSocketChannels.put(protocolHandle, serverSocketChannel);
                this.engineFactories.put(protocolHandle, serverProtocolEngineFactory);
                ServerDeamon serverDeamon = new ServerDeamon(protocolHandle, serverSocketChannel, serverProtocolEngineFactory);
                Thread thread = new Thread(serverDeamon);
                thread.start();
            }
            catch (IOException iOException) {
                BasePlugin.logError((String)(String.valueOf(Messages.ServerModel_7) + iOException.getMessage()));
                if (iProtocolExceptionHandler == null) break block4;
                iProtocolExceptionHandler.handleIOException(protocolHandle, iOException);
            }
        }
        return protocolHandle;
    }

    public void stopListeningToPort(ProtocolHandle protocolHandle) {
        ServerSocketChannel serverSocketChannel = this.openedSocketChannels.get(protocolHandle);
        if (serverSocketChannel != null) {
            block4: {
                BasePlugin.logDebugMessage((String)Messages.ServerModel_8, (String)Messages.ServerModel_9);
                try {
                    serverSocketChannel.close();
                }
                catch (IOException iOException) {
                    Object object;
                    BasePlugin.logError((String)(String.valueOf(Messages.ServerModel_10) + iOException.getMessage()));
                    ServerProtocolEngineFactory object2 = this.engineFactories.get(protocolHandle);
                    if (object2 == null || (object = object2.getExceptionHandler()) == null) break block4;
                    object.handleIOException(protocolHandle, iOException);
                }
            }
            BasePlugin.logDebugMessage((String)Messages.ServerModel_11, (String)Messages.ServerModel_12);
            Collection<ProtocolEngine> collection = this.connectedClients.get(protocolHandle);
            for (ProtocolEngine protocolEngine : collection) {
                protocolEngine.dispose();
                collection.remove(protocolEngine);
            }
            this.connectedClients.remove(protocolHandle);
            this.openedSocketChannels.remove(protocolHandle);
            this.engineFactories.remove(protocolHandle);
        }
    }

    public void requestRestartProtocol(ProtocolHandle protocolHandle) {
        ServerSocketChannel serverSocketChannel = this.openedSocketChannels.get(protocolHandle);
        if (serverSocketChannel != null) {
            int n = serverSocketChannel.socket().getLocalPort();
            ServerProtocolEngineFactory serverProtocolEngineFactory = this.engineFactories.get(protocolHandle);
            this.stopListeningToPort(protocolHandle);
            this.startListeningToPort(n, serverProtocolEngineFactory.getAllMessages(), serverProtocolEngineFactory.getIncomingMessages(), serverProtocolEngineFactory.getOutgoingMessages(), null, serverProtocolEngineFactory.getExceptionHandler(), serverProtocolEngineFactory.isBigEndianProtocol());
        }
    }

    public void cleanStoppedProtocols() {
        BasePlugin.logDebugMessage((String)Messages.ServerModel_13, (String)Messages.ServerModel_14);
        Set<ProtocolHandle> set = this.connectedClients.keySet();
        for (ProtocolHandle protocolHandle : set) {
            Collection<ProtocolEngine> collection = this.connectedClients.get(protocolHandle);
            for (ProtocolEngine protocolEngine : collection) {
                if (protocolEngine.isConnected()) continue;
                protocolEngine.dispose();
                collection.remove(protocolEngine);
            }
        }
    }

    public boolean isListeningToPort(ProtocolHandle protocolHandle) {
        boolean bl = false;
        ServerSocketChannel serverSocketChannel = this.openedSocketChannels.get(protocolHandle);
        if (serverSocketChannel != null) {
            bl = serverSocketChannel.socket().isBound() && !serverSocketChannel.isOpen();
        }
        return bl;
    }

    private class ServerDeamon
    implements Runnable {
        private ProtocolHandle handle;
        private ServerSocketChannel channel;
        private ServerProtocolEngineFactory factory;

        public ServerDeamon(ProtocolHandle protocolHandle, ServerSocketChannel serverSocketChannel, ServerProtocolEngineFactory serverProtocolEngineFactory) {
            BasePlugin.logDebugMessage((String)Messages.ServerModel_15, (String)(String.valueOf(Messages.ServerModel_16) + serverSocketChannel.socket().getLocalPort()));
            this.handle = protocolHandle;
            this.channel = serverSocketChannel;
            this.factory = serverProtocolEngineFactory;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block16: {
                BasePlugin.logDebugMessage((String)Messages.ServerModel_17, (String)Messages.ServerModel_18);
                if (this.channel == null) {
                }
                if (this.factory == null) {
                }
                break block16;
                finally {
                    BasePlugin.logDebugMessage((String)Messages.ServerModel_26, (String)Messages.ServerModel_27);
                    try {
                        if (this.channel.isOpen()) {
                            this.channel.close();
                        }
                        BasePlugin.logDebugMessage((String)Messages.ServerModel_28, (String)Messages.ServerModel_29);
                        Collection collection = (Collection)ServerModel.this.connectedClients.get(this.handle);
                        Iterator iterator = collection.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                ServerModel.this.openedSocketChannels.remove(this.handle);
                                ServerModel.this.engineFactories.remove(this.handle);
                                ServerModel.this.connectedClients.remove(this.handle);
                                BasePlugin.logInfo((String)Messages.ServerModel_30);
                                return;
                            }
                            ProtocolEngine protocolEngine = (ProtocolEngine)iterator.next();
                            protocolEngine.requestStop();
                            collection.remove(protocolEngine);
                            protocolEngine.dispose();
                        }
                    }
                    catch (IOException iOException) {
                        IProtocolExceptionHandler iProtocolExceptionHandler = this.factory.getExceptionHandler();
                        if (iProtocolExceptionHandler == null) return;
                        iProtocolExceptionHandler.handleIOException(this.handle, iOException);
                    }
                }
            }
            while (true) {
                SocketChannel socketChannel;
                try {
                    BasePlugin.logDebugMessage((String)Messages.ServerModel_19, (String)Messages.ServerModel_20);
                    socketChannel = this.channel.accept();
                }
                catch (IOException iOException) {
                }
                BasePlugin.logInfo((String)(String.valueOf(Messages.ServerModel_21) + this.channel.socket().getLocalPort()));
                BasePlugin.logDebugMessage((String)Messages.ServerModel_22, (String)Messages.ServerModel_23);
                ProtocolEngine protocolEngine = this.factory.getServerProtocolEngine();
                protocolEngine.requestStart(socketChannel, null);
                BasePlugin.logDebugMessage((String)Messages.ServerModel_24, (String)Messages.ServerModel_25);
                HashSet<ProtocolEngine> hashSet = (HashSet<ProtocolEngine>)ServerModel.this.connectedClients.get(this.handle);
                if (hashSet == null) {
                    hashSet = new HashSet<ProtocolEngine>();
                    ServerModel.this.connectedClients.put(this.handle, hashSet);
                }
                hashSet.add(protocolEngine);
            }
        }
    }
}

