/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.stringeditor.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.sequoyah.localization.stringeditor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.sequoyah.localization.stringeditor.i18n.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class StringEditorColumnLabelProvider
extends ColumnLabelProvider {
    private final String column;
    private final StringEditorPart editor;
    private final Color searchColor = new Color((Device)Display.getDefault(), 255, 200, 200);

    public StringEditorColumnLabelProvider(String string, StringEditorPart stringEditorPart) {
        this.column = string;
        this.editor = stringEditorPart;
    }

    public String getText(Object object) {
        if (this.column.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            return super.getText((Object)((RowInfo)object).getKey());
        }
        return super.getText((Object)((RowInfo)object).getCells().get(this.column));
    }

    public String getToolTipText(Object object) {
        CellInfo cellInfo;
        String string = null;
        RowInfo rowInfo = (RowInfo)object;
        if (this.column.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            if (!rowInfo.getStatus().isOK()) {
                StringBuilder stringBuilder = new StringBuilder();
                IStatus[] iStatusArray = rowInfo.getStatus().getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus iStatus = iStatusArray[n2];
                    stringBuilder.append(iStatus.getMessage());
                    stringBuilder.append(Messages.StringEditorColumnLabelProvider_0);
                    ++n2;
                }
                string = stringBuilder.toString();
            }
        } else if (this.editor.getShowCellComments() && (cellInfo = rowInfo.getCells().get(this.column)) != null && cellInfo.getValue() != null && cellInfo.getValue().trim().length() > 0) {
            string = cellInfo.getComment() != null ? cellInfo.getComment() : "";
        }
        return string;
    }

    public Color getBackground(Object object) {
        Color color = null;
        if (this.column.equals(Messages.StringEditorPart_KeyLabel)) {
            color = Display.getDefault().getSystemColor(19);
        } else {
            CellInfo cellInfo = ((RowInfo)object).getCells().get(this.column);
            String string = this.editor.getSearchText();
            if (cellInfo != null) {
                if (string.length() > 0 && cellInfo.toString().toLowerCase().contains(string.toLowerCase())) {
                    color = this.searchColor;
                } else if (this.editor.getHighlightChanges() && cellInfo.isDirty()) {
                    color = Display.getDefault().getSystemColor(29);
                }
            }
        }
        return color;
    }

    public Image getImage(Object object) {
        Image image = null;
        if (this.column.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            RowInfo rowInfo = (RowInfo)object;
            switch (rowInfo.getStatus().getSeverity()) {
                case 4: {
                    image = this.editor.getErrorImage();
                    break;
                }
                case 2: {
                    image = this.editor.getWarningImage();
                    break;
                }
                default: {
                    image = this.editor.getOKImage();
                }
            }
        }
        return image;
    }
}

