/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.core.action;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.sequoyah.pulsar.core.Activator;
import org.eclipse.sequoyah.pulsar.internal.core.Messages;
import org.eclipse.sequoyah.pulsar.internal.core.action.execution.ExecutionFactory;
import org.eclipse.sequoyah.pulsar.internal.core.action.execution.ExecutionHandler;

public class ExecuteAction
extends ProvisioningAction {
    public static final String ACTION_EXECUTE = "execute";
    private static final String PARM_EXECUTABLE = "executable";

    public IStatus execute(Map map) {
        String string = (String)map.get(PARM_EXECUTABLE);
        if (string == null) {
            return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_ParamNotSetError, PARM_EXECUTABLE, ACTION_EXECUTE), null);
        }
        IInstallableUnit cfr_ignored_0 = (IInstallableUnit)map.get("iu");
        try {
            ExecutionHandler executionHandler = ExecutionFactory.getExecutionHandler(System.getProperty("os.name"), string);
            IStatus iStatus = executionHandler.handleExecution();
            if (!iStatus.isOK()) {
                return iStatus;
            }
        }
        catch (Exception exception) {
            return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_ExecuteError, string), exception);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map map) {
        return Activator.makeErrorStatus(Messages.ExecuteAction_UndoUnsupportedError, null);
    }
}

