/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.core;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.pulsar.core.Activator;
import org.eclipse.sequoyah.pulsar.internal.core.P2Utils;
import org.eclipse.sequoyah.pulsar.internal.core.SDK;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IInstallationInfo;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDK;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDKRepository;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKRepository
implements ISDKRepository {
    private URI metadataUri;
    private URI artifactsUri;
    private String name;
    private ImageDescriptor imageDescriptor;
    private IInstallationInfo installationInfo;

    public SDKRepository(String string, URI uRI, URI uRI2) {
        this.name = string;
        this.metadataUri = uRI;
        this.artifactsUri = uRI2;
    }

    @Override
    public Collection<ISDK> getSDKs(IProgressMonitor iProgressMonitor) {
        ArrayList<ISDK> arrayList = new ArrayList<ISDK>();
        BundleContext bundleContext = Activator.getContext();
        IProvisioningAgent iProvisioningAgent = P2Utils.getProvisioningAgent(bundleContext);
        IMetadataRepositoryManager iMetadataRepositoryManager = (IMetadataRepositoryManager)iProvisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository iMetadataRepository = null;
        IQueryResult iQueryResult = null;
        try {
            iMetadataRepository = iMetadataRepositoryManager.loadRepository(this.getMetadataURI(), (IProgressMonitor)new NullProgressMonitor());
            IInstallableUnit iInstallableUnit = this.getSDKQuery();
            iQueryResult = iMetadataRepository.query(iInstallableUnit, iProgressMonitor);
        }
        catch (ProvisionException provisionException) {
        }
        catch (OperationCanceledException operationCanceledException) {}
        if (iQueryResult != null) {
            for (IInstallableUnit iInstallableUnit : iQueryResult.toUnmodifiableSet()) {
                arrayList.add(new SDK(this, iInstallableUnit));
            }
        }
        return arrayList;
    }

    private IQuery<IInstallableUnit> getSDKQuery() {
        return QueryUtil.createMatchQuery(IInstallableUnit.class, (IExpression)ExpressionUtil.parse((String)"properties[$0] != $1"), (Object[])new Object[]{"org.eclipse.pulsar.type", null});
    }

    @Override
    public URI getMetadataURI() {
        return this.metadataUri;
    }

    @Override
    public URI getArtifactsURI() {
        return this.artifactsUri;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImageDescriptor getIconImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setImageDescriptorURL(URL uRL) {
        this.imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
    }

    public void setInstallationInfo(IInstallationInfo iInstallationInfo) {
        this.installationInfo = iInstallationInfo;
    }

    @Override
    public IInstallationInfo getInstallationInfo() {
        return this.installationInfo;
    }
}

