/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.sequoyah.pulsar.internal.ui.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UninstallDialog
extends TitleAreaDialog {
    private Object[] catalog;
    private Table table;
    private Set<CatalogItem> selectedItems;
    private Button okButton;
    private Button cancelButton;

    public UninstallDialog(Shell shell, Object[] objectArray) {
        super(shell);
        this.catalog = objectArray;
    }

    public Set<CatalogItem> getSelected() {
        return this.selectedItems;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(400, 300);
    }

    protected Control createDialogArea(Composite composite) {
        composite.getShell().setText(Messages.UninstallDialog_2);
        this.selectedItems = new HashSet<CatalogItem>();
        this.setMessage(Messages.UninstallDialog_3);
        this.setTitle(Messages.UninstallDialog_4);
        this.setHelpAvailable(false);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 512);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setLayout((Layout)new FillLayout());
        this.table = new Table((Composite)scrolledComposite, 133154);
        Object[] objectArray = this.catalog;
        int n = this.catalog.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            CatalogItem catalogItem = (CatalogItem)object;
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(catalogItem.getName());
            tableItem.setData((Object)catalogItem);
            DiscoveryResources discoveryResources = new DiscoveryResources(composite.getDisplay());
            if (catalogItem.getIcon() != null) {
                Image image = discoveryResources.getIconImage(catalogItem.getSource(), catalogItem.getIcon(), 32, true);
                tableItem.setImage(image);
            }
            ++n2;
        }
        this.table.layout(true);
        this.table.pack(true);
        scrolledComposite.setContent((Control)this.table);
        scrolledComposite.setExpandHorizontal(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail != 32) {
                    UninstallDialog.this.table.deselect(UninstallDialog.this.table.indexOf((TableItem)selectionEvent.item));
                    boolean bl = ((TableItem)selectionEvent.item).getChecked();
                    ((TableItem)selectionEvent.item).setChecked(!bl);
                }
                if (UninstallDialog.this.selectedItems.contains(((TableItem)selectionEvent.item).getData())) {
                    UninstallDialog.this.selectedItems.remove((CatalogItem)((TableItem)selectionEvent.item).getData());
                } else {
                    UninstallDialog.this.selectedItems.add((CatalogItem)((TableItem)selectionEvent.item).getData());
                }
                UninstallDialog.this.validate();
            }
        });
        composite.setSize(400, 300);
        scrolledComposite.layout();
        return scrolledComposite;
    }

    private void validate() {
        if (this.selectedItems.isEmpty()) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, Messages.UninstallDialog_5, true);
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UninstallDialog.this.setReturnCode(0);
                UninstallDialog.this.close();
            }
        });
        this.cancelButton = this.createButton(composite, 1, Messages.UninstallDialog_6, false);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UninstallDialog.this.setReturnCode(1);
                UninstallDialog.this.close();
            }
        });
    }
}

