/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.ui.view;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.core.DefaultAgentProvider;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.discovery.compatibility.BundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.compatibility.RemoteBundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryUi;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.sequoyah.pulsar.Activator;
import org.eclipse.sequoyah.pulsar.internal.ui.UninstallDialog;
import org.eclipse.sequoyah.pulsar.internal.ui.view.Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKInstallView
extends ViewPart {
    private CatalogViewer viewer;
    private InstallAction installAction;
    private RefreshAction refreshAction;
    private DetailsAction detailsAction;
    private UninstallAction uninstallAction;

    private static IProfile getProfile(String string) {
        IProfileRegistry iProfileRegistry = SDKInstallView.getProfileRegistry();
        return iProfileRegistry.getProfile(string);
    }

    public static IProfileRegistry getProfileRegistry() {
        BundleContext bundleContext = Activator.getContext();
        IProvisioningAgent iProvisioningAgent = SDKInstallView.getProvisioningAgent(bundleContext);
        IProfileRegistry iProfileRegistry = (IProfileRegistry)iProvisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        return iProfileRegistry;
    }

    private static IProvisioningAgent getProvisioningAgent(BundleContext bundleContext) {
        DefaultAgentProvider defaultAgentProvider = new DefaultAgentProvider();
        defaultAgentProvider.activate(bundleContext);
        IProvisioningAgent iProvisioningAgent = defaultAgentProvider.createAgent(null);
        return iProvisioningAgent;
    }

    private ImageDescriptor getLocalImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = null;
        URL uRL = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(string), null);
        if (uRL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        }
        return imageDescriptor;
    }

    public void createPartControl(Composite composite) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.viewer = new CatalogViewer(this.getCatalog(), (IShellProvider)this.getSite(), (IRunnableContext)this.getSite().getWorkbenchWindow(), this.getConfiguration());
        this.viewer.createControl(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        this.refreshSDKs();
        this.makeActions();
        this.contributeToActionBars();
    }

    private CatalogConfiguration getConfiguration() {
        CatalogConfiguration catalogConfiguration = new CatalogConfiguration();
        catalogConfiguration.setShowTagFilter(false);
        return catalogConfiguration;
    }

    private Catalog getCatalog() {
        Catalog catalog = new Catalog();
        catalog.setEnvironment(DiscoveryCore.createEnvironment());
        catalog.setVerifyUpdateSiteAvailability(false);
        catalog.getDiscoveryStrategies().add(new BundleDiscoveryStrategy());
        RemoteBundleDiscoveryStrategy remoteBundleDiscoveryStrategy = new RemoteBundleDiscoveryStrategy();
        remoteBundleDiscoveryStrategy.setDirectoryUrl("http://download.eclipse.org/sequoyah/pulsar/discovery.xml");
        catalog.getDiscoveryStrategies().add(remoteBundleDiscoveryStrategy);
        return catalog;
    }

    private Set<CatalogItem> getInstalledItems(Catalog catalog) {
        HashSet<CatalogItem> hashSet = new HashSet<CatalogItem>();
        Object[] objectArray = catalog.getItems().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof CatalogItem && ((CatalogItem)object).isInstalled()) {
                hashSet.add((CatalogItem)object);
            }
            ++n2;
        }
        return hashSet;
    }

    protected void refreshSDKs() {
        Job job = new Job(Messages.SDKInstallView_UpdatingInstallersJobTitle){

            public IStatus run(IProgressMonitor iProgressMonitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SDKInstallView.this.viewer.updateCatalog();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.installAction);
        iMenuManager.add((IAction)this.detailsAction);
        iMenuManager.add((IAction)this.uninstallAction);
        iMenuManager.add((IAction)this.refreshAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.installAction);
        iToolBarManager.add((IAction)this.detailsAction);
        iToolBarManager.add((IAction)this.uninstallAction);
        iToolBarManager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.installAction = new InstallAction();
        this.installAction.selectionChanged(this.viewer.getSelection());
        this.detailsAction = new DetailsAction();
        this.uninstallAction = new UninstallAction();
        this.refreshAction = new RefreshAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.installAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.detailsAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.uninstallAction);
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.installAction);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.detailsAction);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.uninstallAction);
        super.dispose();
    }

    public void setFocus() {
    }

    private class DetailsAction
    extends BaseSelectionListenerAction {
        protected DetailsAction() {
            super(Messages.SDKInstallView_DetailsActionLabel);
            this.setToolTipText(Messages.SDKInstallView_DetailsActionToolTip);
            this.setImageDescriptor(SDKInstallView.this.getLocalImageDescriptor("icons/details_enabled.gif"));
            this.setDisabledImageDescriptor(SDKInstallView.this.getLocalImageDescriptor("icons/details_disabled.gif"));
        }

        protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
            return iStructuredSelection != null && !iStructuredSelection.isEmpty();
        }

        public void run() {
            PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)SDKInstallView.this.viewer.getControl().getShell(), (String)"org.eclipse.sequoyah.ui.preferences.deviceManagementPreferencePage", (String[])new String[]{"org.eclipse.sequoyah.ui.preferences.deviceManagementPreferencePage"}, null);
            preferenceDialog.open();
        }
    }

    private class InstallAction
    extends BaseSelectionListenerAction {
        protected InstallAction() {
            super(Messages.SDKInstallView_InstallActionLabel);
            this.setToolTipText(Messages.SDKInstallView_InstallActionToolTip);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        }

        protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
            return iStructuredSelection != null && !iStructuredSelection.isEmpty();
        }

        public void run() {
            DiscoveryUi.install((List)SDKInstallView.this.viewer.getCheckedItems(), (IRunnableContext)new ProgressMonitorDialog(SDKInstallView.this.getSite().getShell()));
        }
    }

    private class RefreshAction
    extends Action {
        protected RefreshAction() {
            super(Messages.SDKInstallView_RefreshActionLabel);
            this.setToolTipText(Messages.SDKInstallView_RefreshActionToolTip);
            this.setImageDescriptor(SDKInstallView.this.getLocalImageDescriptor("icons/refresh_enabled.gif"));
            this.setDisabledImageDescriptor(SDKInstallView.this.getLocalImageDescriptor("icons/refresh_disabled.gif"));
        }

        public void run() {
            SDKInstallView.this.refreshSDKs();
        }
    }

    private class UninstallAction
    extends BaseSelectionListenerAction {
        protected UninstallAction() {
            super(Messages.SDKInstallView_UninstallActionLabel);
            this.setToolTipText(Messages.SDKInstallView_UninstallActionToolTip);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        }

        protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
            return !SDKInstallView.this.getInstalledItems(SDKInstallView.this.viewer.getCatalog()).isEmpty();
        }

        public void run() {
            Set set = SDKInstallView.this.getInstalledItems(SDKInstallView.this.viewer.getCatalog());
            if (set.isEmpty()) {
                return;
            }
            Object[] objectArray = set.toArray();
            UninstallDialog uninstallDialog = new UninstallDialog(new Shell(), objectArray);
            int n = uninstallDialog.open();
            if (n == 0) {
                Object object;
                Object[] objectArray2 = uninstallDialog.getSelected().toArray();
                ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
                LoadMetadataRepositoryJob loadMetadataRepositoryJob = new LoadMetadataRepositoryJob(provisioningUI);
                IProfile iProfile = SDKInstallView.getProfile(provisioningUI.getProfileId());
                HashSet<IQuery> hashSet = new HashSet<IQuery>();
                Object[] objectArray3 = objectArray2;
                int n2 = objectArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    object = objectArray3[n3];
                    CatalogItem catalogItem = (CatalogItem)object;
                    IQuery iQuery = QueryUtil.createIUQuery((String)catalogItem.getId());
                    hashSet.add(iQuery);
                    ++n3;
                }
                object = QueryUtil.createCompoundQuery(hashSet, (boolean)false);
                IQueryResult iQueryResult = iProfile.query(object, (IProgressMonitor)new NullProgressMonitor());
                UninstallOperation uninstallOperation = provisioningUI.getUninstallOperation((Collection)iQueryResult.toSet(), null);
                uninstallOperation.resolveModal((IProgressMonitor)new NullProgressMonitor());
                provisioningUI.openUninstallWizard((Collection)iQueryResult.toSet(), uninstallOperation, loadMetadataRepositoryJob);
            }
        }
    }
}

