/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.android.cdt.build.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.android.cdt.build.core.INDKService;
import org.eclipse.sequoyah.android.cdt.internal.build.core.CorePlugin;
import org.eclipse.sequoyah.android.cdt.internal.build.core.TemplatedInputStream;

public class NDKUtils {
    public static final String DEFAULT_JNI_FOLDER_NAME = "jni";
    public static final String MAKEFILE_FILE_NAME = "Android.mk";
    private static final String MAKEFILE_SOURCE_FILES_VARIABLE = "LOCAL_SRC_FILES :=";
    private static final String MAKEFILE_SOURCE_FILES_SEPARATOR = " ";
    private static final String MAKEFINE_NEW_LINE = "\n";

    public static void setNDKLocation(String string) {
        INDKService iNDKService = CorePlugin.getService(INDKService.class);
        iNDKService.setNDKLocation(string);
    }

    public static void generateAndroidMakeFile(final IProject iProject, final String string) {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IFolder iFolder = iProject.getFolder(NDKUtils.DEFAULT_JNI_FOLDER_NAME);
                if (!iFolder.exists()) {
                    iFolder.create(true, true, iProgressMonitor);
                }
                InputStream inputStream = null;
                InputStream inputStream2 = null;
                try {
                    try {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("lib", string);
                        URL uRL = CorePlugin.getFile((IPath)new Path("templates/Android.mk"));
                        inputStream = uRL.openStream();
                        inputStream2 = new TemplatedInputStream(inputStream, hashMap);
                        IFile iFile = iFolder.getFile(NDKUtils.MAKEFILE_FILE_NAME);
                        if (iFile.exists()) {
                            FileOutputStream fileOutputStream = new FileOutputStream(iFile.getLocation().toFile(), false);
                            fileOutputStream.close();
                            iFile.appendContents(inputStream2, true, false, iProgressMonitor);
                        } else {
                            iFile.create(inputStream2, true, iProgressMonitor);
                        }
                        iFile.getParent().refreshLocal(1, iProgressMonitor);
                    }
                    catch (IOException iOException) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.sequoyah.android.cdt.build.core", iOException.getLocalizedMessage(), (Throwable)iOException));
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        try {
            iWorkspace.run(iWorkspaceRunnable, null, 1, null);
        }
        catch (CoreException coreException) {
            CorePlugin.getDefault().getLog().log(coreException.getStatus());
        }
    }

    public static void addSourceFileToMakefile(IResource iResource, String string) throws IOException {
        String string2;
        IPath iPath = iResource.getLocation();
        File file = iPath.toFile();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith(MAKEFILE_SOURCE_FILES_VARIABLE)) {
                    string2 = string2.concat(MAKEFILE_SOURCE_FILES_SEPARATOR + string);
                }
                stringBuilder.append(String.valueOf(string2) + MAKEFINE_NEW_LINE);
            }
        }
        catch (Throwable throwable) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {}
        try {
            string2 = stringBuilder.toString();
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string2);
        }
        catch (Throwable throwable) {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {}
    }
}

