/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.android.cdt.internal.build.ui;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.MessageUtils;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.Messages;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.NDKJavaToCppGenerator;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.UIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class NDKJavaToCppGeneratorHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEditorInput iEditorInput;
        ISelection iSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        IStructuredSelection iStructuredSelection = null;
        boolean bl = false;
        String string = null;
        if (iSelection instanceof IStructuredSelection) {
            iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                if (!(e instanceof ICompilationUnit)) continue;
                ICompilationUnit iCompilationUnit = (ICompilationUnit)e;
                if (!bl) {
                    string = this.openDirectoryChooser(iCompilationUnit.getJavaProject().getProject());
                }
                if (string == null) continue;
                bl = true;
                this.generateJniSourceFiles(string, iCompilationUnit);
            }
        } else if (iSelection instanceof TextSelection && (iEditorInput = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput()) instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            ICompilationUnit iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)iFile);
            if (!bl) {
                string = this.openDirectoryChooser(iCompilationUnit.getJavaProject().getProject());
            }
            if (string != null) {
                bl = true;
                this.generateJniSourceFiles(string, iCompilationUnit);
            }
        }
        return null;
    }

    private String openDirectoryChooser(IProject iProject) {
        IResource iResource;
        String string = null;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        elementTreeSelectionDialog.setTitle(Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_DIRECTORY_SELECTION_TITLE);
        elementTreeSelectionDialog.setMessage(Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_DIRECTORY_SELECTION_TITLE);
        elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        elementTreeSelectionDialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (iProject != null) {
            iResource = iProject.findMember("jni");
            if (iResource != null) {
                elementTreeSelectionDialog.setInitialSelection((Object)iResource);
            } else {
                elementTreeSelectionDialog.setInitialSelection((Object)iProject);
            }
        }
        elementTreeSelectionDialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof IProject) {
                    return true;
                }
                return object2 instanceof IFolder;
            }
        });
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                Status status = new Status(4, "org.eclipse.sequoyah.android.cdt.build.ui", "");
                if (objectArray.length == 1 && objectArray[0] instanceof IFolder) {
                    status = new Status(0, "org.eclipse.sequoyah.android.cdt.build.ui", "");
                }
                return status;
            }
        });
        if (elementTreeSelectionDialog.open() == 0 && (iResource = (IResource)elementTreeSelectionDialog.getFirstResult()) instanceof IFolder) {
            IFolder iFolder = (IFolder)iResource;
            string = iFolder.getLocation().toOSString();
        }
        return string;
    }

    private void generateJniSourceFiles(final String string, final ICompilationUnit iCompilationUnit) {
        IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
        try {
            iProgressService.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    if (iProgressMonitor == null) {
                        iProgressMonitor = new NullProgressMonitor();
                    }
                    iProgressMonitor.beginTask(Messages.JNI_C_FILES_CREATION_MONITOR_TASK_NAME, 100);
                    if (NDKJavaToCppGenerator.checkJavaSdkExistence()) {
                        if (string != null) {
                            try {
                                int n;
                                IResource iResource = iCompilationUnit.getCorrespondingResource();
                                IProject iProject = iResource.getProject();
                                int n2 = iResource.getName().indexOf(iResource.getFileExtension());
                                String string5 = iResource.getName().substring(0, n2 - 1);
                                String string2 = "";
                                String string3 = iResource.getLocation().toOSString();
                                int n3 = string3.indexOf("src/");
                                if (n3 > 0) {
                                    string2 = string3.substring(n3 + 4, string3.length());
                                }
                                if ((n = iResource.getLocation().toOSString().indexOf("src\\")) > 0) {
                                    string2 = string3.substring(n + 4, string3.length());
                                }
                                string2 = string2.replace(String.valueOf(string5) + ".java", "");
                                string2 = string2.replace(File.separator, ".");
                                String string4 = string != null ? string : iResource.getParent().getLocation().toOSString();
                                iProgressMonitor.worked(10);
                                NDKJavaToCppGenerator nDKJavaToCppGenerator = new NDKJavaToCppGenerator(iProject, string5, string2, string4);
                                nDKJavaToCppGenerator.generateCppSourceAndHeader((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 90));
                            }
                            catch (Exception exception) {
                                String string6 = Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_FILES_ERROR;
                                MessageUtils.showErrorDialog(string6, exception.getLocalizedMessage());
                                UIPlugin.log(string6, exception);
                            }
                        }
                    } else {
                        iProgressMonitor.worked(100);
                        MessageUtils.showErrorDialog(Messages.ERR_JNI_JDK_Not_Found_Dialog_Title, Messages.ERR_JNI_JDK_Not_Found);
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (Exception exception) {}
    }
}

