/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.android.cdt.internal.build.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.sequoyah.android.cdt.build.core.NDKUtils;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.CSourceMethod;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.CSourceModel;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.MessageUtils;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.Messages;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.UIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NDKJavaToCppGenerator {
    private static final String METHOD_BODY = "\n{\n\t//TODO\n\treturn (*env)->$native_method_to_call(env, $params);\n}\n";
    private static final String DECL_METHOD = "#decl_method#";
    private String jdkPath = "";
    private IProject project = null;
    private String classname = "";
    private String classPackage = "";
    private String outputDirectoryFromSource = "";
    private String hFileName = "";
    private String cFileName = "";
    private File destinationDir = null;
    private static Map<String, String> jniTypeToTemplateName = new HashMap<String, String>();
    private static final String BIN_FOLDER_NAME = "bin";

    static {
        jniTypeToTemplateName.put("jboolean", "javaBool");
        jniTypeToTemplateName.put("jbyte", "javaByte");
        jniTypeToTemplateName.put("jchar", "javaChar");
        jniTypeToTemplateName.put("jshort", "javaShort");
        jniTypeToTemplateName.put("jint", "javaInt");
        jniTypeToTemplateName.put("jlong", "javaLong");
        jniTypeToTemplateName.put("jfloat", "javaFloat");
        jniTypeToTemplateName.put("jdouble", "javaDouble");
        jniTypeToTemplateName.put("jstring", "javaString");
        jniTypeToTemplateName.put("jbooleanArray", "javaBoolArray");
        jniTypeToTemplateName.put("jbyteArray", "javaByteArray");
        jniTypeToTemplateName.put("jcharArray", "javaCharArray");
        jniTypeToTemplateName.put("jshortArray", "javaShortArray");
        jniTypeToTemplateName.put("jintArray", "javaIntArray");
        jniTypeToTemplateName.put("jlongArray", "javaLongArray");
        jniTypeToTemplateName.put("jfloatArray", "javaFloatArray");
        jniTypeToTemplateName.put("jdoubleArray", "javaDoubleArray");
        jniTypeToTemplateName.put("jstringArray", "javaStringArray");
        jniTypeToTemplateName.put("jobject", "javaObject");
    }

    public NDKJavaToCppGenerator(IProject iProject, String string, String string2, String string3) {
        File file = null;
        if (NDKJavaToCppGenerator.checkJavaSdkExistence()) {
            file = NDKJavaToCppGenerator.retrieveJavaSdk();
        } else {
            this.messageWhenJavaSdkNotFound();
        }
        if (file != null) {
            this.jdkPath = file.getAbsolutePath();
        }
        this.project = iProject;
        this.classname = string;
        this.classPackage = string2;
        this.outputDirectoryFromSource = string3;
        String string4 = String.valueOf(this.classPackage.replace(".", "_")) + this.classname;
        this.hFileName = String.valueOf(string4) + ".h";
        this.cFileName = String.valueOf(string4) + ".c";
        this.destinationDir = new File(this.outputDirectoryFromSource);
    }

    private void messageWhenJavaSdkNotFound() {
        UIPlugin.log(4, "Java SDK not found. It is required to run application to generate C source and header based on Java class");
    }

    public void generateCppSourceAndHeader(IProgressMonitor iProgressMonitor) {
        try {
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            iProgressMonitor.beginTask(Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_TASK_NAME, 90);
            iProgressMonitor.setTaskName(Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_STEP0);
            this.generateHeader();
            iProgressMonitor.worked(40);
            iProgressMonitor.setTaskName(Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_STEP1);
            this.generateSource();
            iProgressMonitor.worked(40);
            iProgressMonitor.setTaskName(Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_STEP2);
            this.project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
        }
        catch (Exception exception) {
            String string = Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_FILES_ERROR;
            String string2 = exception.getLocalizedMessage();
            if (string2 == null || string2.equals("")) {
                string2 = Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_FILES_ERROR;
            }
            MessageUtils.showErrorDialog(string, string2);
            UIPlugin.log(string, exception);
        }
        iProgressMonitor.done();
    }

    private void generateHeader() throws IOException {
        String string = null;
        if (Platform.getOS().equals("win32")) {
            string = "\"" + this.jdkPath + File.separator + "javah\"" + " -classpath " + "\".;" + this.project.getLocation().toOSString() + File.separator + BIN_FOLDER_NAME + "\"" + " -verbose " + this.classPackage + this.classname;
        } else if (Platform.getOS().equals("macosx") || Platform.getOS().equals("linux")) {
            string = String.valueOf(this.jdkPath) + File.separator + "javah" + " -classpath " + this.project.getLocation().toOSString() + File.separator + BIN_FOLDER_NAME + " -verbose " + this.classPackage + this.classname;
        }
        UIPlugin.log(1, "Executing cmd:" + string);
        Runtime.getRuntime().exec(string, null, this.destinationDir);
    }

    private void generateSource() throws IOException, InterruptedException, Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        CSourceModel cSourceModel = this.extractDeclarationMethodFromHFile(arrayList);
        File file = new File(this.destinationDir, this.cFileName);
        if (file.exists()) {
            CSourceModel cSourceModel2 = this.readCFileAndExtractModel();
            CSourceModel cSourceModel3 = new CSourceModel();
            cSourceModel3.createModelThroughDiff(cSourceModel, cSourceModel2);
            this.copyAndAppendNewMethodsToSource(cSourceModel3, file);
        } else {
            this.writeSource(arrayList, file);
            IResource iResource = this.project.findMember("jni/Android.mk");
            if (iResource != null) {
                NDKUtils.addSourceFileToMakefile((IResource)iResource, (String)file.getName());
            }
        }
        MessageUtils.showInformationDialog(Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_FILES_SUCCESSFULLY_CREATED, Messages.JNI_SOURCE_HEADER_CREATION_MONITOR_FILES_SUCCESSFULLY_SOURCEHEADER_CREATED_MESSAGE);
    }

    private CSourceModel readCFileAndExtractModel() throws IOException {
        CSourceModel cSourceModel = new CSourceModel();
        File file = new File(this.destinationDir, this.cFileName);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string = bufferedReader.readLine();
            CSourceMethod cSourceMethod = null;
            while (string != null) {
                if (!string.equals("")) {
                    String string2 = "";
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.addAll(jniTypeToTemplateName.keySet());
                    hashSet.add("void");
                    boolean bl = false;
                    String string3 = null;
                    for (String string4 : hashSet) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        string3 = stringTokenizer.nextToken();
                        if (!string3.equals(string4)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        String string4;
                        string2 = string;
                        string4 = bufferedReader.readLine();
                        while (string4 != null && !string4.trim().endsWith("{")) {
                            string2 = String.valueOf(string2) + string4;
                            string4 = bufferedReader.readLine();
                        }
                        if (string4 != null && string4.trim().endsWith("{")) {
                            string2 = String.valueOf(string2) + string4;
                        }
                        cSourceMethod = new CSourceMethod();
                        this.addMethodReturnTypeAndSignature(string2, cSourceMethod);
                        int n = string2.indexOf("(");
                        int n2 = string2.indexOf(")");
                        String string5 = string2.substring(n + 1, n2);
                        StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string6;
                            String string7 = stringTokenizer.nextToken().trim();
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string7);
                            String string8 = string6 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null;
                            if (string6 != null) {
                                cSourceMethod.add(string6);
                                continue;
                            }
                            UIPlugin.log(2, "Method does not have right parameter type: " + string7);
                        }
                        cSourceModel.getMethods().add(cSourceMethod);
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return cSourceModel;
    }

    private void copyAndAppendNewMethodsToSource(CSourceModel cSourceModel, File file) throws IOException, Exception {
        Closeable closeable;
        Object object;
        boolean bl = false;
        File file2 = null;
        try {
            file2 = File.createTempFile(file.getName(), null);
            object = new FileInputStream(file).getChannel();
            closeable = new FileOutputStream(file2).getChannel();
            ((FileChannel)object).transferTo(0L, ((FileChannel)object).size(), (WritableByteChannel)closeable);
            ((AbstractInterruptibleChannel)closeable).close();
            ((AbstractInterruptibleChannel)object).close();
            bl = true;
        }
        catch (Exception exception) {}
        object = "";
        closeable = new BufferedReader(new FileReader(file));
        BufferedWriter bufferedWriter = null;
        try {
            try {
                String string = ((BufferedReader)closeable).readLine();
                while (string != null) {
                    object = String.valueOf(object) + string + "\n";
                    string = ((BufferedReader)closeable).readLine();
                }
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.append((CharSequence)object);
                String string2 = "#returnType# #signature# ( #params# ) \n{\n\t//TODO\n\treturn (*env)->$native_method_to_call(env, $params);\n}\n";
                if (cSourceModel != null && cSourceModel.getMethods() != null) {
                    for (CSourceMethod cSourceMethod : cSourceModel.getMethods()) {
                        String string3 = "";
                        string3 = string2.replace("#returnType#", cSourceMethod.getReturnType());
                        string3 = string3.replace("#signature#", cSourceMethod.getSignature());
                        String string4 = "";
                        int n = 0;
                        int n2 = 0;
                        for (String string5 : cSourceMethod.getParameterTypes()) {
                            String string6 = "";
                            if (n == 0) {
                                string6 = "JNIEnv* env";
                                string4 = String.valueOf(string4) + string6;
                            } else if (n == 1) {
                                string6 = "jobject thiz";
                                string4 = String.valueOf(string4) + ", " + string6;
                            } else {
                                String string7 = jniTypeToTemplateName.get(string5);
                                string4 = String.valueOf(string4) + ", " + string5 + " " + string7 + n2;
                                ++n2;
                            }
                            ++n;
                        }
                        string3 = string3.replace("#params#", string4);
                        bufferedWriter.append(string3);
                    }
                }
                if (file2 != null && file2.exists()) {
                    try {
                        file2.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                if (bl) {
                    this.recoverBackupAfterError(file2, file);
                }
                throw exception;
            }
        }
        finally {
            if (closeable != null) {
                ((BufferedReader)closeable).close();
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    private void recoverBackupAfterError(File file, File file2) {
        if (file != null && file.exists()) {
            try {
                FileChannel fileChannel = new FileInputStream(file).getChannel();
                FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
                fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
                fileChannel2.close();
                fileChannel.close();
                file.delete();
            }
            catch (Exception exception) {}
        }
    }

    private void writeSource(List<String> list, File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        String string = "#decl_method#\n{\n\t//TODO\n\treturn (*env)->$native_method_to_call(env, $params);\n}\n";
        try {
            if (list != null) {
                bufferedWriter.append("#include <string.h>\n");
                bufferedWriter.append("#include <jni.h>\n\n");
                for (String string2 : list) {
                    String string3 = string.replace(DECL_METHOD, string2);
                    bufferedWriter.append(string3);
                }
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    private CSourceModel extractDeclarationMethodFromHFile(List<String> list) throws FileNotFoundException, IOException, InterruptedException {
        CSourceModel cSourceModel = new CSourceModel();
        File file = new File(this.destinationDir, this.hFileName);
        int n = 0;
        while (!file.canRead()) {
            Thread.sleep(300L);
            if (n > 100) break;
            ++n;
        }
        if (n >= 100) {
            throw new FileNotFoundException("Header file was not generated. Check for compilation issues on project.");
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                String string2 = "";
                if (string.trim().toUpperCase().startsWith("JNIEXPORT")) {
                    CSourceMethod cSourceMethod = new CSourceMethod();
                    string2 = string;
                    String string3 = bufferedReader.readLine();
                    while (string3 != null && !string3.trim().endsWith(";")) {
                        string2 = String.valueOf(string2) + string3;
                        string3 = bufferedReader.readLine();
                    }
                    if (string3 != null && string3.trim().endsWith(";")) {
                        string2 = String.valueOf(string2) + string3;
                    }
                    string2 = string2.replace("JNIEXPORT", "");
                    string2 = string2.replace("JNICALL", "");
                    this.addMethodReturnTypeAndSignature(string2, cSourceMethod);
                    cSourceMethod.add("JNIEnv*");
                    string2 = string2.replaceAll("JNIEnv\\s?\\*", "JNIEnv\\* env");
                    cSourceMethod.add("jobject");
                    string2 = string2.replaceFirst("jobject", "jobject thiz");
                    string2 = string2.replace(";", "");
                    int n2 = 0;
                    int n3 = string2.indexOf("(");
                    int n4 = string2.indexOf(")");
                    String string4 = string2.substring(n3 + 1, n4);
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                    String string5 = "";
                    int n5 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken().trim();
                        String string7 = jniTypeToTemplateName.get(string6);
                        if (string7 != null) {
                            cSourceMethod.add(string6);
                            String string8 = String.valueOf(string6) + " " + string7 + n2;
                            ++n2;
                            string5 = String.valueOf(string5) + ", " + string6.replaceFirst(string6, string8);
                        } else {
                            string5 = n5 > 0 ? String.valueOf(string5) + ", " + string6 : String.valueOf(string5) + string6;
                        }
                        ++n5;
                    }
                    string2 = String.valueOf(string2.substring(0, n3 - 1)) + "(" + string5 + ")";
                    list.add(string2);
                    cSourceModel.getMethods().add(cSourceMethod);
                }
                string = bufferedReader.readLine();
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (file.exists()) {
                file.delete();
            }
        }
        return cSourceModel;
    }

    private void addMethodReturnTypeAndSignature(String string, CSourceMethod cSourceMethod) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        if (string3 != null && string2 != null) {
            cSourceMethod.setReturnType(string3);
            cSourceMethod.setSignature(string2);
        } else {
            UIPlugin.log(2, "Method does not have right returnType - signature: " + string);
        }
    }

    public static boolean checkJavaSdkExistence() {
        boolean bl = true;
        File file = null;
        IVMInstall iVMInstall = JavaRuntime.getDefaultVMInstall();
        if (iVMInstall != null) {
            String string = iVMInstall.getInstallLocation().getAbsolutePath();
            if (string != null && !(file = new File(string, ".." + File.separator + BIN_FOLDER_NAME)).exists()) {
                file = new File(string, BIN_FOLDER_NAME);
            }
            if (file != null && file.exists()) {
                String string2 = null;
                if (Platform.getOS().equals("win32")) {
                    string2 = "\"" + file.getAbsolutePath() + File.separator + "javac\"" + " -version";
                } else if (Platform.getOS().equals("macosx") || Platform.getOS().equals("linux")) {
                    string2 = String.valueOf(file.getAbsolutePath()) + File.separator + "javac" + " -version";
                }
                UIPlugin.log(1, "Executing cmd:" + string2);
                try {
                    Runtime.getRuntime().exec(string2);
                }
                catch (IOException iOException) {
                    bl = false;
                    UIPlugin.log("Error while checking for JDK existence.", iOException);
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static File retrieveJavaSdk() {
        String string;
        File file = null;
        IVMInstall iVMInstall = JavaRuntime.getDefaultVMInstall();
        if (iVMInstall != null && (string = iVMInstall.getInstallLocation().getAbsolutePath()) != null && !(file = new File(string, ".." + File.separator + BIN_FOLDER_NAME)).exists()) {
            file = new File(string, BIN_FOLDER_NAME);
        }
        return file;
    }
}

