/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.vncviews.views;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.sequoyah.vnc.protocol.PluginProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.vncviewer.VNCViewerPlugin;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.RemoteDisplayFactory;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.network.VNCProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.vncviewer.vncviews.views.ProtocolIdTranslator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ViewPart;

public class VNCViewerView
extends ViewPart {
    private static final String VIEWER_COULD_NOT_BE_STARTED = "Viewer could not be started: ";
    private static final String SWTDISPLAY = "SWTDisplay";
    private static SWTRemoteDisplay swtDisplay;
    private static boolean running;
    public static ProtocolHandle protocolHandle;
    private static int zoomFactor;
    private static String[] currentConnection;
    private static String currentHost;
    private static String currentPort;

    static {
        running = false;
        zoomFactor = 1;
        currentConnection = new String[]{"", ""};
    }

    public void createPartControl(Composite composite) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2816);
        swtDisplay = (SWTRemoteDisplay)RemoteDisplayFactory.getDisplay((String)SWTDISPLAY, (Composite)scrolledComposite);
        running = true;
        scrolledComposite.setContent((Control)swtDisplay);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        swtDisplay.getCanvas().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                Point point = swtDisplay.getCanvas().getSize();
                scrolledComposite.setMinSize(swtDisplay.getParent().computeSize(point.x, point.y));
            }
        });
        swtDisplay.getCanvas().setSize(0, 0);
        if (protocolHandle != null) {
            try {
                swtDisplay.start(protocolHandle);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setFocus() {
        if (swtDisplay != null) {
            swtDisplay.setFocus();
        }
    }

    public void dispose() {
        running = false;
        if (swtDisplay != null) {
            swtDisplay.dispose();
        }
        super.dispose();
    }

    public static synchronized void start(String string, int n, String string2, String string3, boolean bl) {
        block5: {
            if (running && swtDisplay != null) {
                if (swtDisplay.isActive()) {
                    swtDisplay.stop();
                }
                try {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    String string4 = ProtocolIdTranslator.getProtocolId(string2);
                    hashMap.put("password", string3);
                    hashMap.put("connectionRetries", swtDisplay.getConnectionRetries());
                    hashMap.put("bypassProxy", new Boolean(bl));
                    protocolHandle = PluginProtocolActionDelegate.requestStartProtocolAsClient((String)string4, (IProtocolExceptionHandler)new VNCProtocolExceptionHandler(), (String)string, (int)n, hashMap);
                    while (!PluginProtocolActionDelegate.isProtocolRunning((ProtocolHandle)protocolHandle)) {
                        Thread.sleep(500L);
                    }
                    swtDisplay.start(protocolHandle);
                    currentHost = string;
                    currentPort = Integer.toString(n);
                }
                catch (Exception exception) {
                    VNCViewerPlugin.log(VNCViewerView.class).error((Object)(VIEWER_COULD_NOT_BE_STARTED + exception.getMessage()));
                    Canvas canvas = swtDisplay.getCanvas();
                    if (canvas == null || canvas.isDisposed()) break block5;
                    GC gC = new GC((Drawable)swtDisplay.getCanvas());
                    gC.fillRectangle(0, 0, swtDisplay.getScreenWidth(), swtDisplay.getScreenHeight());
                    gC.dispose();
                }
            }
        }
    }

    public static synchronized void stop() {
        if (running && swtDisplay != null && swtDisplay.isActive()) {
            swtDisplay.getDisplay().syncExec(new Runnable(){

                public void run() {
                    swtDisplay.stop();
                    zoomFactor = 1;
                    swtDisplay.setZoomFactor((double)zoomFactor);
                    swtDisplay.getCanvas().setSize(0, 0);
                }
            });
        }
    }

    public static void zoomIn() {
        double d = 1.0;
        if (!swtDisplay.isActive()) {
            return;
        }
        zoomFactor = zoomFactor == -2 ? 1 : ++zoomFactor;
        d = zoomFactor >= 1 ? (double)zoomFactor : 1.0 / (double)(-zoomFactor);
        swtDisplay.setZoomFactor(d);
        try {
            swtDisplay.updateRequest(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void zoomOut() {
        double d = 1.0;
        if (!swtDisplay.isActive()) {
            return;
        }
        zoomFactor = zoomFactor == 1 ? -2 : --zoomFactor;
        d = zoomFactor >= 1 ? (double)zoomFactor : 1.0 / (double)(-zoomFactor);
        swtDisplay.setZoomFactor(d);
        try {
            swtDisplay.updateRequest(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void stopProtocol() throws IOException {
        if (protocolHandle != null) {
            PluginProtocolActionDelegate.requestStopProtocol((ProtocolHandle)protocolHandle);
        }
    }

    public static SWTRemoteDisplay getSWTRemoteDisplay() {
        return swtDisplay;
    }

    public static String getCurrentHost() {
        return currentHost;
    }

    public static String getCurrentPort() {
        return currentPort;
    }
}

