/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.android.cdt.internal.build.ui;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sequoyah.android.cdt.build.core.INDKService;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.Messages;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.NDKPreferencePage;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.ProjectChooser;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.UIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class AddNativeProjectPage
extends WizardPage {
    private final String ANDROID_NATIVE_PERSPECTIVE_ID = "org.eclipse.sequoyah.android.cdt.build.ui.perspective";
    private String libName = "";
    private Link setNDKLocationLink;
    private ProjectChooser projectChooser;
    private Text location;
    private Text libraryText;
    boolean isNewProjectWizardPage = false;
    private String projectName;
    ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            if (!AddNativeProjectPage.this.isProjectValid()) {
                AddNativeProjectPage.this.setErrorMessage(Messages.AddNativeProjectPage_project_invalid_msg);
            } else if (!AddNativeProjectPage.this.isNDKLocationValid()) {
                AddNativeProjectPage.this.setErrorMessage(Messages.AddNativeProjectPage_ndk_invalid_path_msg);
            } else if (!AddNativeProjectPage.this.isLibraryNameValid()) {
                AddNativeProjectPage.this.setErrorMessage(Messages.AddNativeProjectPage_empty_library_name_msg);
            } else {
                AddNativeProjectPage.this.setErrorMessage(null);
            }
            AddNativeProjectPage.this.getWizard().getContainer().updateButtons();
        }
    };

    public boolean canFlipToNextPage() {
        return false;
    }

    public AddNativeProjectPage(String string, boolean bl) {
        this(bl);
        this.projectName = string;
        this.libName = string;
    }

    public AddNativeProjectPage(boolean bl) {
        super("native_page");
        this.setTitle(Messages.AddNativeProjectPage_native_page_title);
        this.setDescription(Messages.AddNativeProjectPage_native_page_description);
        this.isNewProjectWizardPage = bl;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        if (!this.isNewProjectWizardPage) {
            this.addProjectChooser(composite2);
            this.projectChooser.setText(this.projectName == null ? "" : this.projectName);
        }
        this.addNDKLocation(composite2);
        this.addLibraryName(composite2);
        this.addListeners();
        this.setControl((Control)composite2);
    }

    private void addListeners() {
        if (!this.isNewProjectWizardPage) {
            this.projectChooser.addModifyListener(this.listener);
        }
        this.location.addModifyListener(this.listener);
        this.libraryText.addModifyListener(this.listener);
    }

    private void addProjectChooser(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.AddNativeProjectPage_project_group_text);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 2, true, false));
        this.projectChooser = new ProjectChooser((Composite)group, 4);
    }

    private void addNDKLocation(Composite composite) {
        String string;
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.AddNativeProjectPage_ndk_location_group_text);
        this.location = new Text((Composite)group, 2048);
        this.location.setLayoutData((Object)new GridData(4, 4, true, true));
        this.location.setEditable(false);
        if (!this.isNDKLocationValid()) {
            this.setErrorMessage(Messages.AddNativeProjectPage_ndk_invalid_path_msg);
        }
        if ((string = PlatformUI.getPreferenceStore().getString("org.eclipse.sequoyah.android.cdt.build.ui.ndkpath")) != null) {
            this.location.setText(string);
        }
        this.setNDKLocationLink = new Link((Composite)group, 0);
        GridData gridData = new GridData(131072, 0x1000000, true, false, 1, 1);
        this.setNDKLocationLink.setLayoutData((Object)gridData);
        this.setNDKLocationLink.setText(Messages.AddNativeProjectPage_ndk_preference_link_text);
        this.setNDKLocationLink.setEnabled(true);
        this.setNDKLocationLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
                        PreferenceDialog preferenceDialog = new PreferenceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), preferenceManager);
                        preferenceDialog.setSelectedNode("org.eclipse.sequoyah.android.cdt.build.ui.NDKPreferencePage");
                        preferenceDialog.create();
                        preferenceDialog.setBlockOnOpen(true);
                        preferenceDialog.open();
                        String string = PlatformUI.getPreferenceStore().getString("org.eclipse.sequoyah.android.cdt.build.ui.ndkpath");
                        AddNativeProjectPage.this.location.setText(string);
                        AddNativeProjectPage.this.location.update();
                    }
                });
            }
        });
    }

    public String getNDKLocation() {
        return this.location.getText();
    }

    private void addLibraryName(Composite composite) {
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.AddNativeProjectPage_library_name_group_text);
        this.libraryText = new Text((Composite)group, 2048);
        this.libraryText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.libraryText.setText(this.libName == null ? "" : this.libName);
    }

    public String getLibraryName() {
        return this.libraryText.getText();
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public boolean isPageComplete() {
        boolean bl = false;
        if (this.isNDKLocationValid() && this.isLibraryNameValid() && this.isProjectValid()) {
            bl = true;
        }
        return bl;
    }

    public boolean isProjectValid() {
        String string;
        IStatus iStatus;
        boolean bl = true;
        if (this.projectChooser != null && (iStatus = this.getProjectStatus(string = this.projectChooser.getText())) != null && iStatus.getSeverity() == 4) {
            bl = false;
        }
        return bl;
    }

    private IStatus getProjectStatus(String string) {
        Status status = null;
        if (string == null || string.length() == 0) {
            status = new Status(4, "org.eclipse.sequoyah.android.cdt.build.ui", "");
        } else {
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            if (!iProject.exists()) {
                status = new Status(4, "org.eclipse.sequoyah.android.cdt.build.ui", "");
            }
        }
        return status;
    }

    public boolean isNDKLocationValid() {
        boolean bl = true;
        String string = PlatformUI.getPreferenceStore().getString("org.eclipse.sequoyah.android.cdt.build.ui.ndkpath");
        if (string.length() == 0 || !NDKPreferencePage.validateNDKDirectory(string)) {
            bl = false;
        }
        return bl;
    }

    public boolean isLibraryNameValid() {
        boolean bl = false;
        String string = this.libraryText.getText();
        if (string.trim().length() > 0) {
            bl = true;
        }
        return bl;
    }

    public void initializeLibraryField(String string) {
        this.libraryText.setText(string);
        this.libraryText.update();
    }

    public boolean performFinish(IWorkbenchWindow iWorkbenchWindow, IProject iProject, IProgressMonitor iProgressMonitor) {
        if (iProject == null) {
            iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectChooser.getText());
        }
        boolean bl = true;
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10);
            subMonitor.beginTask(Messages.AddNativeProjectPage__Message_AddingNativeSupport, 10);
            String string = this.getLibraryName();
            subMonitor.worked(2);
            INDKService iNDKService = UIPlugin.getService(INDKService.class);
            subMonitor.worked(1);
            iNDKService.setNDKLocation(this.getNDKLocation());
            subMonitor.worked(6);
            if (string.length() != 0) {
                iNDKService.addNativeSupport(iProject, string);
                if (!iWorkbenchWindow.getActivePage().getPerspective().getId().equals("org.eclipse.sequoyah.android.cdt.build.ui.perspective") && MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.AddNativeProjectPage_ChangePerspectiveDialogTitle, (String)Messages.AddNativeProjectPage_ChangePerspectiveDialogQuestion)) {
                    iWorkbenchWindow.getWorkbench().showPerspective("org.eclipse.sequoyah.android.cdt.build.ui.perspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
            }
            try {
                iProject.setPersistentProperty(INDKService.libName, string);
                IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
                IConfiguration[] iConfigurationArray = iManagedBuildInfo.getManagedProject().getConfigurations();
                if (Platform.getOS().equals("win32")) {
                    iConfigurationArray[0].setBuildCommand("bash");
                    iConfigurationArray[0].setBuildArguments(String.valueOf(this.getNDKLocation()) + "\\ndk-build");
                }
                subMonitor.worked(1);
            }
            catch (CoreException coreException) {
                UIPlugin.getDefault().getLog().log(coreException.getStatus());
                bl = false;
            }
        }
        catch (WorkbenchException workbenchException) {
            UIPlugin.getDefault().getLog().log(workbenchException.getStatus());
            bl = false;
        }
        return bl;
    }
}

