/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.android.cdt.internal.build.ui;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.sequoyah.android.cdt.build.core.NDKUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class NDKPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String AndroidNDKr4ValidationPathLinuxMac = "/build/prebuilt";
    private static final String AndroidNDKr4ValidationPathWin32 = "\\build\\prebuilt";
    private static final String AndroidNDKr5ValidationPathLinuxMac = "/toolchains/arm-eabi-4.4.0/prebuilt";
    private static final String AndroidNDKr5ValidationPathWin32 = "\\toolchains\\arm-eabi-4.4.0\\prebuilt";
    private static final String AndroidNDKr6ValidationPathLinuxMac = "/toolchains/arm-linux-androideabi-4.4.3/prebuilt";
    private static final String AndroidNDKr6ValidationPathWin32 = "\\toolchains\\arm-linux-androideabi-4.4.3\\prebuilt";
    private DirectoryFieldEditor directoryEditorNDK;
    private boolean isNDKPathValid = true;
    private NDKPreferencePage preferencePage = this;
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String MAC = "darwin";
    private static final String BIN_DIR = "bin";
    private final String UI_PREFERENCES_NDK_PATH_LABEL = "NDK Location";
    private final String UI_PREFERENCES_NDK_INVALID_PATH_ERROR_MSG = "Invalid path for NDK";
    private static FileFilter winFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().toLowerCase().indexOf(NDKPreferencePage.WINDOWS) > -1;
        }
    };
    private static FileFilter linuxFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().toLowerCase().indexOf(NDKPreferencePage.LINUX) > -1;
        }
    };
    private static FileFilter macFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().toLowerCase().indexOf(NDKPreferencePage.MAC) > -1;
        }
    };
    private static FileFilter armFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().toLowerCase().indexOf("arm-eabi") > -1;
        }
    };
    private static FileFilter binFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().equals(NDKPreferencePage.BIN_DIR);
        }
    };
    private static FileFilter gccFilter = new FileFilter(){

        public boolean accept(File file) {
            boolean bl;
            boolean bl2 = bl = file.getName().toLowerCase().indexOf("gcc") > -1;
            if (Platform.getOS().equals("win32")) {
                bl = bl && file.getName().endsWith(".exe");
            }
            return bl;
        }
    };

    private static String[] getPathPrefix() {
        String[] stringArray = new String[2];
        if (Platform.getOS().equals("win32")) {
            stringArray[0] = AndroidNDKr4ValidationPathWin32;
            stringArray[1] = AndroidNDKr5ValidationPathWin32;
            stringArray[2] = AndroidNDKr6ValidationPathWin32;
        } else {
            stringArray[0] = AndroidNDKr4ValidationPathLinuxMac;
            stringArray[1] = AndroidNDKr5ValidationPathLinuxMac;
            stringArray[2] = AndroidNDKr6ValidationPathLinuxMac;
        }
        return stringArray;
    }

    public NDKPreferencePage() {
        this.setPreferenceStore(PlatformUI.getPreferenceStore());
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 4);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.directoryEditorNDK = new DirectoryFieldEditor("org.eclipse.sequoyah.android.cdt.build.ui.ndkpath", "NDK Location", composite2);
        this.directoryEditorNDK.getTextControl(composite2).addModifyListener((ModifyListener)new NDKListener());
        this.directoryEditorNDK.setStringValue(this.getPreferenceStore().getString("org.eclipse.sequoyah.android.cdt.build.ui.ndkpath"));
        return composite2;
    }

    public static boolean validateNDKDirectory(String string) {
        String[] stringArray;
        boolean bl = false;
        String[] stringArray2 = stringArray = NDKPreferencePage.getPathPrefix();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            File file2;
            String string2 = stringArray2[n2];
            String string3 = String.valueOf(string) + string2;
            if (string3.length() > 0 && (file2 = new File(string3)).exists() && file2.isDirectory() && (file = new File(string3)).exists()) {
                File[] fileArray = null;
                if (Platform.getOS().equals("win32")) {
                    fileArray = file.listFiles(winFilter);
                } else if (Platform.getOS().equals(LINUX)) {
                    fileArray = file.listFiles(linuxFilter);
                } else if (Platform.getOS().equals("macosx")) {
                    fileArray = file.listFiles(macFilter);
                }
                if (fileArray != null && fileArray.length > 0) {
                    bl |= NDKPreferencePage.gccExists(fileArray[0]);
                }
            }
            ++n2;
        }
        return bl;
    }

    private static boolean gccExists(File file) {
        File file2;
        File[] fileArray;
        File file3;
        File[] fileArray2;
        boolean bl = false;
        File[] fileArray3 = file.listFiles(armFilter);
        if (fileArray3.length > 0 && (fileArray2 = (file3 = fileArray3[0]).listFiles(binFilter)).length > 0 && (fileArray = (file2 = fileArray2[0]).listFiles(gccFilter)).length > 0) {
            bl = true;
        }
        return bl;
    }

    protected void performApply() {
        this.getPreferenceStore().setValue("org.eclipse.sequoyah.android.cdt.build.ui.ndkpath", this.directoryEditorNDK.getStringValue());
        NDKUtils.setNDKLocation((String)this.directoryEditorNDK.getStringValue());
    }

    protected void performDefaults() {
        this.getPreferenceStore().setToDefault("org.eclipse.sequoyah.android.cdt.build.ui.ndkpath");
        this.directoryEditorNDK.setStringValue(this.getPreferenceStore().getString("org.eclipse.sequoyah.android.cdt.build.ui.ndkpath"));
        NDKUtils.setNDKLocation((String)this.directoryEditorNDK.getStringValue());
    }

    public boolean performOk() {
        boolean bl = true;
        if (!this.isNDKPathValid) {
            bl = false;
        } else {
            this.getPreferenceStore().setValue("org.eclipse.sequoyah.android.cdt.build.ui.ndkpath", this.directoryEditorNDK.getStringValue());
            NDKUtils.setNDKLocation((String)this.directoryEditorNDK.getStringValue());
            bl = super.performOk();
        }
        return bl;
    }

    public void init(IWorkbench iWorkbench) {
    }

    class NDKListener
    implements ModifyListener {
        NDKListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            String string = NDKPreferencePage.this.directoryEditorNDK.getStringValue().trim();
            NDKPreferencePage.this.isNDKPathValid = NDKPreferencePage.validateNDKDirectory(string);
            if (!NDKPreferencePage.this.isNDKPathValid) {
                NDKPreferencePage.this.preferencePage.setErrorMessage("Invalid path for NDK");
                NDKPreferencePage.this.preferencePage.setValid(false);
            } else {
                NDKPreferencePage.this.preferencePage.setErrorMessage(null);
                NDKPreferencePage.this.preferencePage.setValid(true);
            }
            NDKPreferencePage.this.preferencePage.updateApplyButton();
        }
    }
}

