/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.android.cdt.internal.build.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ProjectChooser
extends Composite {
    private Label lblProject;
    private Text txtProject;
    private Button btnBrowseProject;
    IProject project;

    public IProject getProject() {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        if (iProjectArray != null && iProjectArray.length > 0) {
            IProject[] iProjectArray2 = iProjectArray;
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray2[n2];
                if (iProject.getName().equals(this.txtProject.getText())) {
                    this.project = iProject;
                    break;
                }
                ++n2;
            }
        }
        return this.project;
    }

    public String getText() {
        return this.txtProject != null ? this.txtProject.getText() : "";
    }

    public void setText(String string) {
        if (this.txtProject != null) {
            this.txtProject.setText(string);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.txtProject.addModifyListener(modifyListener);
    }

    public void setTextFieldEnabled(boolean bl) {
        this.txtProject.setEnabled(bl);
    }

    public ProjectChooser(Composite composite, int n) {
        super(composite, n);
        this.setupLayout();
        this.addComponents();
    }

    private void setupLayout() {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 2, true, false));
    }

    private void addComponents() {
        this.lblProject = new Label((Composite)this, 0);
        this.lblProject.setText(Messages.PROJECTCHOOSER_PROJECT_LABEL);
        this.lblProject.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtProject = new Text((Composite)this, 2048);
        this.txtProject.setText("");
        this.txtProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnBrowseProject = new Button((Composite)this, 8);
        this.btnBrowseProject.setText(Messages.PROJECTCHOOSER_BROWSE_BUTTON);
        this.btnBrowseProject.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnBrowseProject.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ProjectChooser.this.project = ProjectChooser.this.openProjectChooser();
                if (ProjectChooser.this.project != null) {
                    ProjectChooser.this.txtProject.setText(ProjectChooser.this.project.getName());
                }
            }
        });
    }

    private IProject openProjectChooser() {
        IResource iResource;
        IProject iProject = null;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        elementTreeSelectionDialog.setTitle(Messages.PROJECTCHOOSER_TITLE);
        elementTreeSelectionDialog.setMessage(Messages.PROJECTCHOOSER_MESSAGE);
        elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        elementTreeSelectionDialog.setComparator((ViewerComparator)new ResourceComparator(1));
        elementTreeSelectionDialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return object2 instanceof IProject;
            }
        });
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                Status status = new Status(4, "org.eclipse.sequoyah.android.cdt.build.ui", "");
                if (objectArray.length == 1 && objectArray[0] instanceof IProject) {
                    status = new Status(0, "org.eclipse.sequoyah.android.cdt.build.ui", "");
                }
                return status;
            }
        });
        if (elementTreeSelectionDialog.open() == 0 && (iResource = (IResource)elementTreeSelectionDialog.getFirstResult()) instanceof IProject) {
            iProject = (IProject)iResource;
        }
        return iProject;
    }
}

