/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.extensions.implementation.generic;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ITranslator;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.ITranslateDialog;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.LanguagesUtil;
import org.eclipse.sequoyah.localization.tools.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.PreferencesManager;
import org.eclipse.sequoyah.localization.tools.managers.TranslatorManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

public class TranslateColumnInputDialog
extends TitleAreaDialog
implements ITranslateDialog {
    private IProject project = null;
    private ILocalizationSchema localizationSchema;
    private String translator;
    private Combo translatorsCombo = null;
    private Label translatorBrandingImage = null;
    private Combo fromCombo = null;
    private String fromLanguage;
    private String selectedColumn = null;
    private String toLanguage;
    private Combo toCombo = null;
    private Button automaticallyAddLangID;
    private PreferenceDialog networkPreferencesDialog;
    private PreferenceManager prefMan;
    private Composite customArea = null;
    private static final String PROXY_PREFERENCE_PAGE_ID = "org.eclipse.ui.net.NetPreferences";
    private Composite mainComposite;
    private final IInputValidator validator;
    private final String inputDescription;
    private final String initialValue;
    private final String dialogTitle;
    private Text inputText;
    private String inputValue;

    public TranslateColumnInputDialog(Shell shell, IProject iProject, String string, String string2, String string3, String string4, IInputValidator iInputValidator) {
        super(shell);
        this.inputDescription = string3;
        this.dialogTitle = string2;
        this.initialValue = string4;
        this.project = iProject;
        this.validator = iInputValidator;
        this.selectedColumn = string;
        this.localizationSchema = LocalizationManager.getInstance().getLocalizationSchema(iProject);
    }

    public String getFromLanguage() {
        return LanguagesUtil.getLanguageID(this.fromLanguage);
    }

    public String getToLanguage() {
        return LanguagesUtil.getLanguageID(this.toLanguage);
    }

    public String getTranslator() {
        return this.translator;
    }

    protected Control createDialogArea(Composite composite) {
        this.mainComposite = (Composite)super.createDialogArea(composite);
        this.mainComposite.setLayout((Layout)new GridLayout());
        Composite composite2 = new Composite(this.mainComposite, 0);
        composite2.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(this.mainComposite, 0);
        label.setText(this.inputDescription);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.inputText = new Text(this.mainComposite, 2052);
        this.inputText.setText(this.initialValue);
        this.inputText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.inputText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TranslateColumnInputDialog.this.inputValue = TranslateColumnInputDialog.this.inputText.getText();
                TranslateColumnInputDialog.this.validate();
            }
        });
        ComboListener comboListener = new ComboListener();
        Group group = new Group(this.mainComposite, 64);
        group.setText(Messages.TranslationDialog_LanguageAreaLabel);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(3, false));
        Label label2 = new Label((Composite)group, 0);
        label2.setText(Messages.Translator_Text);
        this.translatorsCombo = LanguagesUtil.createTranslatorsCombo((Composite)group);
        this.translatorsCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.translatorsCombo.addSelectionListener((SelectionListener)comboListener);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(Messages.TranslationDialog_FromLanguage);
        String string = this.localizationSchema.getISO639LangFromID(this.selectedColumn);
        string = LanguagesUtil.getLanguageName(string) != null ? string : null;
        String string2 = PreferencesManager.getInstance().getProjectPreferencesManager(this.project).getDefaultLanguageForColumn(this.selectedColumn);
        this.fromCombo = LanguagesUtil.createLanguagesCombo((Composite)group, string, string2, this.localizationSchema);
        this.fromCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fromCombo.addSelectionListener((SelectionListener)comboListener);
        LanguagesUtil.createImageStatus((Composite)group, string);
        Label label4 = new Label((Composite)group, 0);
        label4.setText(Messages.TranslationDialog_ToLanguage);
        this.toCombo = LanguagesUtil.createLanguagesCombo((Composite)group, null, null, this.localizationSchema);
        this.toCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.toCombo.addSelectionListener((SelectionListener)comboListener);
        LanguagesUtil.createImageStatus((Composite)group, null);
        new Label((Composite)group, 0);
        this.automaticallyAddLangID = new Button((Composite)group, 32);
        this.automaticallyAddLangID.setText(Messages.TranslateColumnInputDialog_0);
        this.automaticallyAddLangID.setSelection(true);
        this.createNetworkGroup(this.mainComposite);
        Composite composite3 = new Composite(this.mainComposite, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        composite3.setLayoutData((Object)new GridData(131072, 1024, true, false));
        this.translatorBrandingImage = new Label(composite3, 0);
        this.translatorBrandingImage.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.setTitle(this.dialogTitle);
        this.setInitialValues();
        this.createCustomArea(false);
        this.validate();
        return this.mainComposite;
    }

    private void createCustomArea(boolean bl) {
        if (this.customArea != null) {
            this.customArea.dispose();
        }
        if (this.translator != null) {
            ITranslator iTranslator = TranslatorManager.getInstance().getTranslatorByName(this.translator);
            if (this.translator != null) {
                this.customArea = iTranslator.createCustomArea(this.mainComposite, this);
                if (this.customArea != null) {
                    if (bl) {
                        this.mainComposite.getShell().setSize(this.mainComposite.getShell().computeSize(-1, -1));
                    }
                    this.mainComposite.getShell().layout(true, true);
                }
            }
        }
    }

    private void setInitialValues() {
        this.fromLanguage = this.fromCombo.getText();
        this.toLanguage = this.toCombo.getText();
        this.translator = this.translatorsCombo.getText();
        TranslatorManager.getInstance().setTranslatorBranding(this.translator, this.translatorBrandingImage);
    }

    public void validate() {
        String string = null;
        string = this.validator.isValid(this.inputText.getText());
        if (string == null && (this.toLanguage == null || this.fromLanguage == null)) {
            string = Messages.TranslateColumnInputDialog_Error_ToOrFromNotSet;
        }
        if (string == null) {
            string = TranslatorManager.getInstance().getTranslatorByName(this.translator).canTranslate(this.fromLanguage, new String[]{this.toLanguage});
        }
        this.setErrorMessage(string);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(string == null);
        }
    }

    public void create() {
        super.create();
        this.validate();
    }

    private void createNetworkGroup(Composite composite) {
        IPreferenceNode iPreferenceNode3;
        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode iPreferenceNode2 = null;
        for (IPreferenceNode iPreferenceNode3 : preferenceManager.getElements(0)) {
            if (!iPreferenceNode3.getId().equals(PROXY_PREFERENCE_PAGE_ID)) continue;
            iPreferenceNode2 = iPreferenceNode3;
            break;
        }
        this.prefMan = new PreferenceManager();
        if (iPreferenceNode2 != null) {
            this.prefMan.addToRoot(iPreferenceNode2);
        }
        iPreferenceNode3 = new Link(composite, 64);
        iPreferenceNode3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TranslateColumnInputDialog.this.openNetworkPreferencesPage();
            }
        });
        String string = Messages.bind((String)Messages.NetworkLinkText, (Object)Messages.NetworkLinkText, (Object)Messages.NetworkLinkLink);
        iPreferenceNode3.setText(string);
        iPreferenceNode3.update();
        GridData gridData = new GridData(16384, 1024, false, false, 1, 1);
        iPreferenceNode3.setLayoutData((Object)gridData);
    }

    private static void centralizeShell(Shell shell) {
        int n = shell.getSize().x;
        int n2 = shell.getSize().y;
        int n3 = (shell.getDisplay().getClientArea().width - n) / 2;
        int n4 = (shell.getDisplay().getClientArea().height - n2) / 2;
        shell.setLocation(n3, n4);
    }

    private boolean openNetworkPreferencesPage() {
        this.networkPreferencesDialog = new WorkbenchPreferenceDialog(this.getShell(), this.prefMan);
        this.networkPreferencesDialog.create();
        TranslateColumnInputDialog.centralizeShell(this.networkPreferencesDialog.getShell());
        this.networkPreferencesDialog.open();
        return this.networkPreferencesDialog.getReturnCode() == 0;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    public String getValue() {
        return this.inputValue;
    }

    class ComboListener
    implements SelectionListener {
        ComboListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource() == TranslateColumnInputDialog.this.fromCombo) {
                TranslateColumnInputDialog.this.fromLanguage = TranslateColumnInputDialog.this.fromCombo.getText();
                if (!TranslateColumnInputDialog.this.fromLanguage.equals(LanguagesUtil.getComboSeparator())) {
                    PreferencesManager.getInstance().getProjectPreferencesManager(TranslateColumnInputDialog.this.project).setDefaultLanguageForColumn(TranslateColumnInputDialog.this.selectedColumn, LanguagesUtil.getLanguageID(TranslateColumnInputDialog.this.fromLanguage));
                } else {
                    TranslateColumnInputDialog.this.fromLanguage = null;
                }
            } else if (selectionEvent.getSource() == TranslateColumnInputDialog.this.toCombo) {
                TranslateColumnInputDialog.this.toLanguage = TranslateColumnInputDialog.this.toCombo.getText();
                if (!TranslateColumnInputDialog.this.toLanguage.equals(LanguagesUtil.getComboSeparator())) {
                    if (TranslateColumnInputDialog.this.automaticallyAddLangID.getSelection()) {
                        TranslateColumnInputDialog.this.inputText.setText(TranslateColumnInputDialog.this.localizationSchema.getIDforLanguage(LanguagesUtil.getLanguageID(TranslateColumnInputDialog.this.toLanguage)));
                    }
                } else {
                    TranslateColumnInputDialog.this.toLanguage = null;
                }
            } else if (selectionEvent.getSource() == TranslateColumnInputDialog.this.translatorsCombo) {
                TranslateColumnInputDialog.this.translator = TranslateColumnInputDialog.this.translatorsCombo.getText();
                TranslatorManager.getInstance().setTranslatorBranding(TranslateColumnInputDialog.this.translator, TranslateColumnInputDialog.this.translatorBrandingImage);
            }
            TranslateColumnInputDialog.this.createCustomArea(true);
            TranslateColumnInputDialog.this.validate();
        }
    }
}

