/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib.internal.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.vnc.protocol.lib.IRawDataHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.ProtocolEngineUtils;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.ProtocolMsgDefinition;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.FixedSizeDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.IMsgDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.IteratableBlockDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.RawDataBean;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.databeans.VariableSizeDataBean;

class MessageWriter {
    MessageWriter() {
    }

    static final void doSendMessage(OutputStream outputStream, ProtocolMessage protocolMessage, ProtocolEngine protocolEngine) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException, IOException {
        if (protocolEngine.isConnected()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ProtocolMsgDefinition protocolMsgDefinition = protocolEngine.getDefinitionByCode(protocolMessage.getCode());
            if (protocolMsgDefinition != null && ProtocolEngineUtils.isOutgoingMessage(protocolMsgDefinition.getId(), protocolEngine.getIncomingMessages(), protocolEngine.getOutgoingMessages())) {
                boolean bl = protocolMsgDefinition.isMsgCodeSigned();
                int n = protocolMsgDefinition.getMsgCodeSizeInBytes();
                MessageWriter.writeNumberToStream(byteArrayOutputStream, new Long(protocolMessage.getCode()), n, bl, protocolEngine);
                List<IMsgDataBean> list = protocolMsgDefinition.getMessageData();
                for (IMsgDataBean iMsgDataBean : list) {
                    MessageWriter.writeFilterMessageDef(iMsgDataBean, byteArrayOutputStream, protocolMessage, null, -1, protocolEngine);
                }
                try {
                    if (outputStream != null) {
                        byteArrayOutputStream.writeTo(outputStream);
                        outputStream.flush();
                    }
                }
                catch (IOException iOException) {
                    protocolEngine.requestRestart();
                    throw iOException;
                }
            }
        }
    }

    private static void writeFilterMessageDef(IMsgDataBean iMsgDataBean, ByteArrayOutputStream byteArrayOutputStream, ProtocolMessage protocolMessage, String string, int n, ProtocolEngine protocolEngine) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException {
        if (iMsgDataBean instanceof FixedSizeDataBean) {
            MessageWriter.writeFixedSizeDataToStream(byteArrayOutputStream, (FixedSizeDataBean)iMsgDataBean, protocolMessage, string, n, protocolEngine);
        } else if (iMsgDataBean instanceof VariableSizeDataBean) {
            MessageWriter.writeVariableSizeDataToStream(byteArrayOutputStream, (VariableSizeDataBean)iMsgDataBean, protocolMessage, protocolEngine);
        } else if (iMsgDataBean instanceof RawDataBean) {
            MessageWriter.writeRawDataToStream(byteArrayOutputStream, (RawDataBean)iMsgDataBean, protocolMessage, protocolEngine);
        } else {
            MessageWriter.writeIteratableBlockToStream(byteArrayOutputStream, (IteratableBlockDataBean)iMsgDataBean, protocolMessage, protocolEngine);
        }
    }

    private static void writeFixedSizeDataToStream(ByteArrayOutputStream byteArrayOutputStream, FixedSizeDataBean fixedSizeDataBean, ProtocolMessage protocolMessage, String string, int n, ProtocolEngine protocolEngine) throws InvalidMessageException, InvalidDefinitionException {
        String string2 = fixedSizeDataBean.getFieldName();
        boolean bl = fixedSizeDataBean.isFieldSigned();
        int n2 = fixedSizeDataBean.getFieldSizeInBytes();
        Object object = fixedSizeDataBean.getValue();
        if (string2 != null) {
            if (object == null) {
                object = string != null && n >= 0 ? protocolMessage.getFieldValue(string2, string, n) : protocolMessage.getFieldValue(string2);
            }
            if (!(object instanceof Number)) {
                BasePlugin.logError((String)"Value retrieved from message is not a number.");
                throw new InvalidMessageException("Field does not contain a number");
            }
        } else {
            BasePlugin.logError((String)"The field name was not provided by the message definition.");
            throw new InvalidDefinitionException("Incomplete fixed data element");
        }
        MessageWriter.writeNumberToStream(byteArrayOutputStream, (Number)object, n2, bl, protocolEngine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeVariableSizeDataToStream(ByteArrayOutputStream byteArrayOutputStream, VariableSizeDataBean variableSizeDataBean, ProtocolMessage protocolMessage, ProtocolEngine protocolEngine) throws InvalidMessageException, InvalidDefinitionException {
        boolean bl = variableSizeDataBean.isSizeFieldSigned();
        int n = variableSizeDataBean.getSizeFieldSizeInBytes();
        String string = variableSizeDataBean.getValueFieldName();
        String string2 = variableSizeDataBean.getCharsetName();
        Object object = variableSizeDataBean.getValue();
        if (string == null) {
            BasePlugin.logError((String)"The field name was not provided by the message definition.");
            throw new InvalidDefinitionException("Incomplete fixed data element");
        }
        if (object == null) {
            object = protocolMessage.getFieldValue(string);
        }
        if (!(object instanceof String)) {
            BasePlugin.logError((String)"Value retrieved from message is not a string.");
            throw new InvalidMessageException("Value field does not contain a string");
        }
        try {
            byte[] byArray = ((String)object).getBytes(string2);
            int n2 = byArray.length;
            MessageWriter.writeNumberToStream(byteArrayOutputStream, n2, n, bl, protocolEngine);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            BasePlugin.logError((String)"An invalid charset name was provided for the field.");
            throw new InvalidDefinitionException("Invalid charset name provided at message definition", unsupportedEncodingException);
        }
    }

    private static void writeRawDataToStream(ByteArrayOutputStream byteArrayOutputStream, RawDataBean rawDataBean, ProtocolMessage protocolMessage, ProtocolEngine protocolEngine) throws ProtocolRawHandlingException {
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        IRawDataHandler iRawDataHandler = rawDataBean.getHandler();
        iRawDataHandler.writeRawDataToStream(protocolEngine.getHandle(), byteArrayOutputStream2, protocolMessage, protocolEngine.isBigEndianProtocol());
        try {
            byteArrayOutputStream2.writeTo(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            BasePlugin.logWarning((String)"An IOException was thrown by the raw field handler.");
        }
    }

    private static void writeIteratableBlockToStream(ByteArrayOutputStream byteArrayOutputStream, IteratableBlockDataBean iteratableBlockDataBean, ProtocolMessage protocolMessage, ProtocolEngine protocolEngine) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException {
        String string = iteratableBlockDataBean.getIterateOnField();
        String string2 = iteratableBlockDataBean.getId();
        Object object = protocolMessage.getFieldValue(string);
        if (object instanceof Integer) {
            int n = (Integer)object;
            Collection<IMsgDataBean> collection = iteratableBlockDataBean.getDataBeans();
            int n2 = 0;
            while (n2 < n) {
                for (IMsgDataBean iMsgDataBean : collection) {
                    MessageWriter.writeFilterMessageDef(iMsgDataBean, byteArrayOutputStream, protocolMessage, string2, n2, protocolEngine);
                }
                ++n2;
            }
        } else {
            BasePlugin.logError((String)"It was not possible to determine how many iterations are expected.");
            throw new InvalidMessageException("Iterate on field value is not numeric");
        }
    }

    private static void writeNumberToStream(ByteArrayOutputStream byteArrayOutputStream, Number number, int n, boolean bl, ProtocolEngine protocolEngine) {
        int n2;
        byte[] byArray = MessageWriter.getUnsignedBytes(number, n);
        if (bl && number.longValue() < 0L) {
            n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)(byArray[n2] ^ byArray[n2]);
                ++n2;
            }
            byArray[n - 1] = (byte)(byArray[n - 1] + 1);
        }
        if (protocolEngine.isBigEndianProtocol()) {
            n2 = 0;
            while (n2 < n) {
                byteArrayOutputStream.write(byArray[n2]);
                ++n2;
            }
        } else {
            n2 = n - 1;
            while (n2 >= 0) {
                byteArrayOutputStream.write(byArray[n2]);
                --n2;
            }
        }
    }

    private static byte[] getUnsignedBytes(Number number, int n) {
        long l = Math.abs(number.longValue());
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byte by = (byte)(l & 0xFFL);
            l >>= 8;
            byArray[n - n2 - 1] = by;
            ++n2;
        }
        return byArray;
    }
}

