/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.ui.view;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sequoyah.pulsar.Activator;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IInstallationInfoProvider;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDK;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDKCategory;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDKRepository;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.QuickInstallCore;
import org.eclipse.sequoyah.pulsar.internal.ui.view.ISDKInstallItemLabelProvider;
import org.eclipse.sequoyah.pulsar.internal.ui.view.InstallationEnvironmentFilter;
import org.eclipse.sequoyah.pulsar.internal.ui.view.InstallationInfoLabelProvider;
import org.eclipse.sequoyah.pulsar.internal.ui.view.InstallersLabelProvider;
import org.eclipse.sequoyah.pulsar.internal.ui.view.Messages;
import org.eclipse.sequoyah.pulsar.internal.ui.view.P2InstallerUI;
import org.eclipse.sequoyah.pulsar.internal.ui.view.SDKInstallItemViewer;
import org.eclipse.sequoyah.pulsar.internal.ui.view.StatusLabelProvider;
import org.eclipse.sequoyah.pulsar.internal.ui.view.VersionLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKInstallView
extends ViewPart {
    private TreeViewer viewer;
    private InstallAction installAction;
    private RefreshAction refreshAction;
    private DetailsAction detailsAction;
    private UninstallAction uninstallAction;
    private Action doubleClickAction;
    private StructuredViewerProvisioningListener listener;
    private SDKInstallItemViewer itemViewer;

    private ImageDescriptor getLocalImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = null;
        URL uRL = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(string), null);
        if (uRL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        }
        return imageDescriptor;
    }

    public void createPartControl(Composite composite) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.viewer = new TreeViewer(composite, 768);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        Display display = this.getViewSite().getShell().getDisplay();
        treeViewerColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new InstallersLabelProvider((Device)display)));
        treeViewerColumn.getColumn().setText(Messages.SDKInstallView_InstallersColLabel);
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn(this.viewer, 16384);
        treeViewerColumn2.setLabelProvider((CellLabelProvider)new StatusLabelProvider());
        treeViewerColumn2.getColumn().setText(Messages.SDKInstallView_StatusColLabel);
        TreeViewerColumn treeViewerColumn3 = new TreeViewerColumn(this.viewer, 16384);
        treeViewerColumn3.setLabelProvider((CellLabelProvider)new VersionLabelProvider());
        treeViewerColumn3.getColumn().setText(Messages.SDKInstallView_VersionLabel);
        this.viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                return SDKInstallView.this.getTreeNodeDisplayName(object).compareToIgnoreCase(SDKInstallView.this.getTreeNodeDisplayName(object2));
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SDKInstallView.this.installAction.selectionChanged(selectionChangedEvent);
                SDKInstallView.this.detailsAction.selectionChanged(selectionChangedEvent);
                SDKInstallView.this.uninstallAction.selectionChanged(selectionChangedEvent);
                SDKInstallView.this.updateSDKItemViewer();
            }
        });
        this.viewer.addFilter((ViewerFilter)new InstallationEnvironmentFilter());
        this.refreshSDKs();
        this.makeActions();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.addProvisioningListener();
    }

    protected void refreshSDKs() {
        Job job = new Job(Messages.SDKInstallView_UpdatingInstallersJobTitle){

            public IStatus run(IProgressMonitor iProgressMonitor) {
                SDKInstallView.this.refreshSDKRepositories();
                final TreeNode[] treeNodeArray = SDKInstallView.this.createTreeNodes(iProgressMonitor);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SDKInstallView.this.viewer.getTree().removeAll();
                        SDKInstallView.this.viewer.setInput((Object)treeNodeArray);
                        SDKInstallView.this.viewer.expandAll();
                        SDKInstallView.this.packColumns();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void refreshSDKRepositories() {
        P2InstallerUI p2InstallerUI = (P2InstallerUI)P2InstallerUI.getInstance();
        p2InstallerUI.refreshSDKRepositories(QuickInstallCore.getInstance().getSDKRepositories());
    }

    private void updateSDKItemViewer() {
        Composite composite = this.viewer.getTree().getParent();
        if (composite == null) {
            return;
        }
        Object object = this.getSelectedItem();
        if (object != null) {
            ISDKInstallItemLabelProvider iSDKInstallItemLabelProvider;
            if (this.itemViewer == null || this.itemViewer.isDisposed()) {
                this.itemViewer = new SDKInstallItemViewer(composite);
                iSDKInstallItemLabelProvider = new GridData(4, 4, false, true);
                ((GridData)iSDKInstallItemLabelProvider).minimumWidth = 350;
                ((GridData)iSDKInstallItemLabelProvider).widthHint = 350;
                this.itemViewer.setLayoutData(iSDKInstallItemLabelProvider);
            }
            iSDKInstallItemLabelProvider = this.getLabelProvider(object);
            this.itemViewer.setLabelProvider(iSDKInstallItemLabelProvider);
            this.itemViewer.setInput(object);
        } else if (this.itemViewer != null && !this.itemViewer.isDisposed()) {
            this.itemViewer.dispose();
        }
        composite.layout(true);
    }

    private ISDKInstallItemLabelProvider getLabelProvider(Object object) {
        InstallationInfoLabelProvider installationInfoLabelProvider = null;
        if (object instanceof IInstallationInfoProvider) {
            installationInfoLabelProvider = new InstallationInfoLabelProvider();
        }
        return installationInfoLabelProvider;
    }

    private TreeNode[] createTreeNodes(IProgressMonitor iProgressMonitor) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Collection collection = QuickInstallCore.getInstance().getSDKRepositories();
        iProgressMonitor.beginTask("", collection.size());
        iProgressMonitor.subTask(Messages.SDKInstallView_GettingRepoInfoMessage);
        for (ISDKRepository iSDKRepository : collection) {
            arrayList.add(this.createRepositoryTreeNode(iSDKRepository, iProgressMonitor));
        }
        iProgressMonitor.done();
        return arrayList.toArray(new TreeNode[arrayList.size()]);
    }

    private TreeNode createRepositoryTreeNode(ISDKRepository iSDKRepository, IProgressMonitor iProgressMonitor) {
        ISDKCategory iSDKCategory;
        TreeNode treeNode = new TreeNode((Object)iSDKRepository);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Collection collection = iSDKRepository.getSDKs(iProgressMonitor);
        for (ISDK iSDK : collection) {
            iSDKCategory = iSDK.getCategory();
            if (iSDKCategory != null) {
                if (!linkedHashMap.containsKey(iSDKCategory)) {
                    linkedHashMap.put(iSDKCategory, new ArrayList());
                }
                ((Collection)linkedHashMap.get(iSDKCategory)).add(iSDK);
                continue;
            }
            SDKInstallView.addNewTreeNode(arrayList, treeNode, iSDK);
        }
        for (ISDK iSDK : linkedHashMap.keySet()) {
            iSDKCategory = SDKInstallView.addNewTreeNode(arrayList, treeNode, iSDK);
            Collection collection2 = (Collection)linkedHashMap.get(iSDK);
            ArrayList<TreeNode> arrayList2 = new ArrayList<TreeNode>();
            for (ISDK iSDK2 : collection2) {
                SDKInstallView.addNewTreeNode(arrayList2, (TreeNode)iSDKCategory, iSDK2);
            }
            iSDKCategory.setChildren(arrayList2.toArray(new TreeNode[arrayList2.size()]));
        }
        treeNode.setChildren(arrayList.toArray(new TreeNode[arrayList.size()]));
        iProgressMonitor.worked(1);
        return treeNode;
    }

    private static TreeNode addNewTreeNode(Collection<TreeNode> collection, TreeNode treeNode, Object object) {
        TreeNode treeNode2 = new TreeNode(object);
        treeNode2.setParent(treeNode);
        if (collection != null) {
            collection.add(treeNode2);
        }
        return treeNode2;
    }

    private String getTreeNodeDisplayName(Object object) {
        Object object2 = ((TreeNode)object).getValue();
        if (object2 instanceof ISDKCategory) {
            return ((ISDKCategory)object2).getName();
        }
        if (object2 instanceof ISDK) {
            return ((ISDK)object2).getName();
        }
        if (object2 instanceof String) {
            return (String)object2;
        }
        return "";
    }

    private void packColumns() {
        TreeColumn[] treeColumnArray;
        TreeColumn[] treeColumnArray2 = treeColumnArray = this.viewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray2[n2];
            treeColumn.pack();
            ++n2;
        }
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.installAction);
        iMenuManager.add((IAction)this.detailsAction);
        iMenuManager.add((IAction)this.uninstallAction);
        iMenuManager.add((IAction)this.refreshAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.installAction);
        iToolBarManager.add((IAction)this.detailsAction);
        iToolBarManager.add((IAction)this.uninstallAction);
        iToolBarManager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.installAction = new InstallAction();
        this.installAction.setEnabled(this.getSelectedSDK() != null);
        this.detailsAction = new DetailsAction();
        this.detailsAction.setEnabled(this.getSelectedSDK() != null);
        this.uninstallAction = new UninstallAction();
        this.uninstallAction.setEnabled(this.getSelectedSDK() != null);
        this.refreshAction = new RefreshAction();
        this.refreshAction.setEnabled(true);
        this.doubleClickAction = new Action(){

            public void run() {
                SDKInstallView.this.installSelectedSDK();
            }
        };
    }

    private Object getSelectedItem() {
        Object object = null;
        TreeNode treeNode = this.getSelectedNode();
        if (treeNode != null) {
            Object object2 = treeNode.getValue();
            if (object2 instanceof String) {
                TreeNode treeNode2 = this.getRootParentNode(treeNode);
                if (treeNode2.getValue() instanceof ISDKRepository) {
                    object = treeNode2.getValue();
                }
            } else {
                object = treeNode.getValue();
            }
        }
        return object;
    }

    private TreeNode getRootParentNode(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode;
        if (treeNode.getParent() != null) {
            treeNode2 = this.getRootParentNode(treeNode.getParent());
        }
        return treeNode2;
    }

    private ISDK getSelectedSDK() {
        Object object;
        ISDK iSDK = null;
        TreeNode treeNode = this.getSelectedNode();
        if (treeNode != null && (object = treeNode.getValue()) instanceof ISDK) {
            iSDK = (ISDK)object;
        }
        return iSDK;
    }

    private TreeNode getSelectedNode() {
        Object object;
        TreeNode treeNode = null;
        ISelection iSelection = this.viewer.getSelection();
        if (!iSelection.isEmpty() && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof TreeNode) {
            treeNode = (TreeNode)object;
        }
        return treeNode;
    }

    protected void installSelectedSDK() {
        ISDK iSDK = this.getSelectedSDK();
        if (iSDK != null) {
            try {
                QuickInstallCore.getInstance().installSDK(this.getSite().getShell(), iSDK, P2InstallerUI.getInstance());
            }
            catch (CoreException coreException) {
                org.eclipse.sequoyah.pulsar.core.Activator.logError((String)Messages.SDKInstallView_InstallError, (Throwable)coreException);
            }
        }
    }

    protected void uninstallSelectedSDK() {
        ISDK iSDK = this.getSelectedSDK();
        if (iSDK != null) {
            try {
                QuickInstallCore.getInstance().uninstallSDK(this.getSite().getShell(), iSDK, P2InstallerUI.getInstance());
            }
            catch (CoreException coreException) {
                org.eclipse.sequoyah.pulsar.core.Activator.logError((String)Messages.SDKInstallView_UninstallError, (Throwable)coreException);
            }
        }
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                SDKInstallView.this.doubleClickAction.run();
            }
        });
    }

    private void addProvisioningListener() {
        this.listener = new StructuredViewerProvisioningListener((StructuredViewer)this.viewer, 4){

            protected void profileChanged(String string) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SDKInstallView.this.viewer.refresh();
                    }
                });
            }
        };
        ProvUI.addProvisioningListener((ProvUIProvisioningListener)this.listener);
    }

    private void removeProvisioningListener() {
        ProvUI.removeProvisioningListener((ProvUIProvisioningListener)this.listener);
    }

    public void dispose() {
        this.removeProvisioningListener();
        super.dispose();
    }

    public void setFocus() {
    }

    private class DetailsAction
    extends BaseSelectionListenerAction {
        protected DetailsAction() {
            super(Messages.SDKInstallView_DetailsActionLabel);
            this.setToolTipText(Messages.SDKInstallView_DetailsActionToolTip);
            this.setImageDescriptor(SDKInstallView.this.getLocalImageDescriptor("icons/details_enabled.gif"));
            this.setDisabledImageDescriptor(SDKInstallView.this.getLocalImageDescriptor("icons/details_disabled.gif"));
        }

        protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
            boolean bl = false;
            if (SDKInstallView.this.getSelectedSDK() != null) {
                bl = SDKInstallView.this.getSelectedSDK().getState().equals((Object)ISDK.EState.INSTALLED);
            }
            return bl;
        }

        public void run() {
            PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)SDKInstallView.this.viewer.getTree().getShell(), (String)"org.eclipse.sequoyah.ui.preferences.deviceManagementPreferencePage", (String[])new String[]{"org.eclipse.sequoyah.ui.preferences.deviceManagementPreferencePage"}, null);
            preferenceDialog.open();
        }
    }

    private class InstallAction
    extends BaseSelectionListenerAction {
        protected InstallAction() {
            super(Messages.SDKInstallView_InstallActionLabel);
            this.setToolTipText(Messages.SDKInstallView_InstallActionToolTip);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        }

        protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
            boolean bl = false;
            if (SDKInstallView.this.getSelectedSDK() != null) {
                bl = !SDKInstallView.this.getSelectedSDK().getState().equals((Object)ISDK.EState.INSTALLED);
            }
            return bl;
        }

        public void run() {
            SDKInstallView.this.installSelectedSDK();
        }
    }

    private class RefreshAction
    extends BaseSelectionListenerAction {
        protected RefreshAction() {
            super(Messages.SDKInstallView_RefreshActionLabel);
            this.setToolTipText(Messages.SDKInstallView_RefreshActionToolTip);
            this.setImageDescriptor(SDKInstallView.this.getLocalImageDescriptor("icons/refresh_enabled.gif"));
            this.setDisabledImageDescriptor(SDKInstallView.this.getLocalImageDescriptor("icons/refresh_disabled.gif"));
        }

        public void run() {
            SDKInstallView.this.refreshSDKs();
        }
    }

    private class UninstallAction
    extends BaseSelectionListenerAction {
        protected UninstallAction() {
            super(Messages.SDKInstallView_UninstallActionLabel);
            this.setToolTipText(Messages.SDKInstallView_UninstallActionToolTip);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        }

        protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
            boolean bl = false;
            if (SDKInstallView.this.getSelectedSDK() != null) {
                bl = SDKInstallView.this.getSelectedSDK().getState().equals((Object)ISDK.EState.INSTALLED);
            }
            return bl;
        }

        public void run() {
            SDKInstallView.this.uninstallSelectedSDK();
        }
    }
}

