/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.factory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.common.utilities.exception.TmLExceptionHandler;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.exception.DeviceExceptionHandler;
import org.eclipse.tml.framework.device.internal.model.MobileDevice;
import org.eclipse.tml.framework.device.model.IDevice;
import org.eclipse.tml.framework.device.model.handler.IDeviceHandler;
import org.osgi.framework.Bundle;

public class DeviceFactory {
    private static final String ELEMENT_DEVICE = "device";
    private static final String ATR_ID = "id";
    private static final String ATR_NAME = "name";
    private static final String ATR_ICON = "icon";
    private static final String ATR_DESCRIPTION = "description";
    private static final String ATR_PROVIDER = "provider";
    private static final String ATR_COPYRIGHT = "copyright";
    private static final String ATR_VERSION = "version";
    private static final String ATR_HANDLER = "handler";

    public static IDevice createDevice(String deviceId) {
        IExtension fromPlugin = PluginUtils.getExtension((String)"org.eclipse.tml.device", (String)deviceId);
        MobileDevice device = new MobileDevice(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATR_ID));
        device.setName(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATR_NAME));
        String iconName = PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATR_ICON);
        ImageDescriptor image = null;
        try {
            image = DevicePlugin.getPluginImage((Bundle)fromPlugin.getDeclaringPluginDescriptor().getPlugin().getBundle(), (String)iconName);
        }
        catch (Throwable throwable) {
            TmLExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
        }
        device.setImage(image);
        device.setDescription(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATR_DESCRIPTION));
        device.setProvider(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATR_PROVIDER));
        device.setCopyright(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATR_COPYRIGHT));
        device.setVersion(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATR_VERSION));
        device.setDefaultProperties(DevicePlugin.DEFAULT_PROPERTIES);
        try {
            device.setHandler((IDeviceHandler)PluginUtils.getExecutableAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATR_HANDLER));
        }
        catch (CoreException coreException) {
            TmLExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
        }
        return device;
    }
}

