/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.internal.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tml.framework.device.model.IDevice;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.model.handler.IServiceHandler;
import org.eclipse.tml.framework.status.IStatusTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileService
implements IService {
    private String id;
    private String name;
    private ImageDescriptor image;
    private String copyright;
    private String description;
    private String provider;
    private String version;
    private IServiceHandler handler;
    private IDevice parent;
    private Map<String, IStatusTransition> statusMap;
    private boolean visible;

    public MobileService(String id) {
        this.id = id;
        this.statusMap = new HashMap<String, IStatusTransition>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImage() {
        return this.image;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public IServiceHandler getHandler() {
        return this.handler;
    }

    @Override
    public Collection<IStatusTransition> getStatusTransitions() {
        return this.statusMap.values();
    }

    @Override
    public IStatusTransition getStatusTransitions(String startId) {
        return this.statusMap.get(startId);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setImage(ImageDescriptor image) {
        this.image = image;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void setHandler(IServiceHandler handler) {
        this.handler = (IServiceHandler)handler.clone();
        this.handler.setService(this);
    }

    @Override
    public void setStatusTransitions(List<IStatusTransition> statusList) {
        for (IStatusTransition status : statusList) {
            this.statusMap.put(status.getStartId(), status);
        }
    }

    @Override
    public Object clone() {
        MobileService newService = new MobileService(this.id);
        newService.setName(this.name);
        newService.setImage(this.image);
        newService.setCopyright(this.copyright);
        newService.setDescription(this.description);
        newService.setProvider(this.provider);
        newService.setVersion(this.version);
        newService.setHandler(this.handler);
        newService.setParent(this.parent);
        newService.setVisible(this.visible);
        return newService;
    }

    public String toString() {
        return "[Service: id=" + (this.id == null ? "" : this.id) + ",name=" + (this.name == null ? "" : this.name) + ",description=" + (this.description == null ? "" : this.description) + ",version=" + (this.version == null ? "" : this.version) + ",provider=" + (this.provider == null ? "" : this.provider) + ",copyright=" + (this.copyright == null ? "" : this.copyright) + ",handler=" + (this.handler == null ? "" : this.handler.getClass().getName()) + "]";
    }

    @Override
    public IDevice getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IDevice device) {
        this.parent = device;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

