/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.model;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolInit;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolInitException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.tml.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.tml.protocol.lib.internal.model.IModel;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientModel
implements IModel {
    private static ClientModel instance;
    private Map<ProtocolHandle, ProtocolEngine> runningEngines = new HashMap<ProtocolHandle, ProtocolEngine>();

    private ClientModel() {
    }

    public static ClientModel getInstance() {
        if (instance == null) {
            instance = new ClientModel();
        }
        return instance;
    }

    public ProtocolHandle startClientProtocol(Map<Long, ProtocolMsgDefinition> allMessages, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolInit protocolInitializer, IProtocolExceptionHandler exceptionHandler, Boolean isBigEndianProtocol, String host, int port, Map<String, Object> parameters) throws UnknownHostException, IOException, ProtocolInitException {
        Integer retriesObj = (Integer)parameters.get("connectionRetries");
        int retries = retriesObj != null ? retriesObj : -1;
        ProtocolHandle handle = new ProtocolHandle();
        ProtocolEngine eng = new ProtocolEngine(handle, protocolInitializer, allMessages, incomingMessages, outgoingMessages, exceptionHandler, isBigEndianProtocol, false, retries);
        eng.startProtocol(host, port, parameters);
        this.runningEngines.put(handle, eng);
        return handle;
    }

    public void stopClientProtocol(ProtocolHandle handle) throws IOException {
        ProtocolEngine eng = this.runningEngines.get(handle);
        if (eng != null) {
            eng.stopProtocol();
        }
        this.runningEngines.remove(handle);
    }

    public void restartClientProtocol(ProtocolHandle handle) throws IOException, ProtocolInitException, ProtocolException {
        ProtocolEngine eng = this.runningEngines.get(handle);
        if (eng != null) {
            eng.restartProtocol();
        }
    }

    public void sendMessage(ProtocolHandle handle, ProtocolMessage message) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException, IOException {
        ProtocolEngine eng = this.runningEngines.get(handle);
        if (eng != null) {
            eng.sendMessage(message);
        }
    }

    @Override
    public void cleanStoppedProtocols() {
        Set<ProtocolHandle> keys = this.runningEngines.keySet();
        for (ProtocolHandle key : keys) {
            ProtocolEngine aEng = this.runningEngines.get(key);
            if (aEng.isConnected()) continue;
            this.runningEngines.remove(key);
        }
    }
}

