/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.shellwax.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class BashLanguageServer
extends ProcessStreamConnectionProvider {
    private static final String LS_VERSION = "1.16.1";
    private static final String LOCAL_PATH = "/.local/share/shellwax/1.16.1";
    private static final String LS_MAIN = "/node_modules/.bin/bash-language-server";
    private static final String LS_MAIN_WIN32 = "/bash-language-server";
    private static boolean alreadyWarned;
    private static CompletableFuture<Void> initializeFuture;

    private static String getLsPath() {
        String lsPath = String.valueOf(System.getProperty("user.home")) + LOCAL_PATH;
        lsPath = Platform.getOS().equals("win32") ? String.valueOf(lsPath) + LS_MAIN_WIN32 + ".cmd" : String.valueOf(lsPath) + LS_MAIN;
        return lsPath;
    }

    private static boolean isInstalled() {
        File installLocation = new File(BashLanguageServer.getLsPath());
        return installLocation.exists() && installLocation.canExecute();
    }

    public BashLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        String nodePath = NodeJSManager.getNodeJsLocation().getAbsolutePath();
        if (nodePath == null) {
            nodePath = BashLanguageServer.getExecLocation("node");
        }
        if (nodePath != null) {
            if (!BashLanguageServer.isInstalled()) {
                this.installLS();
            }
            String lsPath = BashLanguageServer.getLsPath();
            if (Platform.getOS().equals("win32")) {
                commands.add("cmd");
                commands.add("/c");
            } else {
                commands.add(nodePath);
            }
            commands.add(lsPath);
            commands.add("start");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
    }

    public void start() throws IOException {
        if (!BashLanguageServer.isInstalled()) {
            this.installLS().join();
        }
        super.start();
    }

    private synchronized CompletableFuture<Void> installLS() {
        if (initializeFuture == null) {
            initializeFuture = CompletableFuture.runAsync(() -> {
                String npmPath;
                File installLocation = new File(String.valueOf(System.getProperty("user.home")) + LOCAL_PATH);
                if (!installLocation.isDirectory()) {
                    installLocation.delete();
                }
                if (!installLocation.exists()) {
                    installLocation.mkdirs();
                    File nodeModulesDir = new File(installLocation, "node_modules");
                    nodeModulesDir.mkdir();
                }
                if ((npmPath = NodeJSManager.getNpmLocation().getAbsolutePath()) == null) {
                    npmPath = BashLanguageServer.getExecLocation("npm");
                }
                if (Platform.getOS().equals("win32")) {
                    npmPath = String.valueOf(npmPath) + ".cmd";
                }
                if (npmPath != null) {
                    ArrayList<String> commands = new ArrayList<String>();
                    commands.add(npmPath);
                    commands.add("install");
                    commands.add("--prefix=.");
                    commands.add("bash-language-server@1.16.1");
                    ProcessBuilder pb = new ProcessBuilder(commands);
                    pb.directory(installLocation);
                    try {
                        Process ps = pb.start();
                        ps.waitFor();
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return initializeFuture;
    }

    private static String getExecLocation(String exec) {
        String res = "/path/to/" + exec;
        String[] command = new String[]{"/bin/bash", "-c", "which " + exec};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where " + exec};
        }
        BufferedReader reader = null;
        try {
            Process p = Runtime.getRuntime().exec(command);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            res = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (res == null && Platform.getOS().equals("macosx")) {
            res = "/usr/local/bin/" + exec;
        }
        if (res != null && Files.exists(Paths.get(res, new String[0]), new LinkOption[0])) {
            return res;
        }
        if (!alreadyWarned) {
            BashLanguageServer.warnExecMissing(exec);
            alreadyWarned = true;
        }
        return null;
    }

    private static void warnExecMissing(String exec) {
        Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)("Missing " + exec), (String)"Could not find node.js. This will result in editors missing key features.\nPlease make sure node.js is installed and that your PATH environement variable contains the location to the `node` executable."));
    }
}

