/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.shellwax.internal.run;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public class ShLaunchConfig
extends LaunchConfigurationDelegate {
    public static final String ID = "org.eclipse.shellwax.shlaunchonfigtype";
    public static final String PROGRAM = "org.eclipse.shellwax.launch.program";
    public static final String ARGUMENTS = "org.eclipse.shellwax.launch.arguments";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        ArrayList<String> command = new ArrayList<String>();
        String shellPath = wc.getAttribute(PROGRAM, "");
        String[] shellParams = wc.getAttribute(ARGUMENTS, "").split(" ");
        String workDir = wc.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "");
        if (workDir.isEmpty()) {
            Path path = new Path(shellPath);
            path = path.removeLastSegments(1);
            workDir = path.toPortableString();
        }
        String executable = "sh";
        if (Platform.getOS().equals("win32")) {
            executable = "bash.exe";
            String drive = Character.toString(shellPath.charAt(0));
            shellPath = "/mnt/" + drive.toLowerCase() + "/" + shellPath.substring(2);
        }
        command.add(executable);
        command.add(shellPath);
        command.addAll(Arrays.asList(shellParams));
        try {
            ProcessBuilder pb = new ProcessBuilder(command.toArray(new String[command.size()]));
            pb.directory(new File(workDir));
            Process p = pb.start();
            DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)shellPath);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

