/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.business.internal.interpreter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.AcceleoInterpreter;

public class AcceleoTemplateWorkspaceListener
implements IResourceChangeListener {
    private AcceleoInterpreter interpreter;

    public AcceleoTemplateWorkspaceListener(AcceleoInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null && this.hasAtLeastOneModifiedTemplate(delta)) {
            this.processDelta(delta);
        }
    }

    private boolean hasAtLeastOneModifiedTemplate(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta deltaChild = iResourceDeltaArray[n2];
            if (this.isAboutFolderDerived(deltaChild)) break;
            if (this.isAboutTemplateChange(deltaChild) || this.hasAtLeastOneModifiedTemplate(deltaChild)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isAboutFolderDerived(IResourceDelta delta) {
        return delta.getResource().getType() == 2 && delta.getResource().isDerived();
    }

    private boolean isAboutTemplateChange(IResourceDelta delta) {
        return delta.getResource().getType() == 1 && delta.getKind() == 4 && this.isTemplate(delta);
    }

    private boolean isTemplate(IResourceDelta delta) {
        if (delta.getFullPath() != null) {
            IFile file = FileProvider.findFile((IPath)delta.getFullPath());
            return "mt".equals(file.getFileExtension());
        }
        return false;
    }

    private void processDelta(IResourceDelta delta) {
        this.interpreter.reconsiderTemplateFiles();
    }
}

