/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.query.legacy.ecore.factories.EFactory;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoEcoreGenPlugin;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateElement;
import org.eclipse.sirius.query.legacy.gen.template.TemplateNodeElement;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.TemplateText;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.ScriptDescriptor;
import org.eclipse.sirius.query.legacy.gen.template.statements.TemplateCommentStatement;
import org.eclipse.sirius.query.legacy.gen.template.statements.TemplateFeatureStatement;
import org.eclipse.sirius.query.legacy.gen.template.statements.TemplateForStatement;
import org.eclipse.sirius.query.legacy.gen.template.statements.TemplateIfStatement;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class Template
extends TemplateNodeElement {
    public static final Template EMPTY = new Template(null);
    protected ScriptDescriptor descriptor = null;
    protected TemplateExpression postExpression = null;
    protected boolean emptyEvaluation = true;
    protected List elements = new ArrayList();
    protected static Class preferredTemplate = Template.class;
    protected List currentEval = new ArrayList();

    public Template(IScript script) {
        super(script);
    }

    public ScriptDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ScriptDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public TemplateExpression getPostExpression() {
        return this.postExpression;
    }

    public void setPostExpression(TemplateExpression postExpression) {
        this.postExpression = postExpression;
    }

    public boolean isEmptyEvaluation() {
        return this.emptyEvaluation;
    }

    public Object copyState() {
        return new ArrayList(this.elements);
    }

    public void fromState(Object state) {
        this.elements = (List)state;
    }

    public void clear() {
        this.elements.clear();
    }

    public void append(TemplateNodeElement element) {
        if (element instanceof TemplateText) {
            if (((TemplateText)element).text.length() > 0) {
                this.elements.add(element);
                element.setParent(this);
            }
        } else if (element != null) {
            this.elements.add(element);
            element.setParent(this);
        }
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer("");
        for (TemplateNodeElement element : this.elements) {
            text.append(element.toString());
        }
        return text.toString();
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    public static Template from(String buffer, IScript script, EObject object) throws ENodeException {
        try {
            return Template.read(buffer, script);
        }
        catch (TemplateSyntaxException e) {
            throw new ENodeException(e.getMessage(), e.getPos(), script, object, true);
        }
    }

    private static Template read(String buffer, IScript script) throws TemplateSyntaxException {
        return Template.read(buffer, new Int2(0, buffer.length()), script);
    }

    public static Template read(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        Template template = (Template)Template.readPreferred("read", buffer, limits, script);
        if (template == null) {
            template = new Template(script);
            template.setPos(limits);
            if (buffer != null) {
                int[] pos = new int[4];
                int i = 0;
                while (i < pos.length) {
                    pos[i] = -2;
                    ++i;
                }
                i = limits.b();
                while (i < limits.e()) {
                    int iTab;
                    if (pos[0] != -1 && i > pos[0]) {
                        pos[0] = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.COMMENT_BEGIN, i, limits.e()).b();
                    }
                    if (pos[1] != -1 && i > pos[1]) {
                        pos[1] = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.IF_BEGIN, i, limits.e()).b();
                    }
                    if (pos[2] != -1 && i > pos[2]) {
                        pos[2] = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.FOR_BEGIN, i, limits.e()).b();
                    }
                    if (pos[3] != -1 && i > pos[3]) {
                        pos[3] = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.FEATURE_BEGIN, i, limits.e()).b();
                    }
                    if ((iTab = Template.indexOfMin(pos)) == 0) {
                        i = Template.readStatement(buffer, TemplateConstants.COMMENT_BEGIN, TemplateConstants.COMMENT_END, new Int2(i, limits.e()), template, script);
                        continue;
                    }
                    if (iTab == 1) {
                        i = Template.readStatement(buffer, TemplateConstants.IF_BEGIN, TemplateConstants.IF_END, new Int2(i, limits.e()), template, script);
                        continue;
                    }
                    if (iTab == 2) {
                        i = Template.readStatement(buffer, TemplateConstants.FOR_BEGIN, TemplateConstants.FOR_END, new Int2(i, limits.e()), template, script);
                        continue;
                    }
                    if (iTab == 3) {
                        i = Template.readStatement(buffer, TemplateConstants.FEATURE_BEGIN, TemplateConstants.FEATURE_END, new Int2(i, limits.e()), template, script);
                        continue;
                    }
                    Int2 posText = new Int2(i, limits.e());
                    template.append(Template.readMiddleElement(buffer, posText, script));
                    i = limits.e();
                }
            }
        }
        return template;
    }

    public static TemplateNodeElement readMiddleElement(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        TemplateNodeElement element = Template.readPreferred("readMiddleElement", buffer, limits, script);
        if (element == null) {
            element = new TemplateText(buffer.substring(limits.b(), limits.e()), script);
            element.setPos(limits);
        }
        return element;
    }

    private static TemplateNodeElement readPreferred(String method, String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        if (preferredTemplate != Template.class) {
            try {
                return (TemplateNodeElement)preferredTemplate.getMethod(method, String.class, Int2.class, IScript.class).invoke((Object)preferredTemplate, buffer, limits, script);
            }
            catch (IllegalArgumentException e) {
                AcceleoEcoreGenPlugin.getDefault().log(e, true);
            }
            catch (SecurityException e) {
                AcceleoEcoreGenPlugin.getDefault().log(e, true);
            }
            catch (IllegalAccessException e) {
                AcceleoEcoreGenPlugin.getDefault().log(e, true);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof TemplateSyntaxException) {
                    throw (TemplateSyntaxException)e.getTargetException();
                }
                AcceleoEcoreGenPlugin.getDefault().log(e, true);
            }
            catch (NoSuchMethodException e) {
                AcceleoEcoreGenPlugin.getDefault().log(e, true);
            }
        }
        return null;
    }

    protected static int indexOfMin(int[] pos) {
        int index = -1;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < pos.length) {
            if (pos[i] > -1 && pos[i] < min) {
                index = i;
                min = pos[i];
            }
            ++i;
        }
        return index;
    }

    protected static int readStatement(String buffer, String tagBegin, String tagEnd, Int2 limits, Template template, IScript script) throws TemplateSyntaxException {
        Int2 end = Int2.NOT_FOUND;
        Int2 begin = TextSearch.getDefaultSearch().indexIn(buffer, tagBegin, limits.b(), limits.e());
        end = tagBegin == TemplateConstants.COMMENT_BEGIN ? TextSearch.getDefaultSearch().blockIndexEndIn(buffer, tagBegin, tagEnd, begin.b(), limits.e(), false) : TextSearch.getDefaultSearch().blockIndexEndIn(buffer, tagBegin, tagEnd, begin.b(), limits.e(), true, null, TemplateConstants.INHIBS_STATEMENT);
        if (end.b() > -1) {
            boolean untab;
            boolean bl = untab = tagBegin != TemplateConstants.FEATURE_BEGIN && Template.isFirstSignificantOfLine(buffer, begin.b()) && Template.isLastSignificantOfLine(buffer, end.e());
            if (begin.b() > limits.b()) {
                int iEndText = begin.b();
                if (untab) {
                    int iPrevLine = TextSearch.getDefaultSearch().lastIndexIn(buffer, "\n", limits.b(), begin.b()).e();
                    if (iPrevLine == -1) {
                        iPrevLine = limits.b();
                    }
                    if (buffer.substring(iPrevLine, begin.b()).trim().length() == 0) {
                        iEndText = iPrevLine;
                    }
                }
                Int2 posText = new Int2(limits.b(), iEndText);
                template.append(Template.readMiddleElement(buffer, posText, script));
            }
            if (tagBegin == TemplateConstants.IF_BEGIN) {
                template.append(TemplateIfStatement.fromString(buffer, new Int2(begin.e(), end.b()), script));
            }
            if (tagBegin == TemplateConstants.FOR_BEGIN) {
                template.append(TemplateForStatement.fromString(buffer, new Int2(begin.e(), end.b()), script));
            }
            if (tagBegin == TemplateConstants.FEATURE_BEGIN) {
                template.append(TemplateFeatureStatement.fromString(buffer, new Int2(begin.e(), end.b()), script));
            }
            if (tagBegin == TemplateConstants.COMMENT_BEGIN) {
                template.append(TemplateCommentStatement.fromString(buffer, new Int2(begin.e(), end.b()), script));
            }
            if (untab) {
                int iNextLine = TextSearch.getDefaultSearch().indexIn(buffer, "\n", end.e(), limits.e()).e();
                if (iNextLine == -1) {
                    iNextLine = limits.e();
                }
                if (buffer.substring(end.e(), iNextLine).trim().length() == 0) {
                    return iNextLine;
                }
            }
            return end.e();
        }
        template.append(Template.readMiddleElement(buffer, limits, script));
        throw new TemplateSyntaxException(AcceleoGenMessages.getString("Template.UnclosedTag", new Object[]{tagEnd, tagBegin}), script, new Int2(begin.b(), limits.e()));
    }

    private static boolean isFirstSignificantOfLine(String buffer, int index) {
        if (index > 0 && index < buffer.length()) {
            --index;
            while (index >= 0) {
                char c = buffer.charAt(index);
                if (c == '\n') {
                    return true;
                }
                if (c == ' ' || c == '\t' || c == '\r') {
                    --index;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean isLastSignificantOfLine(String buffer, int index) {
        if (index >= 0) {
            while (index < buffer.length()) {
                char c = buffer.charAt(index);
                if (c == '\n') {
                    return true;
                }
                if (c == ' ' || c == '\t' || c == '\r') {
                    ++index;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public static Int2 formatTemplate(String buffer, Int2 limits, int nbReturn) {
        if (limits.b() == -1 || limits.b() > limits.e()) {
            return Int2.NOT_FOUND;
        }
        String text = buffer.substring(limits.b(), limits.e());
        int posBegin = text.indexOf("\n");
        posBegin = posBegin == -1 || text.substring(0, posBegin).trim().length() > 0 ? 0 : ++posBegin;
        if (text.length() > 0) {
            int n = 0;
            int endLine = text.length();
            int posEnd = text.length() - 1;
            boolean stop = false;
            while (!stop) {
                char c = text.charAt(posEnd);
                if (nbReturn == 0 && c == '\n') {
                    ++posEnd;
                    stop = true;
                } else if (c == '\n' && n < nbReturn) {
                    ++n;
                    endLine = posEnd;
                } else if (c == '\r') {
                    endLine = posEnd;
                } else if (c != ' ' && c != '\t') {
                    posEnd = endLine;
                    stop = true;
                }
                if (stop) continue;
                if (posEnd > posBegin) {
                    --posEnd;
                    continue;
                }
                if (nbReturn != 0) {
                    posEnd = endLine;
                }
                stop = true;
            }
            if (posEnd >= posBegin) {
                boolean formatWithComment = false;
                String sub = text.substring(posBegin, posEnd);
                if (sub.startsWith(TemplateConstants.COMMENT_BEGIN) && sub.indexOf(TemplateConstants.COMMENT_END) > -1) {
                    posBegin = text.indexOf(TemplateConstants.COMMENT_END, posBegin) + TemplateConstants.COMMENT_END.length();
                    formatWithComment = true;
                    sub = posEnd > posBegin ? sub.substring(posBegin) : "";
                }
                if (sub.endsWith(TemplateConstants.COMMENT_END) && sub.lastIndexOf(TemplateConstants.COMMENT_BEGIN, posEnd) > -1) {
                    posEnd = text.lastIndexOf(TemplateConstants.COMMENT_BEGIN, posEnd);
                    formatWithComment = true;
                }
                if (formatWithComment) {
                    return Template.formatTemplate(buffer, new Int2(limits.b() + posBegin, limits.b() + posEnd), nbReturn);
                }
                return new Int2(limits.b() + posBegin, limits.b() + posEnd);
            }
        }
        return limits;
    }

    public String evaluateAsString(EObject object, LaunchManager mode) throws ENodeException, FactoryException {
        String text = this.evaluate(object, mode).asString();
        return text;
    }

    public ENode evaluateWithComment(EObject object, LaunchManager mode) throws ENodeException, FactoryException {
        ENode node = new ENode(ENode.EMPTY, object, this, mode.isSynchronize());
        String comment = this.eGetAsString(object, "comment");
        if (comment.length() > 0) {
            node.append(comment, 1);
        }
        node.append(this.evaluate(object, mode));
        comment = this.eGetAsString(object, "endLineComment");
        if (comment.length() > 0) {
            node.append(comment, 1);
        }
        return node;
    }

    private String eGetAsString(EObject object, String feature) {
        try {
            String result = EFactory.eGetAsString(object, feature);
            if (result == null) {
                result = "";
            }
            return result;
        }
        catch (FactoryException factoryException) {
            return "";
        }
    }

    @Override
    public ENode evaluate(EObject object, LaunchManager mode) throws ENodeException, FactoryException {
        boolean parentIsStatement;
        if (mode.getMonitor() != null && mode.getMonitor().isCanceled()) {
            throw new OperationCanceledException();
        }
        ENode node = new ENode(ENode.EMPTY, object, this, mode.isSynchronize());
        boolean bl = parentIsStatement = this.getParent() instanceof TemplateForStatement || this.getParent() instanceof TemplateIfStatement;
        if (!parentIsStatement && this.currentEval.contains(object)) {
            this.emptyEvaluation = true;
            throw new ENodeException(AcceleoGenMessages.getString("Template.RecursiveCall", new Object[]{this.toString()}), this.pos, this.script, object, true);
        }
        if (this.script != null) {
            ENode tmp = new ENode(object, this, mode.isSynchronize());
            this.script.contextPush(IScript.CURRENT_NODE, tmp);
            this.script.contextPush(IScript.TEMPLATE_NODE, tmp);
        }
        try {
            if (!parentIsStatement) {
                this.currentEval.add(object);
            }
            TemplateNodeElement precedingElement = null;
            ENode precedingChild = null;
            Iterator elements = this.elements.iterator();
            while (elements.hasNext()) {
                TemplateNodeElement element;
                block16: {
                    element = (TemplateNodeElement)elements.next();
                    try {
                        if (elements.hasNext() || !(element instanceof TemplateText) || !node.isEObject() && (!node.isList() || node.getList().size() <= 0 || !node.getList().get(0).isEObject()) || ((TemplateText)element).getText().trim().length() != 0) break block16;
                        break;
                    }
                    catch (ENodeCastException eNodeCastException) {}
                }
                ENode child = element.evaluate(object, mode);
                try {
                    String indent;
                    String precedingText;
                    int iLine;
                    String text;
                    if (element.getScript() != null && element.getScript().getFile() != null && element.getScript().getFile().getName().endsWith(".mt") && element instanceof TemplateFeatureStatement && precedingElement instanceof TemplateText && precedingChild.isString() && precedingChild.getString().length() > 0 && (text = child.asString()).indexOf("\n") > -1 && (iLine = (precedingText = precedingChild.getString()).lastIndexOf("\n")) > -1 && iLine + 1 < precedingText.length() && (indent = precedingText.substring(iLine + 1)).trim().length() == 0) {
                        child.stringCall("internalIndent:" + indent, 0, 0);
                    }
                }
                catch (ENodeCastException eNodeCastException) {}
                node.append(child);
                precedingElement = element;
                precedingChild = child;
            }
        }
        finally {
            if (this.script != null) {
                this.script.contextPop(IScript.CURRENT_NODE);
                this.script.contextPop(IScript.TEMPLATE_NODE);
            }
            if (!parentIsStatement) {
                this.currentEval.remove(object);
            }
        }
        if (this.postExpression != null) {
            node = this.postExpression.evaluate(node, this.script, mode);
        }
        this.emptyEvaluation = node.size() == 0;
        return node;
    }

    public boolean containsText(String text, boolean ignoreCase) {
        if (ignoreCase) {
            return this.toString().toUpperCase().indexOf(text.toUpperCase()) > -1;
        }
        return this.toString().indexOf(text) > -1;
    }

    public int hashCode() {
        if (this.pos.b() >= 1) {
            return this.pos.b();
        }
        return super.hashCode();
    }

    public List getSignificantStatements() {
        ArrayList<TemplateElement> result = new ArrayList<TemplateElement>();
        for (TemplateElement element : this.children) {
            if (!(element instanceof TemplateNodeElement) || element instanceof TemplateCommentStatement || element instanceof TemplateText) continue;
            result.add(element);
        }
        return result;
    }
}

