/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.tools.plugins;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;
import org.osgi.framework.Bundle;

public class AcceleoModuleProvider {
    public static final File NOT_FOUND = new File("");
    private static AcceleoModuleProvider instance;
    private Map file2plugin = new HashMap();
    private Map file2relativePath = new HashMap();
    private Map absolutPath2file = new HashMap();
    private Map bundleName2mtPaths = new HashMap();

    public static AcceleoModuleProvider getDefault() {
        if (instance == null) {
            instance = new AcceleoModuleProvider();
        }
        return instance;
    }

    public String getPluginId(File file) {
        return (String)this.file2plugin.get(file);
    }

    public String getRelativePath(File file) {
        return (String)this.file2relativePath.get(file);
    }

    public File getFile(String pluginId, String fullName, String extension) {
        IPath fullPath = new Path(fullName.replaceAll("\\.", "/")).addFileExtension(extension);
        return this.getFile(pluginId, fullPath);
    }

    public File getFile(IPath fullPath) {
        if (fullPath != null && fullPath.segmentCount() > 0) {
            IFile file = Resources.findFile(fullPath);
            if (file != null) {
                return file.getLocation().toFile();
            }
            String pluginId = fullPath.segment(0);
            return this.getFile(pluginId, fullPath.removeFirstSegments(1));
        }
        return null;
    }

    public File getFile(String pluginId, IPath relativePath) {
        return this.getFile(pluginId, relativePath, true);
    }

    private File getFile(String pluginId, IPath relativePath, boolean requiredSearch) {
        File res = null;
        File cachedRes = (File)this.absolutPath2file.get(String.valueOf(pluginId) + relativePath);
        if (cachedRes != null) {
            if (cachedRes != NOT_FOUND) {
                res = cachedRes;
            }
        } else {
            Bundle bundle = Platform.getBundle((String)pluginId);
            if (bundle != null) {
                String requiredBundles;
                URL url = bundle.getEntry(relativePath.toString());
                if (url == null && "mt".equals(relativePath.getFileExtension()) && relativePath.segmentCount() > 1 && (url = bundle.getEntry(relativePath.removeFirstSegments(1).toString())) == null) {
                    url = this.getRuntimeModeURL(bundle, relativePath);
                }
                if (url != null) {
                    File file = new File(Resources.transformToAbsolutePath(url));
                    if (file.exists()) {
                        if (!this.file2plugin.containsKey(file)) {
                            this.file2plugin.put(file, pluginId);
                            this.file2relativePath.put(file, relativePath.toString());
                            Enumeration allProperties = bundle.findEntries(relativePath.removeLastSegments(1).toString(), "*.properties", true);
                            while (allProperties != null && allProperties.hasMoreElements()) {
                                File propertyFile;
                                URL propertyFileURL = (URL)allProperties.nextElement();
                                if (propertyFileURL == null || !(propertyFile = new File(Resources.transformToAbsolutePath(propertyFileURL))).exists()) continue;
                                this.file2plugin.put(propertyFile, pluginId);
                            }
                        }
                        res = file;
                    }
                } else if (requiredSearch && (requiredBundles = (String)bundle.getHeaders().get("Require-Bundle")) != null) {
                    StringTokenizer st = new StringTokenizer(requiredBundles, ",");
                    while (st.hasMoreTokens()) {
                        File scriptFile;
                        String id = st.nextToken().trim();
                        int iDot = id.indexOf(59);
                        if (iDot > -1) {
                            id = id.substring(0, iDot).trim();
                        }
                        if (id.length() <= 0 || (scriptFile = this.getFile(id, relativePath, true)) == null) continue;
                        res = scriptFile;
                    }
                }
            }
            if (res != null) {
                this.absolutPath2file.put(String.valueOf(pluginId) + relativePath, res);
            } else {
                this.absolutPath2file.put(String.valueOf(pluginId) + relativePath, NOT_FOUND);
            }
        }
        return res;
    }

    private URL getRuntimeModeURL(Bundle bundle, IPath relativePath) {
        List URLs;
        HashMap<String, ArrayList<URL>> mtName2mtURLs = (HashMap<String, ArrayList<URL>>)this.bundleName2mtPaths.get(bundle.getSymbolicName());
        if (mtName2mtURLs == null) {
            mtName2mtURLs = new HashMap<String, ArrayList<URL>>();
            this.bundleName2mtPaths.put(bundle.getSymbolicName(), mtName2mtURLs);
            Enumeration entries = bundle.findEntries("/", "*.mt", true);
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    Path path;
                    URL entry = (URL)entries.nextElement();
                    if (entry == null || (path = new Path(entry.getPath())).segmentCount() <= 0) continue;
                    String name = path.lastSegment();
                    ArrayList<URL> mt = (ArrayList<URL>)mtName2mtURLs.get(name);
                    if (mt == null) {
                        mt = new ArrayList<URL>();
                        mtName2mtURLs.put(name, mt);
                    }
                    mt.add(entry);
                }
            }
        }
        if ((URLs = (List)mtName2mtURLs.get(relativePath.lastSegment())) != null) {
            for (URL url : URLs) {
                if (url.getPath().indexOf(relativePath.toString()) <= -1) continue;
                return url;
            }
        }
        return null;
    }
}

