/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.tools.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;

public class FileContentMap {
    protected int max;
    protected Map file2content;
    protected Map file2OldModificationStamp = new HashMap();
    protected List priority = new ArrayList();

    public FileContentMap() {
        this(-1, true);
    }

    public FileContentMap(int max) {
        this(max, true);
    }

    public FileContentMap(boolean weak) {
        this(-1, weak);
    }

    public FileContentMap(int max, boolean weak) {
        this.max = max;
        this.file2content = weak ? new WeakHashMap() : new HashMap();
    }

    public Object get(IFile file) {
        if (file != null) {
            String path = file.getFullPath().toString();
            Object content = this.file2content.get(path);
            Double newModificationStamp = new Double(file.getModificationStamp() + file.getLocalTimeStamp());
            Double oldModificationStamp = (Double)this.file2OldModificationStamp.get(path);
            if (content != null && oldModificationStamp != null && oldModificationStamp.doubleValue() == newModificationStamp.doubleValue()) {
                if (content instanceof EObject) {
                    return this.getForEObject((EObject)content);
                }
                return content;
            }
            this.file2content.remove(path);
            this.file2OldModificationStamp.remove(path);
            this.priority.remove(path);
            return null;
        }
        return null;
    }

    public Object get(File file) {
        if (file != null) {
            String path = file.getAbsolutePath().toString();
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
            if (workspaceFile != null && workspaceFile.isAccessible()) {
                return this.get(workspaceFile);
            }
            Object content = this.file2content.get(path);
            Double newModificationStamp = new Double(file.lastModified());
            Double oldModificationStamp = (Double)this.file2OldModificationStamp.get(path);
            if (content != null && oldModificationStamp != null && oldModificationStamp.doubleValue() == newModificationStamp.doubleValue()) {
                if (content instanceof EObject) {
                    return this.getForEObject((EObject)content);
                }
                return content;
            }
            this.file2content.remove(path);
            this.file2OldModificationStamp.remove(path);
            this.priority.remove(path);
            return null;
        }
        return null;
    }

    private EObject getForEObject(EObject content) {
        if (content.eResource() != null && content.eResource().getResourceSet() != null) {
            ResourceSet resourceSet = content.eResource().getResourceSet();
            for (Resource resource : resourceSet.getResources()) {
                IFile loadedFile;
                if (resource == content.eResource() || resource.getURI() == null || (loadedFile = Resources.getIFile(resource.getURI())) == null || !loadedFile.exists()) continue;
                Double newModificationStamp = new Double(loadedFile.getModificationStamp() + loadedFile.getLocalTimeStamp());
                Double oldModificationStamp = (Double)this.file2OldModificationStamp.get(loadedFile.getFullPath().toString());
                if (oldModificationStamp != null && oldModificationStamp.doubleValue() == newModificationStamp.doubleValue()) continue;
                return null;
            }
        }
        return content;
    }

    public void put(IFile file, Object content) {
        if (file != null) {
            String path = file.getFullPath().toString();
            if (this.max > -1 && this.size() >= this.max && this.priority.size() > 0) {
                Object toRemove = this.priority.get(0);
                this.file2content.remove(toRemove);
                this.file2OldModificationStamp.remove(toRemove);
                this.priority.remove(0);
            }
            this.file2content.put(path, content);
            this.file2OldModificationStamp.put(path, new Double(file.getModificationStamp() + file.getLocalTimeStamp()));
            if (content instanceof EObject) {
                this.putForEObject((EObject)content);
            }
            this.priority.add(path);
        }
    }

    public void put(File file, Object content) {
        if (file != null) {
            String path = file.getAbsolutePath().toString();
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
            if (workspaceFile != null && workspaceFile.isAccessible()) {
                this.put(workspaceFile, content);
            } else {
                if (this.max > -1 && this.size() >= this.max && this.priority.size() > 0) {
                    Object toRemove = this.priority.get(0);
                    this.file2content.remove(toRemove);
                    this.file2OldModificationStamp.remove(toRemove);
                    this.priority.remove(0);
                }
                this.file2content.put(path, content);
                this.file2OldModificationStamp.put(path, new Double(file.lastModified()));
                if (content instanceof EObject) {
                    this.putForEObject((EObject)content);
                }
                this.priority.add(path);
            }
        }
    }

    private void putForEObject(EObject content) {
        if (content.eResource() != null && content.eResource().getResourceSet() != null) {
            ResourceSet resourceSet = content.eResource().getResourceSet();
            for (Resource resource : resourceSet.getResources()) {
                IFile loadedFile;
                if (resource == content.eResource() || resource.getURI() == null || (loadedFile = Resources.getIFile(resource.getURI())) == null || !loadedFile.exists()) continue;
                this.file2OldModificationStamp.put(loadedFile.getFullPath().toString(), new Double(loadedFile.getModificationStamp() + loadedFile.getLocalTimeStamp()));
            }
        }
    }

    public void remove(IFile file) {
        String path = file.getFullPath().toString();
        this.file2content.remove(path);
        this.file2OldModificationStamp.remove(path);
        this.priority.remove(path);
    }

    public void remove(File file) {
        String path = file.getAbsolutePath().toString();
        IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
        if (workspaceFile != null && workspaceFile.isAccessible()) {
            this.remove(workspaceFile);
        } else {
            this.file2content.remove(path);
            this.file2OldModificationStamp.remove(path);
            this.priority.remove(path);
        }
    }

    public int size() {
        return this.file2content.size();
    }

    public void clear() {
        this.file2content.clear();
        this.file2OldModificationStamp.clear();
        this.priority.clear();
    }

    public Collection values() {
        if (!(this.file2content instanceof WeakHashMap)) {
            return this.file2content.values();
        }
        return new ArrayList();
    }

    public Set entrySet() {
        return this.file2content.entrySet();
    }
}

