/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.views.graph;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.eclipse.elk.core.debug.ElkDebugPlugin;
import org.eclipse.elk.core.debug.model.ExecutionInfo;
import org.eclipse.elk.core.debug.views.graph.LayoutGraphView;
import org.eclipse.elk.core.debug.views.graph.LoadGraphAction;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.action.Action;

public class ReloadFromFileAction
extends Action {
    private static final String ACTION_ID = "org.eclipse.elk.debug.actions.reloadFromFile";
    private static final String ICON_PATH = "icons/refresh.gif";
    private LayoutGraphView view;

    public ReloadFromFileAction(LayoutGraphView theview) {
        this.setId(ACTION_ID);
        this.setText("&Reload from File");
        this.setToolTipText("Reloads a selected graph from .");
        this.setImageDescriptor(ElkDebugPlugin.imageDescriptorFromPlugin((String)"org.eclipse.elk.core.debug", (String)ICON_PATH));
        this.view = theview;
    }

    public void updateEnablement() {
        List<ExecutionInfo> selection = this.view.getSelectedExecutionInfos();
        this.setEnabled(selection.size() == 1 && selection.get(0).isLoadedFromFile());
    }

    public void run() {
        List<ExecutionInfo> selection = this.view.getSelectedExecutionInfos();
        if (selection.size() != 1 || !selection.get(0).isLoadedFromFile()) {
            return;
        }
        ExecutionInfo oldInfo = selection.get(0);
        try {
            ElkNode graph = LoadGraphAction.loadFromFile(oldInfo.getFileName());
            final ExecutionInfo newInfo = LoadGraphAction.layout(oldInfo.getFileName(), oldInfo.isLaidOutAfterLoad(), graph);
            ElkDebugPlugin.getDefault().getModel().replaceExecution(oldInfo, newInfo);
            this.view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReloadFromFileAction.this.view.setSelectedExecutionInfos(Lists.newArrayList((Object[])new ExecutionInfo[]{newInfo}));
                }
            });
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }
}

