/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.api.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TabularReport {
    private final List<String> headers;
    private final List<List<String>> lines;

    public TabularReport(String ... headers) {
        this.headers = new ArrayList<String>(Arrays.asList(headers));
        this.lines = new ArrayList<List<String>>();
    }

    public void addLine(List<String> data) {
        this.lines.add(data);
    }

    public void addLine(String ... data) {
        this.addLine(new ArrayList<String>(Arrays.asList(data)));
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        int[] width = this.computeColumnsWidth();
        int totalWidth = this.computeTotalTableWidth(width);
        this.printSeparator(sb, totalWidth);
        this.printLine(sb, this.headers, width);
        this.printSeparator(sb, totalWidth);
        for (List<String> line : this.lines) {
            this.printLine(sb, line, width);
        }
        this.printSeparator(sb, totalWidth);
        return sb.toString();
    }

    private void printLine(StringBuilder sb, List<String> data, int[] width) {
        int i = 0;
        for (String cell : data) {
            sb.append("| ");
            this.printPadded(sb, cell, width[i]);
            ++i;
        }
        sb.append("|");
        sb.append("\n");
    }

    private void printPadded(StringBuilder sb, String str, int width) {
        sb.append(str);
        this.fill(sb, ' ', width - str.length() + 1);
    }

    private int computeTotalTableWidth(int[] columnsWidth) {
        int totalWidth = 0;
        int[] nArray = columnsWidth;
        int n = columnsWidth.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            totalWidth += element + 3;
            ++n2;
        }
        return ++totalWidth;
    }

    private int[] computeColumnsWidth() {
        int[] width = new int[this.headers.size()];
        int i = 0;
        while (i < width.length) {
            width[i] = this.headers.get(i).length();
            ++i;
        }
        for (List<String> line : this.lines) {
            int i2 = 0;
            while (i2 < line.size()) {
                width[i2] = Math.max(width[i2], line.get(i2).length());
                ++i2;
            }
        }
        return width;
    }

    private void printSeparator(StringBuilder sb, int width) {
        this.fill(sb, '-', width);
        sb.append("\n");
    }

    private void fill(StringBuilder sb, char c, int n) {
        int i = 0;
        while (i < n) {
            sb.append(c);
            ++i;
        }
    }
}

