/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;

public class PositionsChecker {
    private SequenceDiagram diagram;
    private Function<ISequenceEvent, Range> rangeFunction = ISequenceEvent.VERTICAL_RANGE;

    public PositionsChecker(SequenceDiagram diagram) {
        this.diagram = diagram;
    }

    public PositionsChecker(SequenceDiagram diagram, Function<ISequenceEvent, Range> rangeFunction) {
        this.diagram = diagram;
        if (rangeFunction != null) {
            this.rangeFunction = rangeFunction;
        }
    }

    public Collection<Integer> getInvalidPositions() {
        HashMultiset positions = HashMultiset.create();
        for (ISequenceEvent ise : this.diagram.getAllOrderedDelimitedSequenceEvents()) {
            Range futureRange = (Range)this.rangeFunction.apply((Object)ise);
            int futureLowerBound = futureRange.getLowerBound();
            int futureUpperBound = futureRange.getUpperBound();
            if (ise instanceof Execution) {
                Execution exec = (Execution)ise;
                if (!exec.getStartMessage().some()) {
                    positions.add((Object)futureLowerBound);
                }
                if (exec.getEndMessage().some()) continue;
                positions.add((Object)futureUpperBound);
                continue;
            }
            if (ise instanceof Operand) {
                positions.add((Object)futureLowerBound);
                continue;
            }
            if (ise instanceof Message) {
                positions.add((Object)futureLowerBound);
                if (!((Message)ise).isReflective()) continue;
                positions.add((Object)futureUpperBound);
                continue;
            }
            if (ise instanceof State && ise.isLogicallyInstantaneous()) {
                positions.add((Object)futureRange.middleValue());
                continue;
            }
            positions.add((Object)futureLowerBound);
            positions.add((Object)futureUpperBound);
        }
        HashSet<Integer> invalidPositions = new HashSet<Integer>();
        Iterables.addAll(invalidPositions, (Iterable)Iterables.filter((Iterable)positions, (Predicate)new Predicate<Integer>((Multiset)positions){
            private final /* synthetic */ Multiset val$positions;
            {
                this.val$positions = multiset;
            }

            public boolean apply(Integer input) {
                int count = this.val$positions.count((Object)input);
                return count != 1;
            }
        }));
        return invalidPositions;
    }
}

