/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.AbstractLostElementDataWithTarget;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.ILostElementDataContainer;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostDiagramData;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostEdgeData;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostNodeData;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public final class LostElementFactory {
    private LostElementFactory() {
    }

    public static LostNodeData createLostNodeData(DDiagramElement diagramElement) {
        Option<? extends RepresentationElementMapping> mapping = new DDiagramElementQuery(diagramElement).getMapping();
        LostNodeData data = new LostNodeData();
        data.setTarget(diagramElement.getTarget());
        data.setMapping((RepresentationElementMapping)mapping.get());
        data.setParentData(LostElementFactory.createLostNodeParentData(diagramElement));
        return data;
    }

    public static LostEdgeData createLostEdgeData(DDiagramElement diagramElement) {
        Option<? extends RepresentationElementMapping> mapping = new DDiagramElementQuery(diagramElement).getMapping();
        LostEdgeData data = new LostEdgeData();
        data.setTarget(diagramElement.getTarget());
        data.setMapping((RepresentationElementMapping)mapping.get());
        EdgeTarget sourceNode = ((DEdge)diagramElement).getSourceNode();
        EdgeTarget targetNode = ((DEdge)diagramElement).getTargetNode();
        if (sourceNode instanceof DDiagramElement && LostElementFactory.isCompleteDiagramElement((DDiagramElement)sourceNode)) {
            LostNodeData sourceData = LostElementFactory.createLostNodeData((DDiagramElement)sourceNode);
            data.setSourceData(sourceData);
            if (targetNode instanceof DDiagramElement && LostElementFactory.isCompleteDiagramElement((DDiagramElement)targetNode)) {
                LostNodeData targetData = LostElementFactory.createLostNodeData((DDiagramElement)targetNode);
                data.setTargetData(targetData);
            }
        }
        return data;
    }

    public static boolean isCompleteDiagramElement(DDiagramElement diagElement) {
        return diagElement != null && diagElement.getDiagramElementMapping() != null && diagElement.getTarget() != null && !diagElement.getTarget().eIsProxy();
    }

    private static ILostElementDataContainer createLostNodeParentData(DDiagramElement diagElement) {
        EObject eContainer = diagElement.eContainer();
        AbstractLostElementDataWithTarget parent = null;
        if (eContainer != null) {
            DDiagramElement containerDiagramElement;
            if (eContainer instanceof DDiagram) {
                LostDiagramData parentData = new LostDiagramData();
                if (eContainer instanceof DSemanticDecorator) {
                    parentData.setTarget(((DSemanticDecorator)eContainer).getTarget());
                }
                parent = parentData;
            } else if (eContainer instanceof DDiagramElement && LostElementFactory.isCompleteDiagramElement(containerDiagramElement = (DDiagramElement)eContainer)) {
                parent = LostElementFactory.createLostNodeData(containerDiagramElement);
            }
        }
        return parent;
    }
}

